"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.issueCommand = issueCommand;
const node_os_1 = require("node:os");
const utils_1 = require("./utils");
class Command {
    command;
    properties;
    message;
    constructor(command, properties, message) {
        this.command = command;
        this.properties = properties;
        this.message = message;
    }
    toString() {
        let cmdStr = `::${this.command}`;
        if (Object.keys(this.properties).length > 0) {
            const properties = Object.entries(this.properties)
                .filter(([key, val]) => Object.hasOwn(this.properties, key) && val)
                .map(([key, val]) => `${key}=${(0, utils_1.escapeProperty)(val)}`)
                .join(',');
            cmdStr += ` ${properties}`;
        }
        cmdStr += `::${(0, utils_1.escapeData)(this.message)}`;
        return cmdStr;
    }
}
function issueCommand(command, properties = {}, message = '') {
    const cmd = new Command(command, properties, message);
    return cmd.toString() + node_os_1.EOL;
}
//# sourceMappingURL=command.js.map