import basem = require('./ClientApiBases');
import VsoBaseInterfaces = require('./interfaces/common/VsoBaseInterfaces');
import PipelinesInterfaces = require("./interfaces/PipelinesInterfaces");
export interface IPipelinesApi extends basem.ClientApiBase {
    getArtifact(project: string, pipelineId: number, runId: number, artifactName: string, expand?: PipelinesInterfaces.GetArtifactExpandOptions): Promise<PipelinesInterfaces.Artifact>;
    getLog(project: string, pipelineId: number, runId: number, logId: number, expand?: PipelinesInterfaces.GetLogExpandOptions): Promise<PipelinesInterfaces.Log>;
    listLogs(project: string, pipelineId: number, runId: number, expand?: PipelinesInterfaces.GetLogExpandOptions): Promise<PipelinesInterfaces.LogCollection>;
    createPipeline(inputParameters: PipelinesInterfaces.CreatePipelineParameters, project: string): Promise<PipelinesInterfaces.Pipeline>;
    getPipeline(project: string, pipelineId: number, pipelineVersion?: number): Promise<PipelinesInterfaces.Pipeline>;
    listPipelines(project: string, orderBy?: string, top?: number, continuationToken?: string): Promise<PipelinesInterfaces.Pipeline[]>;
    preview(runParameters: PipelinesInterfaces.RunPipelineParameters, project: string, pipelineId: number, pipelineVersion?: number): Promise<PipelinesInterfaces.PreviewRun>;
    getRun(project: string, pipelineId: number, runId: number): Promise<PipelinesInterfaces.Run>;
    listRuns(project: string, pipelineId: number): Promise<PipelinesInterfaces.Run[]>;
    runPipeline(runParameters: PipelinesInterfaces.RunPipelineParameters, project: string, pipelineId: number, pipelineVersion?: number): Promise<PipelinesInterfaces.Run>;
}
export declare class PipelinesApi extends basem.ClientApiBase implements IPipelinesApi {
    constructor(baseUrl: string, handlers: VsoBaseInterfaces.IRequestHandler[], options?: VsoBaseInterfaces.IRequestOptions, userAgent?: string);
    /**
     * Get a specific artifact from a pipeline run
     *
     * @param {string} project - Project ID or project name
     * @param {number} pipelineId - ID of the pipeline.
     * @param {number} runId - ID of the run of that pipeline.
     * @param {string} artifactName - Name of the artifact.
     * @param {PipelinesInterfaces.GetArtifactExpandOptions} expand - Expand options. Default is None.
     */
    getArtifact(project: string, pipelineId: number, runId: number, artifactName: string, expand?: PipelinesInterfaces.GetArtifactExpandOptions): Promise<PipelinesInterfaces.Artifact>;
    /**
     * Get a specific log from a pipeline run
     *
     * @param {string} project - Project ID or project name
     * @param {number} pipelineId - ID of the pipeline.
     * @param {number} runId - ID of the run of that pipeline.
     * @param {number} logId - ID of the log.
     * @param {PipelinesInterfaces.GetLogExpandOptions} expand - Expand options. Default is None.
     */
    getLog(project: string, pipelineId: number, runId: number, logId: number, expand?: PipelinesInterfaces.GetLogExpandOptions): Promise<PipelinesInterfaces.Log>;
    /**
     * Get a list of logs from a pipeline run.
     *
     * @param {string} project - Project ID or project name
     * @param {number} pipelineId - ID of the pipeline.
     * @param {number} runId - ID of the run of that pipeline.
     * @param {PipelinesInterfaces.GetLogExpandOptions} expand - Expand options. Default is None.
     */
    listLogs(project: string, pipelineId: number, runId: number, expand?: PipelinesInterfaces.GetLogExpandOptions): Promise<PipelinesInterfaces.LogCollection>;
    /**
     * Create a pipeline.
     *
     * @param {PipelinesInterfaces.CreatePipelineParameters} inputParameters - Input parameters.
     * @param {string} project - Project ID or project name
     */
    createPipeline(inputParameters: PipelinesInterfaces.CreatePipelineParameters, project: string): Promise<PipelinesInterfaces.Pipeline>;
    /**
     * Gets a pipeline, optionally at the specified version
     *
     * @param {string} project - Project ID or project name
     * @param {number} pipelineId - The pipeline ID
     * @param {number} pipelineVersion - The pipeline version
     */
    getPipeline(project: string, pipelineId: number, pipelineVersion?: number): Promise<PipelinesInterfaces.Pipeline>;
    /**
     * Get a list of pipelines.
     *
     * @param {string} project - Project ID or project name
     * @param {string} orderBy - A sort expression. Defaults to "name asc"
     * @param {number} top - The maximum number of pipelines to return
     * @param {string} continuationToken - A continuation token from a previous request, to retrieve the next page of results
     */
    listPipelines(project: string, orderBy?: string, top?: number, continuationToken?: string): Promise<PipelinesInterfaces.Pipeline[]>;
    /**
     * Queues a dry run of the pipeline and returns an object containing the final yaml.
     *
     * @param {PipelinesInterfaces.RunPipelineParameters} runParameters - Optional additional parameters for this run.
     * @param {string} project - Project ID or project name
     * @param {number} pipelineId - The pipeline ID.
     * @param {number} pipelineVersion - The pipeline version.
     */
    preview(runParameters: PipelinesInterfaces.RunPipelineParameters, project: string, pipelineId: number, pipelineVersion?: number): Promise<PipelinesInterfaces.PreviewRun>;
    /**
     * Gets a run for a particular pipeline.
     *
     * @param {string} project - Project ID or project name
     * @param {number} pipelineId - The pipeline id
     * @param {number} runId - The run id
     */
    getRun(project: string, pipelineId: number, runId: number): Promise<PipelinesInterfaces.Run>;
    /**
     * Gets top 10000 runs for a particular pipeline.
     *
     * @param {string} project - Project ID or project name
     * @param {number} pipelineId - The pipeline id
     */
    listRuns(project: string, pipelineId: number): Promise<PipelinesInterfaces.Run[]>;
    /**
     * Runs a pipeline.
     *
     * @param {PipelinesInterfaces.RunPipelineParameters} runParameters - Optional additional parameters for this run.
     * @param {string} project - Project ID or project name
     * @param {number} pipelineId - The pipeline ID.
     * @param {number} pipelineVersion - The pipeline version.
     */
    runPipeline(runParameters: PipelinesInterfaces.RunPipelineParameters, project: string, pipelineId: number, pipelineVersion?: number): Promise<PipelinesInterfaces.Run>;
}
