"use strict";
/*
 * ---------------------------------------------------------
 * Copyright(C) Microsoft Corporation. All rights reserved.
 * ---------------------------------------------------------
 *
 * ---------------------------------------------------------
 * Generated file, DO NOT EDIT
 * ---------------------------------------------------------
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CixApi = void 0;
const basem = require("./ClientApiBases");
class CixApi extends basem.ClientApiBase {
    constructor(baseUrl, handlers, options, userAgent) {
        super(baseUrl, handlers, userAgent || 'node-Pipelines-api', options);
    }
    /**
     * Gets a list of existing configuration files for the given repository.
     *
     * @param {string} project - Project ID or project name
     * @param {string} repositoryType - The type of the repository such as GitHub, TfsGit (i.e. Azure Repos), Bitbucket, etc.
     * @param {string} repositoryId - The vendor-specific identifier or the name of the repository, e.g. Microsoft/vscode (GitHub) or e9d82045-ddba-4e01-a63d-2ab9f040af62 (Azure Repos)
     * @param {string} branch - The repository branch where to look for the configuration file.
     * @param {string} serviceConnectionId - If specified, the ID of the service endpoint to query. Can only be omitted for providers that do not use service endpoints, e.g. TfsGit (i.e. Azure Repos).
     */
    getConfigurations(project, repositoryType, repositoryId, branch, serviceConnectionId) {
        return __awaiter(this, void 0, void 0, function* () {
            return new Promise((resolve, reject) => __awaiter(this, void 0, void 0, function* () {
                let routeValues = {
                    project: project
                };
                let queryValues = {
                    repositoryType: repositoryType,
                    repositoryId: repositoryId,
                    branch: branch,
                    serviceConnectionId: serviceConnectionId,
                };
                try {
                    let verData = yield this.vsoClient.getVersioningData("7.2-preview.1", "pipelines", "8fc87684-9ebc-4c37-ab92-f4ac4a58cb3a", routeValues, queryValues);
                    let url = verData.requestUrl;
                    let options = this.createRequestOptions('application/json', verData.apiVersion);
                    let res;
                    res = yield this.rest.get(url, options);
                    let ret = this.formatResponse(res.result, null, true);
                    resolve(ret);
                }
                catch (err) {
                    reject(err);
                }
            }));
        });
    }
    /**
     * Creates a new Pipeline connection between the provider installation and the specified project. Returns the PipelineConnection object created.
     *
     * @param {CIXInterfaces.CreatePipelineConnectionInputs} createConnectionInputs
     * @param {string} project
     */
    createProjectConnection(createConnectionInputs, project) {
        return __awaiter(this, void 0, void 0, function* () {
            if (project == null) {
                throw new TypeError('project can not be null or undefined');
            }
            return new Promise((resolve, reject) => __awaiter(this, void 0, void 0, function* () {
                let routeValues = {};
                let queryValues = {
                    project: project,
                };
                try {
                    let verData = yield this.vsoClient.getVersioningData("7.2-preview.1", "pipelines", "00df4879-9216-45d5-b38d-4a487b626b2c", routeValues, queryValues);
                    let url = verData.requestUrl;
                    let options = this.createRequestOptions('application/json', verData.apiVersion);
                    let res;
                    res = yield this.rest.create(url, createConnectionInputs, options);
                    let ret = this.formatResponse(res.result, null, false);
                    resolve(ret);
                }
                catch (err) {
                    reject(err);
                }
            }));
        });
    }
    /**
     * Returns a list of build frameworks that best match the given repository based on its contents.
     *
     * @param {string} project - Project ID or project name
     * @param {string} repositoryType - The type of the repository such as GitHub, TfsGit (i.e. Azure Repos), Bitbucket, etc.
     * @param {string} repositoryId - The vendor-specific identifier or the name of the repository, e.g. Microsoft/vscode (GitHub) or e9d82045-ddba-4e01-a63d-2ab9f040af62 (Azure Repos)
     * @param {string} branch - The repository branch to detect build frameworks for.
     * @param {CIXInterfaces.BuildFrameworkDetectionType} detectionType
     * @param {string} serviceConnectionId - If specified, the ID of the service endpoint to query. Can only be omitted for providers that do not use service endpoints, e.g. TfsGit (i.e. Azure Repos).
     */
    getDetectedBuildFrameworks(project, repositoryType, repositoryId, branch, detectionType, serviceConnectionId) {
        return __awaiter(this, void 0, void 0, function* () {
            return new Promise((resolve, reject) => __awaiter(this, void 0, void 0, function* () {
                let routeValues = {
                    project: project
                };
                let queryValues = {
                    repositoryType: repositoryType,
                    repositoryId: repositoryId,
                    branch: branch,
                    detectionType: detectionType,
                    serviceConnectionId: serviceConnectionId,
                };
                try {
                    let verData = yield this.vsoClient.getVersioningData("7.2-preview.1", "pipelines", "29a30bab-9efb-4652-bf1b-9269baca0980", routeValues, queryValues);
                    let url = verData.requestUrl;
                    let options = this.createRequestOptions('application/json', verData.apiVersion);
                    let res;
                    res = yield this.rest.get(url, options);
                    let ret = this.formatResponse(res.result, null, true);
                    resolve(ret);
                }
                catch (err) {
                    reject(err);
                }
            }));
        });
    }
    /**
     * @param {{ [key: string] : CIXInterfaces.ResourceCreationParameter; }} creationParameters
     * @param {string} project - Project ID or project name
     */
    createResources(creationParameters, project) {
        return __awaiter(this, void 0, void 0, function* () {
            return new Promise((resolve, reject) => __awaiter(this, void 0, void 0, function* () {
                let routeValues = {
                    project: project
                };
                try {
                    let verData = yield this.vsoClient.getVersioningData("7.2-preview.1", "pipelines", "43201899-7690-4870-9c79-ab69605f21ed", routeValues);
                    let url = verData.requestUrl;
                    let options = this.createRequestOptions('application/json', verData.apiVersion);
                    let res;
                    res = yield this.rest.create(url, creationParameters, options);
                    let ret = this.formatResponse(res.result, null, false);
                    resolve(ret);
                }
                catch (err) {
                    reject(err);
                }
            }));
        });
    }
}
exports.CixApi = CixApi;
