import basem = require('./ClientApiBases');
import VsoBaseInterfaces = require('./interfaces/common/VsoBaseInterfaces');
import CIXInterfaces = require("./interfaces/CIXInterfaces");
export interface ICixApi extends basem.ClientApiBase {
    getConfigurations(project: string, repositoryType?: string, repositoryId?: string, branch?: string, serviceConnectionId?: string): Promise<CIXInterfaces.ConfigurationFile[]>;
    createProjectConnection(createConnectionInputs: CIXInterfaces.CreatePipelineConnectionInputs, project: string): Promise<CIXInterfaces.PipelineConnection>;
    getDetectedBuildFrameworks(project: string, repositoryType?: string, repositoryId?: string, branch?: string, detectionType?: CIXInterfaces.BuildFrameworkDetectionType, serviceConnectionId?: string): Promise<CIXInterfaces.DetectedBuildFramework[]>;
    createResources(creationParameters: {
        [key: string]: CIXInterfaces.ResourceCreationParameter;
    }, project: string): Promise<CIXInterfaces.CreatedResources>;
}
export declare class CixApi extends basem.ClientApiBase implements ICixApi {
    constructor(baseUrl: string, handlers: VsoBaseInterfaces.IRequestHandler[], options?: VsoBaseInterfaces.IRequestOptions, userAgent?: string);
    /**
     * Gets a list of existing configuration files for the given repository.
     *
     * @param {string} project - Project ID or project name
     * @param {string} repositoryType - The type of the repository such as GitHub, TfsGit (i.e. Azure Repos), Bitbucket, etc.
     * @param {string} repositoryId - The vendor-specific identifier or the name of the repository, e.g. Microsoft/vscode (GitHub) or e9d82045-ddba-4e01-a63d-2ab9f040af62 (Azure Repos)
     * @param {string} branch - The repository branch where to look for the configuration file.
     * @param {string} serviceConnectionId - If specified, the ID of the service endpoint to query. Can only be omitted for providers that do not use service endpoints, e.g. TfsGit (i.e. Azure Repos).
     */
    getConfigurations(project: string, repositoryType?: string, repositoryId?: string, branch?: string, serviceConnectionId?: string): Promise<CIXInterfaces.ConfigurationFile[]>;
    /**
     * Creates a new Pipeline connection between the provider installation and the specified project. Returns the PipelineConnection object created.
     *
     * @param {CIXInterfaces.CreatePipelineConnectionInputs} createConnectionInputs
     * @param {string} project
     */
    createProjectConnection(createConnectionInputs: CIXInterfaces.CreatePipelineConnectionInputs, project: string): Promise<CIXInterfaces.PipelineConnection>;
    /**
     * Returns a list of build frameworks that best match the given repository based on its contents.
     *
     * @param {string} project - Project ID or project name
     * @param {string} repositoryType - The type of the repository such as GitHub, TfsGit (i.e. Azure Repos), Bitbucket, etc.
     * @param {string} repositoryId - The vendor-specific identifier or the name of the repository, e.g. Microsoft/vscode (GitHub) or e9d82045-ddba-4e01-a63d-2ab9f040af62 (Azure Repos)
     * @param {string} branch - The repository branch to detect build frameworks for.
     * @param {CIXInterfaces.BuildFrameworkDetectionType} detectionType
     * @param {string} serviceConnectionId - If specified, the ID of the service endpoint to query. Can only be omitted for providers that do not use service endpoints, e.g. TfsGit (i.e. Azure Repos).
     */
    getDetectedBuildFrameworks(project: string, repositoryType?: string, repositoryId?: string, branch?: string, detectionType?: CIXInterfaces.BuildFrameworkDetectionType, serviceConnectionId?: string): Promise<CIXInterfaces.DetectedBuildFramework[]>;
    /**
     * @param {{ [key: string] : CIXInterfaces.ResourceCreationParameter; }} creationParameters
     * @param {string} project - Project ID or project name
     */
    createResources(creationParameters: {
        [key: string]: CIXInterfaces.ResourceCreationParameter;
    }, project: string): Promise<CIXInterfaces.CreatedResources>;
}
