"use strict";
/*
 * ---------------------------------------------------------
 * Copyright(C) Microsoft Corporation. All rights reserved.
 * ---------------------------------------------------------
 *
 * ---------------------------------------------------------
 * Generated file, DO NOT EDIT
 * ---------------------------------------------------------
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AlertApi = void 0;
const basem = require("./ClientApiBases");
const AlertInterfaces = require("./interfaces/AlertInterfaces");
class AlertApi extends basem.ClientApiBase {
    constructor(baseUrl, handlers, options, userAgent) {
        super(baseUrl, handlers, userAgent || 'node-Alert-api', options);
    }
    /**
     * Get an alert.
     *
     * @param {string} project - Project ID or project name
     * @param {number} alertId - ID of alert to retrieve
     * @param {string} repository - Name or id  of a repository that alert is part of
     * @param {string} ref
     * @param {AlertInterfaces.ExpandOption} expand - Expand alert attributes. Possible options are {ValidationFingerprint, None}
     */
    getAlert(project, alertId, repository, ref, expand) {
        return __awaiter(this, void 0, void 0, function* () {
            return new Promise((resolve, reject) => __awaiter(this, void 0, void 0, function* () {
                let routeValues = {
                    project: project,
                    alertId: alertId,
                    repository: repository
                };
                let queryValues = {
                    ref: ref,
                    expand: expand,
                };
                try {
                    let verData = yield this.vsoClient.getVersioningData("7.2-preview.1", "Alert", "e21b4630-b7d2-4031-99e3-3ad328cc4a7f", routeValues, queryValues);
                    let url = verData.requestUrl;
                    let options = this.createRequestOptions('application/json', verData.apiVersion);
                    let res;
                    res = yield this.rest.get(url, options);
                    let ret = this.formatResponse(res.result, AlertInterfaces.TypeInfo.Alert, false);
                    resolve(ret);
                }
                catch (err) {
                    reject(err);
                }
            }));
        });
    }
    /**
     * Get alerts for a repository
     *
     * @param {string} project - Project ID or project name
     * @param {string} repository - The name or ID of the repository
     * @param {number} top - The maximum number of alerts to return
     * @param {string} orderBy - Must be "id" "firstSeen" "lastSeen" "fixedOn" or "severity"  Defaults to "id"
     * @param {AlertInterfaces.SearchCriteria} criteria - Options to limit the alerts returned
     * @param {AlertInterfaces.AlertListExpandOption} expand
     * @param {string} continuationToken - If there are more alerts than can be returned, a continuation token is placed in the "x-ms-continuationtoken" header.  Use that token here to get the next page of alerts
     */
    getAlerts(project, repository, top, orderBy, criteria, expand, continuationToken) {
        return __awaiter(this, void 0, void 0, function* () {
            return new Promise((resolve, reject) => __awaiter(this, void 0, void 0, function* () {
                let routeValues = {
                    project: project,
                    repository: repository
                };
                let queryValues = {
                    top: top,
                    orderBy: orderBy,
                    criteria: criteria,
                    expand: expand,
                    continuationToken: continuationToken,
                };
                try {
                    let verData = yield this.vsoClient.getVersioningData("7.2-preview.1", "Alert", "e21b4630-b7d2-4031-99e3-3ad328cc4a7f", routeValues, queryValues);
                    let url = verData.requestUrl;
                    let options = this.createRequestOptions('application/json', verData.apiVersion);
                    let res;
                    res = yield this.rest.get(url, options);
                    let ret = this.formatResponse(res.result, AlertInterfaces.TypeInfo.Alert, true);
                    resolve(ret);
                }
                catch (err) {
                    reject(err);
                }
            }));
        });
    }
    /**
     * Get an alert.
     *
     * @param {string} project - Project ID or project name
     * @param {number} alertId - ID of alert to retrieve
     * @param {string} repository - Name or id  of a repository that alert is part of
     * @param {string} ref
     * @param {AlertInterfaces.ExpandOption} expand - Expand alert attributes. Possible options are {ValidationFingerprint, None}
     */
    getAlertSarif(project, alertId, repository, ref, expand) {
        return __awaiter(this, void 0, void 0, function* () {
            return new Promise((resolve, reject) => __awaiter(this, void 0, void 0, function* () {
                let routeValues = {
                    project: project,
                    alertId: alertId,
                    repository: repository
                };
                let queryValues = {
                    ref: ref,
                    expand: expand,
                };
                try {
                    let verData = yield this.vsoClient.getVersioningData("7.2-preview.1", "Alert", "e21b4630-b7d2-4031-99e3-3ad328cc4a7f", routeValues, queryValues);
                    let url = verData.requestUrl;
                    let options = this.createRequestOptions('application/json', verData.apiVersion);
                    let res;
                    res = yield this.rest.get(url, options);
                    let ret = this.formatResponse(res.result, null, false);
                    resolve(ret);
                }
                catch (err) {
                    reject(err);
                }
            }));
        });
    }
    /**
     * Update the status of an alert
     *
     * @param {AlertInterfaces.AlertStateUpdate} stateUpdate - The new status of the alert
     * @param {string} project - Project ID or project name
     * @param {number} alertId - The ID of the alert
     * @param {string} repository - The name or ID of the repository
     */
    updateAlert(stateUpdate, project, alertId, repository) {
        return __awaiter(this, void 0, void 0, function* () {
            return new Promise((resolve, reject) => __awaiter(this, void 0, void 0, function* () {
                let routeValues = {
                    project: project,
                    alertId: alertId,
                    repository: repository
                };
                try {
                    let verData = yield this.vsoClient.getVersioningData("7.2-preview.1", "Alert", "e21b4630-b7d2-4031-99e3-3ad328cc4a7f", routeValues);
                    let url = verData.requestUrl;
                    let options = this.createRequestOptions('application/json', verData.apiVersion);
                    let res;
                    res = yield this.rest.update(url, stateUpdate, options);
                    let ret = this.formatResponse(res.result, AlertInterfaces.TypeInfo.Alert, false);
                    resolve(ret);
                }
                catch (err) {
                    reject(err);
                }
            }));
        });
    }
    /**
     * Returns the branches for which analysis results were submitted.
     *
     * @param {string} project - Project ID or project name
     * @param {string} repository
     * @param {AlertInterfaces.AlertType} alertType - The type of alert: Dependency Scanning (1), Secret (2), Code QL (3), etc.
     * @param {string} continuationToken - A string variable that represents the branch name and is used to fetch branches that follow it in alphabetical order.
     * @param {string} branchNameContains - A string variable used to fetch branches that contain this string anywhere in the branch name, case insensitive.
     * @param {number} top - An int variable used to return the top k branches that satisfy the search criteria.
     * @param {boolean} includePullRequestBranches - A bool variable indicating whether or not to include pull request branches.
     */
    getBranches(project, repository, alertType, continuationToken, branchNameContains, top, includePullRequestBranches) {
        return __awaiter(this, void 0, void 0, function* () {
            if (alertType == null) {
                throw new TypeError('alertType can not be null or undefined');
            }
            return new Promise((resolve, reject) => __awaiter(this, void 0, void 0, function* () {
                let routeValues = {
                    action: "Branches",
                    project: project,
                    repository: repository
                };
                let queryValues = {
                    alertType: alertType,
                    continuationToken: continuationToken,
                    branchNameContains: branchNameContains,
                    top: top,
                    includePullRequestBranches: includePullRequestBranches,
                };
                try {
                    let verData = yield this.vsoClient.getVersioningData("7.2-preview.1", "Alert", "8f90675b-f794-434d-8f2c-cfae0a11c02a", routeValues, queryValues);
                    let url = verData.requestUrl;
                    let options = this.createRequestOptions('application/json', verData.apiVersion);
                    let res;
                    res = yield this.rest.get(url, options);
                    let ret = this.formatResponse(res.result, AlertInterfaces.TypeInfo.Branch, true);
                    resolve(ret);
                }
                catch (err) {
                    reject(err);
                }
            }));
        });
    }
    /**
     * @param {string} project - Project ID or project name
     * @param {string} repository
     * @param {AlertInterfaces.AlertType} alertType
     */
    getUxFilters(project, repository, alertType) {
        return __awaiter(this, void 0, void 0, function* () {
            if (alertType == null) {
                throw new TypeError('alertType can not be null or undefined');
            }
            return new Promise((resolve, reject) => __awaiter(this, void 0, void 0, function* () {
                let routeValues = {
                    action: "Default",
                    project: project,
                    repository: repository
                };
                let queryValues = {
                    alertType: alertType,
                };
                try {
                    let verData = yield this.vsoClient.getVersioningData("7.2-preview.1", "Alert", "8f90675b-f794-434d-8f2c-cfae0a11c02a", routeValues, queryValues);
                    let url = verData.requestUrl;
                    let options = this.createRequestOptions('application/json', verData.apiVersion);
                    let res;
                    res = yield this.rest.get(url, options);
                    let ret = this.formatResponse(res.result, AlertInterfaces.TypeInfo.UxFilters, false);
                    resolve(ret);
                }
                catch (err) {
                    reject(err);
                }
            }));
        });
    }
    /**
     * Get instances of an alert on a branch specified with @ref. If @ref is not provided, return instances of an alert on default branch(if the alert exist in default branch) or latest affected branch.
     *
     * @param {string} project - Project ID or project name
     * @param {number} alertId - ID of alert to retrieve
     * @param {string} repository - Name or id of a repository that alert is part of
     * @param {string} ref
     */
    getAlertInstances(project, alertId, repository, ref) {
        return __awaiter(this, void 0, void 0, function* () {
            return new Promise((resolve, reject) => __awaiter(this, void 0, void 0, function* () {
                let routeValues = {
                    project: project,
                    alertId: alertId,
                    repository: repository
                };
                let queryValues = {
                    ref: ref,
                };
                try {
                    let verData = yield this.vsoClient.getVersioningData("7.2-preview.1", "Alert", "f451ba96-0e95-458a-8dd5-3df894770a49", routeValues, queryValues);
                    let url = verData.requestUrl;
                    let options = this.createRequestOptions('application/json', verData.apiVersion);
                    let res;
                    res = yield this.rest.get(url, options);
                    let ret = this.formatResponse(res.result, AlertInterfaces.TypeInfo.AlertAnalysisInstance, true);
                    resolve(ret);
                }
                catch (err) {
                    reject(err);
                }
            }));
        });
    }
    /**
     * Create legal review. This creates the legal review associated with the alert. It include the review work item url.
     *
     * @param {string} project - Project ID or project name
     * @param {string} repository - Name or id  of a repository for the legal alert
     * @param {number} alertId - Advance Security alert id of the legal alert to get the legal review
     * @param {string} ref
     */
    createLegalReview(project, repository, alertId, ref) {
        return __awaiter(this, void 0, void 0, function* () {
            if (alertId == null) {
                throw new TypeError('alertId can not be null or undefined');
            }
            return new Promise((resolve, reject) => __awaiter(this, void 0, void 0, function* () {
                let routeValues = {
                    project: project,
                    repository: repository
                };
                let queryValues = {
                    alertId: alertId,
                    ref: ref,
                };
                try {
                    let verData = yield this.vsoClient.getVersioningData("7.2-preview.1", "Alert", "65de4b84-7519-4ae8-8623-175f79b49b80", routeValues, queryValues);
                    let url = verData.requestUrl;
                    let options = this.createRequestOptions('application/json', verData.apiVersion);
                    let res;
                    res = yield this.rest.create(url, null, options);
                    let ret = this.formatResponse(res.result, null, false);
                    resolve(ret);
                }
                catch (err) {
                    reject(err);
                }
            }));
        });
    }
    /**
     * Update alert metadata associations.
     *
     * @param {AlertInterfaces.AlertMetadata[]} alertsMetadata - A list of metadata to associate with alerts.
     * @param {string} project - Project ID or project name
     * @param {string} repository - The name or ID of the repository.
     */
    updateAlertsMetadata(alertsMetadata, project, repository) {
        return __awaiter(this, void 0, void 0, function* () {
            return new Promise((resolve, reject) => __awaiter(this, void 0, void 0, function* () {
                let routeValues = {
                    project: project,
                    repository: repository
                };
                try {
                    let verData = yield this.vsoClient.getVersioningData("7.2-preview.1", "Alert", "65de4b84-7519-4ae8-8623-175f79b49b80", routeValues);
                    let url = verData.requestUrl;
                    let options = this.createRequestOptions('application/json', verData.apiVersion);
                    let res;
                    res = yield this.rest.update(url, alertsMetadata, options);
                    let ret = this.formatResponse(res.result, AlertInterfaces.TypeInfo.AlertMetadataChange, true);
                    resolve(ret);
                }
                catch (err) {
                    reject(err);
                }
            }));
        });
    }
    /**
     * Upload a Sarif containing security alerts
     *
     * @param {NodeJS.ReadableStream} contentStream - Content to upload
     * @param {string} project - Project ID or project name
     * @param {string} repository - The name or ID of a repository
     * @param {String} notificationFlag - Header to signal that this is a progress notification
     */
    uploadSarif(customHeaders, contentStream, project, repository, notificationFlag) {
        return __awaiter(this, void 0, void 0, function* () {
            return new Promise((resolve, reject) => __awaiter(this, void 0, void 0, function* () {
                let routeValues = {
                    project: project,
                    repository: repository
                };
                customHeaders = customHeaders || {};
                customHeaders["Content-Type"] = "application/octet-stream";
                customHeaders["X-AdvSec-NotificationSarif"] = "notificationFlag";
                try {
                    let verData = yield this.vsoClient.getVersioningData("7.2-preview.1", "Alert", "2a141cae-a50d-4c22-b41b-13f77748d035", routeValues);
                    let url = verData.requestUrl;
                    let options = this.createRequestOptions('application/json', verData.apiVersion);
                    options.additionalHeaders = customHeaders;
                    let res;
                    res = yield this.rest.uploadStream("POST", url, contentStream, options);
                    let ret = this.formatResponse(res.result, null, false);
                    resolve(ret);
                }
                catch (err) {
                    reject(err);
                }
            }));
        });
    }
    /**
     * Get the status of the Sarif processing job
     *
     * @param {number} sarifId - Sarif ID returned when the Sarif was uploaded
     */
    getSarif(sarifId) {
        return __awaiter(this, void 0, void 0, function* () {
            return new Promise((resolve, reject) => __awaiter(this, void 0, void 0, function* () {
                let routeValues = {
                    sarifId: sarifId
                };
                try {
                    let verData = yield this.vsoClient.getVersioningData("7.2-preview.2", "Alert", "a04689e7-0f81-48a2-8d18-40654c47494c", routeValues);
                    let url = verData.requestUrl;
                    let options = this.createRequestOptions('application/json', verData.apiVersion);
                    let res;
                    res = yield this.rest.get(url, options);
                    let ret = this.formatResponse(res.result, AlertInterfaces.TypeInfo.SarifUploadStatus, false);
                    resolve(ret);
                }
                catch (err) {
                    reject(err);
                }
            }));
        });
    }
    /**
     * Get the validity details for an alert.
     *
     * @param {string} project - Project ID or project name
     * @param {string} repository - The name or ID of a repository
     * @param {number} alertId - The ID of the alert
     */
    getValidityData(project, repository, alertId) {
        return __awaiter(this, void 0, void 0, function* () {
            return new Promise((resolve, reject) => __awaiter(this, void 0, void 0, function* () {
                let routeValues = {
                    project: project,
                    repository: repository,
                    alertId: alertId
                };
                try {
                    let verData = yield this.vsoClient.getVersioningData("7.2-preview.1", "Alert", "2e022520-3508-4b5f-9855-acb954d673ba", routeValues);
                    let url = verData.requestUrl;
                    let options = this.createRequestOptions('application/json', verData.apiVersion);
                    let res;
                    res = yield this.rest.get(url, options);
                    let ret = this.formatResponse(res.result, AlertInterfaces.TypeInfo.ValidationRequestInfo, false);
                    resolve(ret);
                }
                catch (err) {
                    reject(err);
                }
            }));
        });
    }
    /**
     * Initiate the validation process for a given alert
     *
     * @param {string} project - Project ID or project name
     * @param {string} repository - The name or ID of a repository
     * @param {number} alertId - The ID of the alert
     */
    initiateValidation(project, repository, alertId) {
        return __awaiter(this, void 0, void 0, function* () {
            return new Promise((resolve, reject) => __awaiter(this, void 0, void 0, function* () {
                let routeValues = {
                    project: project,
                    repository: repository,
                    alertId: alertId
                };
                try {
                    let verData = yield this.vsoClient.getVersioningData("7.2-preview.1", "Alert", "2e022520-3508-4b5f-9855-acb954d673ba", routeValues);
                    let url = verData.requestUrl;
                    let options = this.createRequestOptions('application/json', verData.apiVersion);
                    let res;
                    res = yield this.rest.create(url, null, options);
                    let ret = this.formatResponse(res.result, AlertInterfaces.TypeInfo.AlertValidationRequestStatus, false);
                    resolve(ret);
                }
                catch (err) {
                    reject(err);
                }
            }));
        });
    }
}
exports.AlertApi = AlertApi;
