import sinon from 'sinon';
import { isSinonStub } from './sinon';
import { AwsStub } from './awsClientStub';
/**
 * Creates and attaches a stub of the `Client#send()` method. Only this single method is mocked.
 * If method is already a stub, it's replaced.
 * @param client `Client` type or instance to replace the method
 * @param sandbox Optional sinon sandbox to use
 * @return Stub allowing to configure Client's behavior
 */
export var mockClient = function (client, _a) {
    var _b = _a === void 0 ? {} : _a, sandbox = _b.sandbox;
    var instance = isClientInstance(client) ? client : client.prototype;
    var send = instance.send;
    if (isSinonStub(send)) {
        send.restore();
    }
    var sinonSandbox = sandbox || sinon;
    var sendStub = sinonSandbox.stub(instance, 'send');
    // eslint-disable-next-line @typescript-eslint/no-unsafe-argument
    return new AwsStub(instance, sendStub);
};
/**
 * Type guard to differentiate `Client` instance from a type.
 */
var isClientInstance = function (obj) {
    return obj.send !== undefined;
};
//# sourceMappingURL=mockClient.js.map