"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.unquote = exports.quote = exports.isScheme = exports.isToken = void 0;
var token = /^[^\u0000-\u001F\u007F()<>@,;:\\"/?={}\[\]\u0020\u0009]+$/;

var isToken = function isToken(str) {
  return typeof str === 'string' && token.test(str);
};

exports.isToken = isToken;
var isScheme = isToken;
exports.isScheme = isScheme;

var quote = function quote(str) {
  return `"${str.replace(/"/g, '\\"')}"`;
};

exports.quote = quote;

var unquote = function unquote(str) {
  return str.substr(1, str.length - 2).replace(/\\"/g, '"');
};

exports.unquote = unquote;
//# sourceMappingURL=util.js.map