"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getLibzipSync = getLibzipSync;
exports.getLibzipPromise = getLibzipPromise;
const tslib_1 = require("tslib");
const instance_1 = require("./instance");
const makeInterface_1 = require("./makeInterface");
tslib_1.__exportStar(require("./common"), exports);
let promise;
(0, instance_1.setFactory)(() => {
    throw new Error(`Zip methods must be called within the context of getLibzipPromise when operating under async-only environments`);
});
function getLibzipSync() {
    return (0, instance_1.getInstance)();
}
async function getLibzipPromise() {
    const instance = (0, instance_1.tryInstance)();
    if (typeof instance !== `undefined`)
        return instance;
    if (typeof promise !== `undefined`)
        return promise;
    return promise = Promise.resolve().then(() => tslib_1.__importStar(require(`./libzipAsync`))).then(async ({ default: createModule }) => {
        const emZip = await createModule();
        const libzip = (0, makeInterface_1.makeInterface)(emZip);
        promise = undefined;
        (0, instance_1.setFactory)(() => libzip);
        return (0, instance_1.getInstance)();
    });
}
