import { Configuration } from '@yarnpkg/core';
import { FakeFS, PortablePath } from '@yarnpkg/fslib';
import { ZipCompression, ZipFS } from '@yarnpkg/libzip';
import { TaskPool } from './TaskPool';
export type ConvertToZipPayload = {
    tmpFile: PortablePath;
    tgz: Buffer | Uint8Array;
    extractBufferOpts: ExtractBufferOptions;
    compressionLevel: ZipCompression;
};
export type ZipWorkerPool = TaskPool<ConvertToZipPayload, PortablePath>;
export declare function getDefaultTaskPool(): ZipWorkerPool;
export declare function getTaskPoolForConfiguration(configuration: Configuration | void): ZipWorkerPool;
export declare function convertToZipWorker(data: ConvertToZipPayload): Promise<PortablePath>;
export interface MakeArchiveFromDirectoryOptions {
    baseFs?: FakeFS<PortablePath>;
    prefixPath?: PortablePath | null;
    compressionLevel?: ZipCompression;
    inMemory?: boolean;
}
export declare function makeArchiveFromDirectory(source: PortablePath, { baseFs, prefixPath, compressionLevel, inMemory }?: MakeArchiveFromDirectoryOptions): Promise<ZipFS>;
export interface ExtractBufferOptions {
    prefixPath?: PortablePath;
    stripComponents?: number;
}
export interface ConvertToZipOptions extends ExtractBufferOptions {
    configuration?: Configuration;
    compressionLevel?: ZipCompression;
    taskPool?: ZipWorkerPool;
}
export declare function convertToZip(tgz: Buffer, opts?: ConvertToZipOptions): Promise<ZipFS>;
export declare function extractArchiveTo<T extends FakeFS<PortablePath>>(tgz: Buffer, targetFs: T, { stripComponents, prefixPath }?: ExtractBufferOptions): Promise<T>;
