"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getDefaultGlobalFolder = getDefaultGlobalFolder;
exports.getHomeFolder = getHomeFolder;
exports.isFolderInside = isFolderInside;
const fslib_1 = require("@yarnpkg/fslib");
const os_1 = require("os");
function getDefaultGlobalFolder() {
    if (process.platform === `win32`) {
        const base = fslib_1.npath.toPortablePath(process.env.LOCALAPPDATA || fslib_1.npath.join((0, os_1.homedir)(), `AppData`, `Local`));
        return fslib_1.ppath.resolve(base, `Yarn/Berry`);
    }
    if (process.env.XDG_DATA_HOME) {
        const base = fslib_1.npath.toPortablePath(process.env.XDG_DATA_HOME);
        return fslib_1.ppath.resolve(base, `yarn/berry`);
    }
    return fslib_1.ppath.resolve(getHomeFolder(), `.yarn/berry`);
}
function getHomeFolder() {
    return fslib_1.npath.toPortablePath((0, os_1.homedir)() || `/usr/local/share`);
}
function isFolderInside(target, parent) {
    const relative = fslib_1.ppath.relative(parent, target);
    return relative && !relative.startsWith(`..`) && !fslib_1.ppath.isAbsolute(relative);
}
