import { PortablePath } from '@yarnpkg/fslib';
import { HardDependencies, Manifest } from './Manifest';
import { Project } from './Project';
import { Descriptor, Locator } from './types';
export declare class Workspace {
    readonly project: Project;
    readonly cwd: PortablePath;
    readonly relativeCwd: PortablePath;
    readonly anchoredDescriptor: Descriptor;
    readonly anchoredLocator: Locator;
    readonly workspacesCwds: Set<PortablePath>;
    manifest: Manifest;
    constructor(workspaceCwd: PortablePath, { project }: {
        project: Project;
    });
    setup(): Promise<void>;
    get anchoredPackage(): import("./types").Package;
    accepts(range: string): boolean;
    computeCandidateName(): string;
    /**
     * Find workspaces marked as dependencies/devDependencies of the current workspace recursively.
     *
     * @param rootWorkspace root workspace
     * @param project project
     *
     * @returns all the workspaces marked as dependencies
     */
    getRecursiveWorkspaceDependencies({ dependencies }?: {
        dependencies?: Array<HardDependencies>;
    }): Set<Workspace>;
    /**
     * Find workspaces which include the current workspace as a dependency/devDependency recursively.
     *
     * @param rootWorkspace root workspace
     * @param project project
     *
     * @returns all the workspaces marked as dependents
     */
    getRecursiveWorkspaceDependents({ dependencies }?: {
        dependencies?: Array<HardDependencies>;
    }): Set<Workspace>;
    /**
     * Retrieves all the child workspaces of a given root workspace recursively
     *
     * @param rootWorkspace root workspace
     * @param project project
     *
     * @returns all the child workspaces
     */
    getRecursiveWorkspaceChildren(): Workspace[];
    persistManifest(): Promise<void>;
}
