import { AliasFS } from '@yarnpkg/fslib';
import { Fetcher, FetchOptions } from './Fetcher';
import { Locator } from './types';
export declare class VirtualFetcher implements Fetcher {
    supports(locator: Locator): boolean;
    getLocalPath(locator: Locator, opts: FetchOptions): import("@yarnpkg/fslib").PortablePath | null;
    fetch(locator: Locator, opts: FetchOptions): Promise<{
        packageFs: AliasFS<import("@yarnpkg/fslib").PortablePath>;
        releaseFs?: () => void;
        prefixPath: import("@yarnpkg/fslib").PortablePath;
        localPath?: import("@yarnpkg/fslib").PortablePath | null;
        checksum?: string | null;
        discardFromLookup?: boolean;
    }>;
    getLocatorFilename(locator: Locator): import("@yarnpkg/fslib").Filename;
    private ensureVirtualLink;
}
