import { PortablePath } from '@yarnpkg/fslib';
import { Configuration } from './Configuration';
export declare enum MetricName {
    VERSION = "version",
    COMMAND_NAME = "commandName",
    PLUGIN_NAME = "pluginName",
    INSTALL_COUNT = "installCount",
    PROJECT_COUNT = "projectCount",
    WORKSPACE_COUNT = "workspaceCount",
    DEPENDENCY_COUNT = "dependencyCount",
    EXTENSION = "packageExtension"
}
export type RegistryBlock = {
    values?: {
        [key in MetricName]?: Array<string>;
    };
    hits?: {
        [key in MetricName]?: {
            [extra: string]: number;
        };
    };
    enumerators?: {
        [key in MetricName]?: Array<string>;
    };
};
export type RegistryFile = {
    lastTips?: number;
    lastUpdate?: number;
    blocks?: Record<string, RegistryBlock>;
    displayedTips?: Array<number>;
};
export type Tip = {
    selector?: string;
    message: string;
    url?: string;
};
export type DeriveParameters = {
    state: RegistryFile;
    timeNow: number;
    timeZone: number;
    randomInitialInterval: number;
    updateInterval: number;
};
export declare function derive(params: DeriveParameters): {
    nextState: RegistryFile | null;
    triggerUpdate: boolean;
    triggerTips: boolean;
    nextTips: number;
};
export declare class TelemetryManager {
    private configuration;
    private values;
    private hits;
    private enumerators;
    private nextTips;
    private displayedTips;
    private shouldCommitTips;
    isNew: boolean;
    shouldShowTips: boolean;
    constructor(configuration: Configuration, accountId: string);
    /**
     * Prevents the tip from being displayed today, but doesn't actually display it.
     * We use it when replacing the tip by something else (like an upgrade prompt).
     */
    commitTips(): void;
    selectTip(allTips: Array<Tip | null>): Tip | null;
    reportVersion(value: string): void;
    reportCommandName(value: string): void;
    reportPluginName(value: string): void;
    reportProject(cwd: PortablePath): void;
    reportInstall(nodeLinker: string): void;
    reportPackageExtension(value: string): void;
    reportWorkspaceCount(count: number): void;
    reportDependencyCount(count: number): void;
    private reportValue;
    private reportEnumerator;
    private reportHit;
    private getRegistryPath;
    private sendReport;
    private applyChanges;
    private startBuffer;
}
