import { Writable } from 'stream';
import { Configuration } from './Configuration';
import { MessageName } from './MessageName';
import { Report, SectionOptions, TimerOptions, ProgressIterable } from './Report';
export type StreamReportOptions = {
    configuration: Configuration;
    forceSectionAlignment?: boolean;
    includeFooter?: boolean;
    includeInfos?: boolean;
    includeLogs?: boolean;
    includeNames?: boolean;
    includeVersion?: boolean;
    includeWarnings?: boolean;
    includePrefix?: boolean;
    json?: boolean;
    stdout: Writable;
};
export declare const SINGLE_LINE_CHAR = "\u00B7";
export declare const SUPPORTS_GROUPS: boolean;
export declare function formatName(name: MessageName | null, { configuration, json }: {
    configuration: Configuration;
    json: boolean;
}): string;
export declare function formatNameWithHyperlink(name: MessageName | null, { configuration, json }: {
    configuration: Configuration;
    json: boolean;
}): string;
/**
 * @internal
 */
export declare function reportOptionDeprecations({ configuration, stdout, forceError }: {
    configuration: Configuration;
    stdout: Writable;
    forceError?: boolean;
}, checks: Array<{
    option: unknown;
    message: string;
    error?: boolean;
    callback?: () => void;
}>): Promise<0 | 1 | null>;
export declare class StreamReport extends Report {
    static start(opts: StreamReportOptions, cb: (report: StreamReport) => Promise<void>): Promise<StreamReport>;
    private configuration;
    private forceSectionAlignment;
    private includeNames;
    private includePrefix;
    private includeFooter;
    private includeInfos;
    private includeWarnings;
    private json;
    private stdout;
    private uncommitted;
    private warningCount;
    private errorCount;
    private timerFooter;
    private startTime;
    private indent;
    private level;
    private progress;
    private progressTime;
    private progressFrame;
    private progressTimeout;
    private progressStyle;
    private progressMaxScaledSize;
    constructor({ configuration, stdout, json, forceSectionAlignment, includeNames, includePrefix, includeFooter, includeLogs, includeInfos, includeWarnings, }: StreamReportOptions);
    hasErrors(): boolean;
    exitCode(): 0 | 1;
    getRecommendedLength(): number;
    startSectionSync<T>({ reportHeader, reportFooter, skipIfEmpty }: SectionOptions, cb: () => T): T;
    startSectionPromise<T>({ reportHeader, reportFooter, skipIfEmpty }: SectionOptions, cb: () => Promise<T>): Promise<T>;
    private startTimerImpl;
    startTimerSync<T>(what: string, opts: TimerOptions, cb: () => T): T;
    startTimerSync<T>(what: string, cb: () => T): T;
    startTimerPromise<T>(what: string, opts: TimerOptions, cb: () => Promise<T>): Promise<T>;
    startTimerPromise<T>(what: string, cb: () => Promise<T>): Promise<T>;
    reportSeparator(): void;
    reportInfo(name: MessageName | null, text: string): void;
    reportWarning(name: MessageName, text: string): void;
    reportError(name: MessageName, text: string): void;
    reportErrorImpl(name: MessageName, text: string): void;
    reportFold(title: string, text: string): void;
    reportProgress(progressIt: ProgressIterable): {
        stop: () => void;
        then<TResult1 = void, TResult2 = never>(onfulfilled?: ((value: void) => TResult1 | PromiseLike<TResult1>) | null | undefined, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | null | undefined): Promise<TResult1 | TResult2>;
        catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | null | undefined): Promise<void | TResult>;
        finally(onfinally?: (() => void) | null | undefined): Promise<void>;
        [Symbol.toStringTag]: string;
    };
    reportJson(data: any): void;
    finalize(): Promise<void>;
    private writeLine;
    private writeLines;
    private commit;
    private clearProgress;
    private writeProgress;
    private refreshProgress;
    private truncate;
    private formatName;
    private formatPrefix;
    private formatNameWithHyperlink;
    private formatIndent;
}
