export type RefCountedCacheEntry<TValue> = {
    value: TValue;
    release: () => void;
};
/**
 * A cache map with reference counting. This map is designed to handle
 * a resource that has native/wasm handles which need to be release explicitly.
 * It also requires the value to have a unique map to cache instanches
 */
export declare class RefCountedCache<TKey, TValue> {
    private releaseFunction;
    private map;
    /**
     * Creates a new RefCountedMap.
     * @param releaseFunction The function to release the native resources.
     */
    constructor(releaseFunction: (value: TValue) => void);
    /**
     *
     * @param key A unique key to indentify the instance in this Map
     * @param createInstance The function to create a new instance of TValue if none already esists
     * @returns The value form the cache (or newly created when not present) as well as the release function
     * to call when the object is to be released.
     */
    addOrCreate(key: TKey, createInstance: () => TValue): RefCountedCacheEntry<TValue>;
    /**
     * Releases the object by decreasing the refcount. When the last reference is released (i.e. the refcount goes to 0)
     * This function will call to the releaseFunction passed to the cache map to release the native resources.
     */
    private release;
}
