# Installation
> `npm install --save @types/auth-header`

# Summary
This package contains type definitions for auth-header (https://github.com/izaakschroeder/auth-header).

# Details
Files were exported from https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/auth-header.
## [index.d.ts](https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/auth-header/index.d.ts)
````ts
type Params =
    | Array<[string, string | readonly string[]]>
    | { [key: string]: string | readonly string[] };
export { Params };

export interface TokenOptions {
    scheme: string;
    token?: string | undefined;
    params?: Params | undefined;
}

export interface Token {
    scheme: string;
    params: { [key: string]: string | string[] };
    token: null | string | string[];
}

export function format(token: TokenOptions): string;
export function format(scheme: string, token?: string, params?: Params): string;

export function parse(header: string): Token;

````

### Additional Details
 * Last updated: Mon, 20 Nov 2023 23:36:23 GMT
 * Dependencies: none

# Credits
These definitions were written by [ForbesLindesay](https://github.com/ForbesLindesay).
