import type { IBuffered, ICopy } from "@thi.ng/api";
import type { ISeedable } from "./api";
import { ARandom } from "./arandom";
/**
 * @remarks
 * Reference: https://en.wikipedia.org/wiki/Xorshift#xorwow
 */
export declare class XorWow extends ARandom implements IBuffered<Uint32Array>, ICopy<XorWow>, ISeedable<ArrayLike<number>> {
    buffer: Uint32Array;
    constructor(seed?: ArrayLike<number>);
    copy(): XorWow;
    seed(seed: ArrayLike<number>): this;
    bytes(): Uint8Array;
    int(): number;
}
//# sourceMappingURL=xorwow.d.ts.map