import type { IBuffered, ICopy } from "@thi.ng/api";
import { ARandom } from "./arandom";
/**
 * Currently browser only, a `window.crypto` backed {@link IRandom}
 * implementation. Random values are buffered to minimize overhead. Buffer size
 * is configurable via ctor.
 *
 * @remarks
 * Internally uses {@link randomBytes} to source values, which falls back to
 * using {@link SYSTEM} iff `window.crypto` is not available.
 *
 */
export declare class Crypto extends ARandom implements IBuffered<Uint8Array>, ICopy<Crypto> {
    buffer: Uint8Array;
    protected u32: Uint32Array;
    protected i: number;
    /**
     * @param size - buffer size in bytes (will be rounded to next multiple of 4)
     */
    constructor(size?: number);
    copy(): Crypto;
    bytes(): Uint8Array;
    int(): number;
}
/**
 * Default instance for {@link Crypto} PRNG.
 */
export declare const CRYPTO: Crypto;
//# sourceMappingURL=crypto.d.ts.map