'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

const P32 = 0x100000000;
const HEX = "0123456789abcdef";
const U4 = (x) => HEX[x & 0xf];
const U8 = (x) => HEX[(x >>> 4) & 0xf] + HEX[x & 0xf];
const U8A = (x, i) => U8(x[i]);
const U16 = (x) => U8(x >>> 8) + U8(x & 0xff);
const U16BE = (x, i) => U8(x[i]) + U8(x[i + 1]);
const U16LE = (x, i) => U8(x[i + 1]) + U8(x[i]);
const U24 = (x) => U8(x >>> 16) + U16(x);
const U24BE = (x, i) => U8(x[i]) + U16BE(x, i + 1);
const U24LE = (x, i) => U8(x[i + 2]) + U16LE(x, i);
const U32 = (x) => U16(x >>> 16) + U16(x);
const U32BE = (x, i) => U16BE(x, i) + U16BE(x, i + 2);
const U32LE = (x, i) => U16LE(x, i + 2) + U16LE(x, i);
const U48 = (x) => U48HL(x / P32, x % P32);
const U48HL = (hi, lo) => U16(hi) + U32(lo);
const U48BE = (x, i) => U16BE(x, i) + U32BE(x, i + 2);
const U48LE = (x, i) => U16LE(x, i + 4) + U32LE(x, i);
const U64 = (x) => U64HL(x / P32, x % P32);
const U64HL = (hi, lo) => U32(hi) + U32(lo);
const U64BE = (x, i) => U32BE(x, i) + U32BE(x, i + 4);
const U64LE = (x, i) => U32LE(x, i + 4) + U32LE(x, i);
const uuid = (id, i = 0) =>
`${U32BE(id, i)}-${U16BE(id, i + 4)}-${U16BE(id, i + 6)}-${U16BE(id, i + 8)}-${U48BE(id, i + 10)}`;

exports.HEX = HEX;
exports.U16 = U16;
exports.U16BE = U16BE;
exports.U16LE = U16LE;
exports.U24 = U24;
exports.U24BE = U24BE;
exports.U24LE = U24LE;
exports.U32 = U32;
exports.U32BE = U32BE;
exports.U32LE = U32LE;
exports.U4 = U4;
exports.U48 = U48;
exports.U48BE = U48BE;
exports.U48HL = U48HL;
exports.U48LE = U48LE;
exports.U64 = U64;
exports.U64BE = U64BE;
exports.U64HL = U64HL;
exports.U64LE = U64LE;
exports.U8 = U8;
exports.U8A = U8A;
exports.uuid = uuid;
