import { compare } from "./compare";
const getKey = (k) => typeof k === "function" ? k : (x) => x[k];
export function compareByKey(a, cmp = compare) {
    const k = getKey(a);
    return (x, y) => cmp(k(x), k(y));
}
export function compareByKeys2(a, b, cmpA = compare, cmpB = compare) {
    const ka = getKey(a);
    const kb = getKey(b);
    return (x, y) => {
        let res = cmpA(ka(x), ka(y));
        return res === 0 ? cmpB(kb(x), kb(y)) : res;
    };
}
export function compareByKeys3(a, b, c, cmpA = compare, cmpB = compare, cmpC = compare) {
    const ka = getKey(a);
    const kb = getKey(b);
    const kc = getKey(c);
    return (x, y) => {
        let res = cmpA(ka(x), ka(y));
        return res === 0
            ? (res = cmpB(kb(x), kb(y))) === 0
                ? cmpC(kc(x), kc(y))
                : res
            : res;
    };
}
export function compareByKeys4(a, b, c, d, cmpA = compare, cmpB = compare, cmpC = compare, cmpD = compare) {
    const ka = getKey(a);
    const kb = getKey(b);
    const kc = getKey(c);
    const kd = getKey(d);
    return (x, y) => {
        let res = cmpA(ka(x), ka(y));
        return res === 0
            ? (res = cmpB(kb(x), kb(y))) === 0
                ? (res = cmpC(kc(x), kc(y))) === 0
                    ? cmpD(kd(x), kd(y))
                    : res
                : res
            : res;
    };
}
