import type { Predicate2 } from "@thi.ng/api";
/**
 * Performs a fuzzy search of `query` in `domain` and returns `true` if
 * successful.
 *
 * @remarks
 * The optional `equiv` predicate can be used to customize item equality
 * checking. Uses {@link @thi.ng/equiv#equiv} by default.
 *
 * Adapted and generalized from:
 * {@link https://github.com/bevacqua/fufuzzyzzysearch} (MIT)
 *
 * {@link @thi.ng/transducers#(filterFuzzy:1)}
 *
 * @param domain - array
 * @param query - search value
 * @param equiv - equivalence predicate
 */
export declare const fuzzyMatch: <T>(domain: ArrayLike<T>, query: ArrayLike<T>, equiv?: Predicate2<any>) => boolean;
//# sourceMappingURL=fuzzy-match.d.ts.map