/**
 * Returns true if the last items of `buf` are the same items as in
 * `needle`.
 *
 * @remarks
 * This means `buf` should have at least the same length as `needle` for
 * this to be true.
 *
 * By default, uses {@link @thi.ng/equiv#equiv} for equality checking.
 *
 * {@link startsWith}
 *
 * @param buf - array
 * @param needle - search values (array)
 * @param equiv - equivalence predicate
 */
export declare const endsWith: <T>(buf: ArrayLike<T>, needle: ArrayLike<T>, equiv?: (a: any, b: any) => boolean) => boolean;
//# sourceMappingURL=ends-with.d.ts.map