export interface IEquiv {
    /**
     * Returns `true` if this *value* is equivalent to `o`. Also see
     * {@link ICompare.compare} and {@link IHash.hash}.
     *
     * @param o - value to check for equivalence
     */
    equiv(o: any): boolean;
}
/**
 * @param T - value type
 */
export interface IEqualsDelta<T> {
    /**
     * Returns `true` if this value equals `o` with optional allowance
     * for given tolerance `eps`.
     *
     * @param o - 2nd value to test
     * @param eps - tolerance (usually defaults to `DEFAULT_EPS`)
     */
    eqDelta(o: T, eps?: number): boolean;
}
//# sourceMappingURL=equiv.d.ts.map