import { Version } from './version';
export type RawRequirement = Version | string | null;
export type ParsedRequirement = [string, Version];
export declare class Requirement {
    readonly _requirements: ParsedRequirement[];
    static PATTERN: RegExp;
    static DEFAULT_REQUIREMENT: ParsedRequirement;
    static create(...inputs: unknown[]): Requirement;
    static default(): Requirement;
    static parse(obj: unknown): ParsedRequirement;
    constructor(...requirements: RawRequirement[]);
    concat(newReqs: RawRequirement[]): void;
    isNone(): boolean;
    isPrerelease(): boolean;
    isSatisfiedBy(v: Version): boolean;
    isSpecific(): boolean;
    eql(other: Requirement): boolean;
    _tildeRequirements(): ParsedRequirement[];
}
export declare const parse: (obj: unknown) => ParsedRequirement;
