export type ReleaseType = 'major' | 'premajor' | 'minor' | 'preminor' | 'patch' | 'prepatch' | 'prerelease';
/**
 * v1 == v2 This is true if they're logically equivalent, even if they're not the exact same string. You already know how to compare strings.
 */
export declare function eq(v1: string, v2: string): boolean;
/**
 * v1 > v2
 */
export declare function gt(v1: string, v2: string): boolean;
/**
 * v1 >= v2
 */
export declare function gte(v1: string, v2: string): boolean;
/**
 * v1 > v2
 */
export declare function lt(v1: string, v2: string): boolean;
/**
 * v1 >= v2
 */
export declare function lte(v1: string, v2: string): boolean;
/**
 * Return the parsed version, or null if it's not valid.
 */
export declare function valid(version: string | null | undefined): string | null;
/**
 * Return true if the version satisfies the range.
 */
export declare function satisfies(version: string, range: string): boolean;
/**
 * Return the highest version in the list that satisfies the range, or null if none of them do.
 */
export declare function maxSatisfying(versions: string[], range: string): string | null;
/**
 * Return the lowest version in the list that satisfies the range, or null if none of them do.
 */
export declare function minSatisfying(versions: string[], range: string): string | null;
/**
 * Return the major version number.
 */
export declare function major(v: string | null | undefined): number;
/**
 * Return the minor version number.
 */
export declare function minor(v: string | null | undefined): number;
/**
 * Return the patch version number.
 */
export declare function patch(v: string | null | undefined): number;
/**
 * Returns an array of prerelease components, or null if none exist.
 */
export declare function prerelease(v: string | null | undefined): string[] | null;
