"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.tryDownloadDb = tryDownloadDb;
const fs_extra_1 = __importDefault(require("fs-extra"));
const got_1 = __importDefault(require("got"));
const promises_1 = require("node:stream/promises");
const osv_offline_db_1 = require("@renovatebot/osv-offline-db");
const path_1 = __importDefault(require("path"));
const luxon_1 = require("luxon");
const adm_zip_1 = __importDefault(require("adm-zip"));
const types_1 = require("./types");
async function tryDownloadDb() {
    await fs_extra_1.default.ensureDir(osv_offline_db_1.OsvOfflineDb.rootDirectory);
    if (process.env.OSV_OFFLINE_DISABLE_DOWNLOAD?.toLowerCase() === 'true') {
        return (0, types_1.success)();
    }
    // if local database exists and is less than a day old, don't do any network requests
    let stats;
    try {
        stats = await fs_extra_1.default.stat(path_1.default.join(osv_offline_db_1.OsvOfflineDb.rootDirectory, `osv-offline.zip`));
    }
    catch {
        // ignored
    }
    if (stats !== undefined &&
        luxon_1.DateTime.utc().diff(luxon_1.DateTime.fromJSDate(stats.mtime)).as('days') < 1) {
        return (0, types_1.success)();
    }
    // only download databases if local databases are missing or remote is newer
    try {
        const stream = got_1.default.stream('https://github.com/renovatebot/osv-offline/releases/latest/download/osv-offline.zip');
        const zipPath = path_1.default.join(osv_offline_db_1.OsvOfflineDb.rootDirectory, 'osv-offline.zip');
        const writeStream = fs_extra_1.default.createWriteStream(zipPath);
        await (0, promises_1.pipeline)(stream, writeStream);
        const zip = new adm_zip_1.default(zipPath);
        zip.extractAllTo(osv_offline_db_1.OsvOfflineDb.rootDirectory);
    }
    catch (err) {
        return (0, types_1.failure)(err);
    }
    return (0, types_1.success)();
}
