// Generated by IcedCoffeeScript 112.8.1
var ASP, Avg, BigInteger, MRF, PrimeFinder, SRF, Timer, _MR_inner, _MR_small_check, fermat2_test, fta, iced, make_esc, miller_rabin, naive_is_prime, native_rng, nbi, nbs, nbv, prime_search, prng, quickmod, random_prime, ref, ref1, small_primes;

iced = require('iced-runtime-3');

ref = require('bn'), nbv = ref.nbv, nbi = ref.nbi, BigInteger = ref.BigInteger;

prng = require('triplesec').prng;

native_rng = prng.native_rng;

small_primes = require('./primes').small_primes;

make_esc = require('iced-error').make_esc;

ASP = require('./util').ASP;

nbs = require('./bn').nbs;

ref1 = require('./rand'), MRF = ref1.MRF, SRF = ref1.SRF;

Timer = (function() {
  function Timer() {
    this.start = Date.now();
  }

  Timer.prototype.stop = function() {
    return Date.now() - this.start;
  };

  return Timer;

})();

Avg = (function() {
  function Avg() {
    this.tot = 0;
    this.n = 0;
  }

  Avg.prototype.start = function() {
    return this._t = Date.now();
  };

  Avg.prototype.stop = function() {
    var s;
    s = Date.now() - this._t;
    console.log("ran in " + s);
    this.tot += s;
    return this.n++;
  };

  Avg.prototype.avg = function() {
    return this.tot / this.n;
  };

  return Avg;

})();

quickmod = function(p, d) {
  return p.modInt(d);
};

fta = new Avg();

fermat2_test = function(n) {
  var Bl, bl, i, k, ref2, ret, t;
  t = nbv(1);
  bl = n.bitLength();
  bl--;
  Bl = n.byteLength();
  for (i = k = ref2 = bl; ref2 <= 0 ? k <= 0 : k >= 0; i = ref2 <= 0 ? ++k : --k) {
    t = t.square();
    if (t.byteLength() > Bl) {
      t = t.mod(n);
    }
    if (n.testBit(i)) {
      t = t.shiftLeft(1);
    }
  }
  if (t.compareTo(n) > 0) {
    t = t.mod(n);
  }
  ret = t.compareTo(nbv(2)) === 0;
  return ret;
};

_MR_inner = function(arg) {
  var a, j, k, p, p1, r, ref2, s, y;
  s = arg.s, r = arg.r, p = arg.p, p1 = arg.p1;
  a = MRF().random_zn(p);
  y = a.modPow(r, p);
  if (y.compareTo(BigInteger.ONE) !== 0) {
    for (j = k = ref2 = s - 1; ref2 <= 0 ? k <= 0 : k >= 0; j = ref2 <= 0 ? ++k : --k) {
      if (!(y.compareTo(p1) !== 0)) {
        continue;
      }
      if (j === 0) {
        return false;
      }
      y = y.square().mod(p);
      if (y.compareTo(BigInteger.ONE) === 0) {
        return false;
      }
    }
  }
  return true;
};

_MR_small_check = function(arg) {
  var p, ref2;
  p = arg.p;
  if (p.compareTo(BigInteger.ZERO) <= 0) {
    return false;
  } else if (p.compareTo(nbv(7)) <= 0) {
    return (ref2 = p.intValue()) === 2 || ref2 === 3 || ref2 === 5 || ref2 === 7;
  } else if (!p.testBit(0)) {
    return false;
  } else {
    return true;
  }
};

miller_rabin = function(arg, cb) {
  var __iced_it, __iced_passed_deferral, asp, esc, i, iter, p, p1, r, ret, s;
  p = arg.p, iter = arg.iter, asp = arg.asp;
  __iced_passed_deferral = iced.findDeferral(arguments);
  __iced_it = (function*() {
    var __iced_deferrals, __iced_deferrals1, k, ref2;
    asp || (asp = new ASP({}));
    iter || (iter = 10);
    esc = make_esc(cb, "miller_rabin");
    ret = _MR_small_check({
      p: p
    });
    if (ret) {
      p1 = p.subtract(BigInteger.ONE);
      s = p1.getLowestSetBit();
      r = p1.shiftRight(s);
      ret = true;
      for (i = k = 0, ref2 = iter; 0 <= ref2 ? k < ref2 : k > ref2; i = 0 <= ref2 ? ++k : --k) {
        __iced_deferrals = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "miller_rabin",
          filename: "/home/runner/work/kbpgp/kbpgp/src/primegen.iced"
        });
        asp.progress({
          what: "mr",
          i: i,
          total: iter,
          p: p
        }, esc(__iced_deferrals.defer({
          lineno: 122
        })));
        if (__iced_deferrals.await_exit()) {
          yield;
        }
        if (!_MR_inner({
          s: s,
          r: r,
          p: p,
          p1: p1
        })) {
          ret = false;
          break;
        }
      }
      __iced_deferrals1 = new iced.Deferrals(__iced_it, {
        parent: __iced_passed_deferral,
        funcname: "miller_rabin",
        filename: "/home/runner/work/kbpgp/kbpgp/src/primegen.iced"
      });
      asp.progress({
        what: "mr",
        i: iter,
        total: iter,
        p: p
      }, esc(__iced_deferrals1.defer({
        lineno: 127
      })));
      if (__iced_deferrals1.await_exit()) {
        yield;
      }
    }
    return cb(null, ret);
  })();
  __iced_it.next();
  return null;
};

PrimeFinder = (function() {
  function PrimeFinder(p2, sieve1) {
    this.p = p2;
    this.sieve = sieve1;
    this.inc = 0;
    this.maxinc = -1;
    this.sievepos = quickmod(this.p, this.sieve.length);
    this.calcmods();
  }

  PrimeFinder.prototype.getp = function() {
    return this.p;
  };

  PrimeFinder.prototype.setmax = function(i) {
    if (this.maxinc !== -1) {
      throw new Error("can only setmax() once");
    }
    return this.maxinc = i;
  };

  PrimeFinder.prototype.calcmods = function() {
    var sp;
    this.p = this.p.add(nbv(this.inc));
    if (this.maxinc !== -1) {
      this.maxinc -= this.inc;
    }
    this.inc = 0;
    return this.mods = (function() {
      var k, len, results;
      results = [];
      for (k = 0, len = small_primes.length; k < len; k++) {
        sp = small_primes[k];
        results.push(quickmod(this.p, sp));
      }
      return results;
    }).call(this);
  };

  PrimeFinder.prototype.decrement_mods_find_divisor = function() {
    var i, k, len, sp;
    for (i = k = 0, len = small_primes.length; k < len; i = ++k) {
      sp = small_primes[i];
      while (this.mods[i] + this.inc >= sp) {
        this.mods[i] -= sp;
        if ((this.mods[i] + this.inc) === 0) {
          return true;
        }
      }
    }
    return false;
  };

  PrimeFinder.prototype.next_weak = function() {
    var step;
    while (true) {
      step = this.sieve[this.sievepos];
      this.sievepos = (this.sievepos + step) % this.sieve.length;
      this.inc += step;
      if (this.inc > this.maxinc && this.maxinc > 0) {
        this.tmp = nbv(0);
        return this.tmp;
      }
      if (this.inc < 0) {
        this.calcmods();
      }
      if (!this.decrement_mods_find_divisor()) {
        this.tmp = this.p.add(nbv(this.inc));
        return this.tmp;
      }
    }
  };

  PrimeFinder.prototype.next_fermat = function() {
    while (true) {
      this.next_weak();
      if (!this.tmp || fermat2_test(this.tmp)) {
        return this.tmp;
      }
    }
  };

  PrimeFinder.prototype.next_strong = function(iter) {
    if (iter == null) {
      iter = 32;
    }
    while (true) {
      this.next_weak();
      if (!this.tmp || (fermat2_test(this.tmp) && probab_prime(this.tmp, iter))) {
        return this.tmp;
      }
    }
  };

  return PrimeFinder;

})();

prime_search = function(arg, cb) {
  var __iced_it, __iced_passed_deferral, asp, esc, i, is_prime, iters, p, pf, pp, pvec, range, ret, sieve, start, tmp;
  start = arg.start, range = arg.range, sieve = arg.sieve, asp = arg.asp, iters = arg.iters;
  __iced_passed_deferral = iced.findDeferral(arguments);
  __iced_it = (function*() {
    var __iced_deferrals, __iced_deferrals1, __iced_deferrals2;
    iters || (iters = 20);
    pf = new PrimeFinder(start, sieve);
    pf.setmax(range);
    pvec = ((function() {
      var results;
      results = [];
      while ((pp = pf.next_weak()).compareTo(BigInteger.ZERO) > 0) {
        results.push(pp);
      }
      return results;
    })());
    esc = make_esc(cb, "prime_search");
    ret = null;
    while (pvec.length && (ret == null)) {
      i = MRF().random_word() % pvec.length;
      p = pvec[i];
      __iced_deferrals = new iced.Deferrals(__iced_it, {
        parent: __iced_passed_deferral,
        funcname: "prime_search",
        filename: "/home/runner/work/kbpgp/kbpgp/src/primegen.iced"
      });
      asp.progress({
        what: "fermat",
        p: p
      }, esc(__iced_deferrals.defer({
        lineno: 226
      })));
      if (__iced_deferrals.await_exit()) {
        yield;
      }
      if (!fermat2_test(p)) {

      } else {
        __iced_deferrals1 = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "prime_search",
          filename: "/home/runner/work/kbpgp/kbpgp/src/primegen.iced"
        });
        miller_rabin({
          p: p,
          iters: iters,
          asp: asp
        }, esc(__iced_deferrals1.defer({
          assign_fn: (function() {
            return function() {
              return is_prime = arguments[0];
            };
          })(),
          lineno: 229
        })));
        if (__iced_deferrals1.await_exit()) {
          yield;
        }
        __iced_deferrals2 = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "prime_search",
          filename: "/home/runner/work/kbpgp/kbpgp/src/primegen.iced"
        });
        asp.progress({
          what: "passed_mr",
          p: p
        }, esc(__iced_deferrals2.defer({
          lineno: 230
        })));
        if (__iced_deferrals2.await_exit()) {
          yield;
        }
        if (is_prime) {
          ret = p;
        } else {
          asp.progress({
            what: "failed_mr",
            p: p
          });
        }
      }
      tmp = pvec.pop();
      if (i < pvec.length) {
        pvec[i] = tmp;
      }
    }
    if (ret == null) {
      ret = nbv(0);
    }
    return cb(null, ret);
  })();
  __iced_it.next();
  return null;
};

random_prime = function(arg, cb) {
  var __iced_it, __iced_passed_deferral, asp, e, esc, go, iters, nbits, p, range, sieve;
  nbits = arg.nbits, iters = arg.iters, asp = arg.asp, e = arg.e;
  __iced_passed_deferral = iced.findDeferral(arguments);
  __iced_it = (function*() {
    var __iced_deferrals, __iced_deferrals1, __iced_deferrals2, __iced_deferrals3;
    sieve = [1, 2];
    go = true;
    esc = make_esc(cb, "random_prime");
    range = nbits;
    p = null;
    while (go) {
      __iced_deferrals = new iced.Deferrals(__iced_it, {
        parent: __iced_passed_deferral,
        funcname: "random_prime",
        filename: "/home/runner/work/kbpgp/kbpgp/src/primegen.iced"
      });
      SRF().random_nbit(nbits, __iced_deferrals.defer({
        assign_fn: (function() {
          return function() {
            return p = arguments[0];
          };
        })(),
        lineno: 262
      }));
      if (__iced_deferrals.await_exit()) {
        yield;
      }
      p = p.setBit(0).setBit(nbits - 1).setBit(nbits - 2);
      if ((e == null) || p.subtract(BigInteger.ONE).gcd(e).compareTo(BigInteger.ONE) === 0) {
        __iced_deferrals1 = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "random_prime",
          filename: "/home/runner/work/kbpgp/kbpgp/src/primegen.iced"
        });
        asp.progress({
          what: "guess",
          p: p
        }, esc(__iced_deferrals1.defer({
          lineno: 265
        })));
        if (__iced_deferrals1.await_exit()) {
          yield;
        }
        __iced_deferrals2 = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "random_prime",
          filename: "/home/runner/work/kbpgp/kbpgp/src/primegen.iced"
        });
        prime_search({
          start: p,
          range: range,
          sieve: sieve,
          asp: asp,
          iters: iters
        }, esc(__iced_deferrals2.defer({
          assign_fn: (function() {
            return function() {
              return p = arguments[0];
            };
          })(),
          lineno: 266
        })));
        if (__iced_deferrals2.await_exit()) {
          yield;
        }
        go = (p == null) || (p.compareTo(BigInteger.ZERO) === 0);
      }
    }
    __iced_deferrals3 = new iced.Deferrals(__iced_it, {
      parent: __iced_passed_deferral,
      funcname: "random_prime",
      filename: "/home/runner/work/kbpgp/kbpgp/src/primegen.iced"
    });
    asp.progress({
      what: "found",
      p: p
    }, esc(__iced_deferrals3.defer({
      lineno: 269
    })));
    if (__iced_deferrals3.await_exit()) {
      yield;
    }
    return cb(null, p);
  })();
  __iced_it.next();
  return null;
};

exports.naive_is_prime = naive_is_prime = function(n) {
  var biggest, k, len, p;
  biggest = Math.floor(Math.sqrt(n));
  for (k = 0, len = small_primes.length; k < len; k++) {
    p = small_primes[k];
    if (p > biggest) {
      return true;
    }
    if ((n % p) === 0) {
      return false;
    }
  }
  return false;
};

exports.fermat2_test = fermat2_test;

exports.nbs = nbs;

exports.small_primes = small_primes;

exports.miller_rabin = miller_rabin;

exports.random_prime = random_prime;

//# sourceMappingURL=primegen.js.map
