// Generated by IcedCoffeeScript 112.8.1
var C, SHA512, SRF, bufeq_secure, buffer_to_ui8a, eme_random, emsa_pkcs1_decode, emsa_pkcs1_encode, hash_headers, iced, nbs, ref;

iced = require('iced-runtime-3');

SHA512 = require('./hash').SHA512;

C = require('./const').openpgp;

nbs = require('./bn').nbs;

ref = require('./util'), buffer_to_ui8a = ref.buffer_to_ui8a, bufeq_secure = ref.bufeq_secure;

SRF = require('./rand').SRF;

hash_headers = {
  MD5: [0x30, 0x20, 0x30, 0x0C, 0x06, 0x08, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x02, 0x05, 0x05, 0x00, 0x04, 0x10],
  SHA1: [0x30, 0x21, 0x30, 0x09, 0x06, 0x05, 0x2b, 0x0e, 0x03, 0x02, 0x1a, 0x05, 0x00, 0x04, 0x14],
  SHA224: [0x30, 0x2d, 0x30, 0x0d, 0x06, 0x09, 0x60, 0x86, 0x48, 0x01, 0x65, 0x03, 0x04, 0x02, 0x04, 0x05, 0x00, 0x04, 0x1C],
  SHA256: [0x30, 0x31, 0x30, 0x0d, 0x06, 0x09, 0x60, 0x86, 0x48, 0x01, 0x65, 0x03, 0x04, 0x02, 0x01, 0x05, 0x00, 0x04, 0x20],
  SHA384: [0x30, 0x41, 0x30, 0x0d, 0x06, 0x09, 0x60, 0x86, 0x48, 0x01, 0x65, 0x03, 0x04, 0x02, 0x02, 0x05, 0x00, 0x04, 0x30],
  SHA512: [0x30, 0x51, 0x30, 0x0d, 0x06, 0x09, 0x60, 0x86, 0x48, 0x01, 0x65, 0x03, 0x04, 0x02, 0x03, 0x05, 0x00, 0x04, 0x40]
};

exports.emsa_pkcs1_encode = emsa_pkcs1_encode = function(hashed_data, len, opts) {
  var buf, hasher, headers, i, n;
  if (opts == null) {
    opts = {};
  }
  hasher = opts.hasher || SHA512;
  headers = hash_headers[hasher.algname];
  n = len - headers.length - 3 - hasher.output_length;
  buf = Buffer.concat([
    Buffer.from([0x00, 0x01]), Buffer.from((function() {
      var j, ref1, results;
      results = [];
      for (i = j = 0, ref1 = n; 0 <= ref1 ? j < ref1 : j > ref1; i = 0 <= ref1 ? ++j : --j) {
        results.push(0xff);
      }
      return results;
    })()), Buffer.from([0x00]), Buffer.from(headers), hashed_data
  ]);
  return nbs(buffer_to_ui8a(buf), 256);
};

exports.emsa_pkcs1_decode = emsa_pkcs1_decode = function(v, hasher) {
  var err, h, header, i, ret;
  err = ret = null;
  i = 0;
  if (v.length < 2) {
    err = new Error("signature was way too short: < 2 bytes");
  } else {
    if (v.readUInt16BE(0) !== 0x0001) {
      err = new Error("Sig verify error: Didn't get two-byte header 0x00 0x01");
    } else {
      i = 2;
      while (i < v.length && (v.readUInt8(i) === 0xff)) {
        i++;
      }
      if (i >= v.length || v.readUInt8(i) !== 0) {
        err = new Error("Sig verify error: Missed the 0x0 separator");
      } else {
        i++;
        header = hash_headers[hasher.algname];
        if (!bufeq_secure(Buffer.from(header), v.slice(i, header.length + i))) {
          err = new Error("Sig verify error: missing ASN header for " + hasher.algname);
        } else {
          i += header.length;
          h = v.slice(i);
          if (h.length !== hasher.output_length) {
            err = new Error("Sig verify error: trailing garbage in signature");
          } else {
            ret = h;
          }
        }
      }
    }
  }
  return [err, ret];
};

eme_random = function(n, cb) {
  var __iced_it, __iced_passed_deferral, b, bytes, c, diff, i;
  __iced_passed_deferral = iced.findDeferral(arguments);
  __iced_it = (function*() {
    var __iced_deferrals, j, ref1;
    bytes = [];
    while (bytes.length < n) {
      diff = n - bytes.length;
      __iced_deferrals = new iced.Deferrals(__iced_it, {
        parent: __iced_passed_deferral,
        funcname: "eme_random",
        filename: "/home/runner/work/kbpgp/kbpgp/src/pad.iced"
      });
      SRF().random_bytes(diff, __iced_deferrals.defer({
        assign_fn: (function() {
          return function() {
            return b = arguments[0];
          };
        })(),
        lineno: 77
      }));
      if (__iced_deferrals.await_exit()) {
        yield;
      }
      for (i = j = 0, ref1 = diff; 0 <= ref1 ? j < ref1 : j > ref1; i = 0 <= ref1 ? ++j : --j) {
        c = b.readUInt8(i);
        if (c !== 0) {
          bytes.push(c);
        }
      }
    }
    return cb(Buffer.from(bytes));
  })();
  __iced_it.next();
  return null;
};

exports.eme_pkcs1_encode = function(v, len, cb) {
  var PS, __iced_it, __iced_passed_deferral, buf, err, n_randos, ret;
  __iced_passed_deferral = iced.findDeferral(arguments);
  __iced_it = (function*() {
    var __iced_deferrals;
    ret = err = null;
    if (v.length > len - 11) {
      err = new Error("cannot encrypt message -- it's too long!");
    } else {
      n_randos = len - 3 - v.length;
      __iced_deferrals = new iced.Deferrals(__iced_it, {
        parent: __iced_passed_deferral,
        funcname: "exports.eme_pkcs1_encode",
        filename: "/home/runner/work/kbpgp/kbpgp/src/pad.iced"
      });
      eme_random(n_randos, __iced_deferrals.defer({
        assign_fn: (function() {
          return function() {
            return PS = arguments[0];
          };
        })(),
        lineno: 93
      }));
      if (__iced_deferrals.await_exit()) {
        yield;
      }
      buf = Buffer.concat([Buffer.from([0x00, 0x02]), PS, Buffer.from([0x00]), v]);
      ret = nbs(buffer_to_ui8a(buf), 256);
    }
    return cb(err, ret);
  })();
  __iced_it.next();
  return null;
};

exports.eme_pkcs1_decode = function(v) {
  var err, i, ret;
  err = ret = null;
  if (v.length < 12) {
    err = new Error("Ciphertext too short, needs to be >= 12 bytes");
  } else if (v.readUInt16BE(0) !== 0x0002) {
    err = new Error("Failed to find expected header: 0x00 0x02");
  } else {
    i = 2;
    while (i < v.length && (v.readUInt8(i) !== 0x0)) {
      i++;
    }
    if (i >= v.length) {
      err = new Error("didn't get 0x00 seperator octet");
    } else {
      i++;
      ret = v.slice(i);
    }
  }
  return [err, ret];
};

exports.ecc_pkcs5_pad_data = function(d) {
  var err, pad_len, ret, v;
  err = ret = null;
  pad_len = 40 - d.length;
  if (pad_len < 0) {
    err = new Error("Pad underrun");
  } else {
    v = (function() {
      var j, ref1, results;
      results = [];
      for (j = 0, ref1 = pad_len; 0 <= ref1 ? j < ref1 : j > ref1; 0 <= ref1 ? j++ : j--) {
        results.push(pad_len);
      }
      return results;
    })();
    ret = Buffer.concat([d, Buffer.from(v)]);
  }
  return [err, ret];
};

exports.ecc_pkcs5_unpad_data = function(buf, data_len) {
  var c, err, i, j, pad_len, ref1, ref2;
  err = null;
  pad_len = buf.length - data_len;
  if (pad_len < 0) {
    err = new Error("Pad length was < 0; pad underrun");
  } else if ((buf.length % 8) !== 0) {
    err = new Error("Padded data must be a multiple of 8 bytes long");
  } else {
    for (i = j = ref1 = data_len, ref2 = buf.length; ref1 <= ref2 ? j < ref2 : j > ref2; i = ref1 <= ref2 ? ++j : --j) {
      if ((c = buf.readUInt8(i)) !== pad_len) {
        err = new Error("Got bad PKCS#5 pad character " + c + " at position " + i + "; wanted " + pad_len);
        break;
      }
    }
  }
  return err;
};

//# sourceMappingURL=pad.js.map
