// Generated by IcedCoffeeScript 112.8.1
var C, SignatureEngine, SignatureEngineInterface, burn, decode, decode_sig, get_sig_body, iced, make_esc, processor,
  extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty;

iced = require('iced-runtime-3');

make_esc = require('iced-error').make_esc;

burn = require('./burner').burn;

processor = require('./processor');

decode = require('./armor').decode;

C = require('../const');

SignatureEngineInterface = require('../kmi').SignatureEngineInterface;

exports.decode_sig = decode_sig = function(arg) {
  var armored, err, msg, mt, ref;
  armored = arg.armored;
  ref = decode(armored), err = ref[0], msg = ref[1];
  mt = C.openpgp.message_types;
  if ((err == null) && (msg.type !== mt.generic)) {
    err = new Error("wrong message type; expected a generic message; got " + msg.type);
  }
  return [err, msg];
};

exports.get_sig_body = get_sig_body = function(arg) {
  var armored, err, msg, ref, res;
  armored = arg.armored;
  res = null;
  ref = decode_sig({
    armored: armored
  }), err = ref[0], msg = ref[1];
  if (err == null) {
    res = msg.body;
  }
  return [err, res];
};

exports.SignatureEngine = SignatureEngine = (function(superClass) {
  extend(SignatureEngine, superClass);

  function SignatureEngine(arg) {
    this.km = arg.km;
  }

  SignatureEngine.prototype.get_km = function() {
    return this.km;
  };

  SignatureEngine.prototype.box = function(msg, cb, opts) {
    var __iced_it, __iced_passed_deferral;
    if (opts == null) {
      opts = {};
    }
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var err, out, signing_key;
      return function*() {
        var __iced_deferrals;
        out = {
          type: "pgp"
        };
        if (opts.prefix != null) {
          err = new Error("prefixes cannot be used with PGP");
        } else if ((signing_key = _this.km.find_signing_pgp_key()) != null) {
          __iced_deferrals = new iced.Deferrals(__iced_it, {
            parent: __iced_passed_deferral,
            funcname: "SignatureEngine::box",
            filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/sigeng.iced"
          });
          burn({
            msg: msg,
            signing_key: signing_key,
            opts: opts
          }, __iced_deferrals.defer({
            assign_fn: (function(__slot_1, __slot_2) {
              return function() {
                err = arguments[0];
                __slot_1.pgp = arguments[1];
                return __slot_2.raw = arguments[2];
              };
            })(out, out),
            lineno: 38
          }));
          if (__iced_deferrals.await_exit()) {
            yield;
          }
          if (err == null) {
            out.armored = out.pgp;
          }
        } else {
          err = new Error("No signing key found");
        }
        return cb(err, out);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  SignatureEngine.prototype.get_unverified_payload_from_raw_sig_body = function(arg, cb) {
    var __iced_it, __iced_passed_deferral, body, err, esc, l, literals, m, n, payload;
    body = arg.body;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function*() {
      var __iced_deferrals;
      esc = make_esc(cb, "get_payload_from_raw_sig_body");
      payload = null;
      m = new processor.Message({});
      __iced_deferrals = new iced.Deferrals(__iced_it, {
        parent: __iced_passed_deferral,
        funcname: "SignatureEngine::get_unverified_payload_from_raw_sig_body",
        filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/sigeng.iced"
      });
      m.parse_and_inflate(body, esc(__iced_deferrals.defer({
        assign_fn: (function() {
          return function() {
            return literals = arguments[0];
          };
        })(),
        lineno: 49
      })));
      if (__iced_deferrals.await_exit()) {
        yield;
      }
      if ((n = literals.length) !== 1 || ((l = literals[0]) == null)) {
        err = new Error("Got " + n + " literals; only wanted 1");
      } else {
        payload = l.data;
      }
      return cb(err, payload);
    })();
    __iced_it.next();
    return null;
  };

  SignatureEngine.prototype.get_body = function(args, cb) {
    var err, ref, res;
    ref = get_sig_body(args), err = ref[0], res = ref[1];
    return cb(err, res);
  };

  SignatureEngine.prototype.decode = function(armored, cb) {
    var err, msg, ref;
    ref = decode_sig({
      armored: armored
    }), err = ref[0], msg = ref[1];
    return cb(err, msg);
  };

  SignatureEngine.prototype.unbox = function(msg, cb, opts) {
    var __iced_it, __iced_passed_deferral;
    if (opts == null) {
      opts = {};
    }
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var eng, esc, literals, payload;
      return function*() {
        var __iced_deferrals, __iced_deferrals1, __iced_deferrals2;
        esc = make_esc(cb, "SignatureEngine::unbox");
        if (typeof msg === 'string') {
          __iced_deferrals = new iced.Deferrals(__iced_it, {
            parent: __iced_passed_deferral,
            funcname: "SignatureEngine::unbox",
            filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/sigeng.iced"
          });
          _this.decode(msg, esc(__iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                return msg = arguments[0];
              };
            })(),
            lineno: 73
          })));
          if (__iced_deferrals.await_exit()) {
            yield;
          }
        }
        opts.keyfetch = _this.km;
        opts.strict = true;
        eng = new processor.Message(opts);
        __iced_deferrals1 = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "SignatureEngine::unbox",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/sigeng.iced"
        });
        eng.parse_and_process({
          body: msg.body
        }, esc(__iced_deferrals1.defer({
          assign_fn: (function() {
            return function() {
              return literals = arguments[0];
            };
          })(),
          lineno: 77
        })));
        if (__iced_deferrals1.await_exit()) {
          yield;
        }
        __iced_deferrals2 = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "SignatureEngine::unbox",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/sigeng.iced"
        });
        _this._check_result(literals, esc(__iced_deferrals2.defer({
          assign_fn: (function() {
            return function() {
              return payload = arguments[0];
            };
          })(),
          lineno: 78
        })));
        if (__iced_deferrals2.await_exit()) {
          yield;
        }
        return cb(null, payload, msg.body);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  SignatureEngine.prototype._check_result = function(literals, cb) {
    var b, err, l, n, payload, ref, sw;
    err = payload = null;
    if ((n = literals.length) !== 1 || ((l = literals[0]) == null)) {
      err = new Error("Expected only one pgp literal; got " + n);
    } else if ((sw = (ref = l.get_data_signer()) != null ? ref.sig : void 0) == null) {
      err = new Error("Expected a signature on the payload message");
    } else if ((this.km.find_pgp_key((b = sw.get_key_id()))) == null) {
      err = new Error("Failed sanity check; didn't have a key for '" + (b.toString('hex')) + "'");
    } else {
      payload = l.data;
    }
    return cb(err, payload);
  };

  return SignatureEngine;

})(SignatureEngineInterface);

//# sourceMappingURL=sigeng.js.map
