// Generated by IcedCoffeeScript 112.8.1
var AES, C, Packet, SHA1, SHA256, UserID, bufferify, encrypt, native_rng, parse, ref, ref1, triplesec, uint_to_buffer,
  extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty;

C = require('../../const').openpgp;

triplesec = require('triplesec');

ref = triplesec.hash, SHA1 = ref.SHA1, SHA256 = ref.SHA256;

AES = triplesec.ciphers.AES;

native_rng = triplesec.prng.native_rng;

ref1 = require('../../util'), bufferify = ref1.bufferify, uint_to_buffer = ref1.uint_to_buffer;

encrypt = require('../cfb').encrypt;

Packet = require('./base').Packet;

parse = require('pgp-utils').userid.parse;

UserID = (function(superClass) {
  extend(UserID, superClass);

  function UserID(userid, components1) {
    this.components = components1 != null ? components1 : null;
    this.userid = bufferify(userid);
    if (this.compontents == null) {
      this._parse();
    }
    UserID.__super__.constructor.call(this);
    this._time_primary_pair = null;
    this.primary = false;
    this.most_recent_sig = null;
  }

  UserID.prototype.utf8 = function() {
    return this.userid.toString('utf8');
  };

  UserID.prototype.write = function() {
    return this.frame_packet(C.packet_tags.userid, this.userid);
  };

  UserID.parse = function(slice) {
    return new UserID(slice.consume_rest_to_buffer());
  };

  UserID.prototype.to_userid = function() {
    return this;
  };

  UserID.prototype.cmp = function(b) {
    var x, y;
    x = this.utf8();
    y = b.utf8();
    if (x < y) {
      return -1;
    } else if (x === y) {
      return 0;
    } else {
      return 1;
    }
  };

  UserID.prototype.to_signature_payload = function() {
    return Buffer.concat([Buffer.from([C.signatures.userid]), uint_to_buffer(32, this.userid.length), this.userid]);
  };

  UserID.prototype._parse = function() {
    var c;
    if ((c = parse(this.utf8())) != null) {
      return this.components = c;
    }
  };

  UserID.prototype.get_username = function() {
    var ref2;
    return (ref2 = this.components) != null ? ref2.username : void 0;
  };

  UserID.prototype.get_comment = function() {
    var ref2;
    return (ref2 = this.components) != null ? ref2.comment : void 0;
  };

  UserID.prototype.get_email = function() {
    var ref2;
    return (ref2 = this.components) != null ? ref2.email : void 0;
  };

  UserID.prototype.time_primary_pair = function() {
    var i, len, max, p, pairs, ret, s;
    if (this._time_primary_pair == null) {
      pairs = (function() {
        var i, len, ref2, ref3, results;
        ref2 = this.get_psc().get_self_sigs();
        results = [];
        for (i = 0, len = ref2.length; i < len; i++) {
          s = ref2[i];
          results.push(s != null ? (ref3 = s.sig) != null ? ref3.time_primary_pair() : void 0 : void 0);
        }
        return results;
      }).call(this);
      max = null;
      ret = [null, null];
      for (i = 0, len = pairs.length; i < len; i++) {
        p = pairs[i];
        if (!(p != null)) {
          continue;
        }
        if (p[0] && ((ret[0] == null) || (ret[0] < p[0]))) {
          ret[0] = p[0];
        }
        if (p[1] && ((ret[1] == null) || (ret[1] < p[0]))) {
          ret[1] = p[0];
        }
      }
      this._time_primary_pair = ret;
      this.most_recent_sig = ret[0];
    }
    return this._time_primary_pair;
  };

  UserID.make = function(components) {
    var c, comment, userid;
    comment = (c = components.comment) != null ? "(" + c + ") " : "";
    userid = components.username + " " + comment + "<" + components.email + ">";
    return new UserID(userid, components);
  };

  UserID.prototype.get_framed_signature_output = function() {
    var ref2, ref3, ref4;
    return (ref2 = this.get_psc()) != null ? (ref3 = ref2.get_self_sig()) != null ? (ref4 = ref3.sig) != null ? ref4.get_framed_output() : void 0 : void 0 : void 0;
  };

  UserID.prototype.mark_revoked = function(sig) {
    return this.revocation = sig;
  };

  UserID.prototype.is_revoked = function() {
    return this.revocation != null;
  };

  return UserID;

})(Packet);

exports.UserID = UserID;

//# sourceMappingURL=userid.js.map
