// Generated by IcedCoffeeScript 112.8.1
var C, CreationTime, EmbeddedSignature, Experimental, ExpirationTime, Exportable, Features, Issuer, IssuerFingerprint, KeyExpirationTime, KeyFlags, KeyServerPreferences, NotationData, Packet, Parser, PolicyURI, Preference, PreferredCompressionAlgorithms, PreferredHashAlgorithms, PreferredKeyServer, PreferredSymmetricAlgorithms, PrimaryUserId, ReasonForRevocation, RegularExpression, Revocable, RevocationKey, S, SHA1, SHA512, Signature, SignatureTarget, Signature_v2, Signature_v2_or_v3, Signature_v3, SignersUserID, SlicerBuffer, SubPacket, Time, Trust, alloc_or_throw, assert, asymmetric, bufeq_secure, encode_length, iced, make_esc, make_time_packet, packetsigs, ref, ref1, ref2, uint_to_buffer, unix_time, util,
  extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty;

iced = require('iced-runtime-3');

Packet = require('./base').Packet;

C = require('../../const').openpgp;

S = C.sig_subpacket;

ref = require('../util'), encode_length = ref.encode_length, make_time_packet = ref.make_time_packet;

ref1 = require('../../util'), unix_time = ref1.unix_time, uint_to_buffer = ref1.uint_to_buffer, bufeq_secure = ref1.bufeq_secure;

ref2 = require('../../hash'), alloc_or_throw = ref2.alloc_or_throw, SHA512 = ref2.SHA512, SHA1 = ref2.SHA1;

asymmetric = require('../../asymmetric');

util = require('util');

packetsigs = require('./packetsigs');

assert = require('assert');

SlicerBuffer = require('../buffer').SlicerBuffer;

make_esc = require('iced-error').make_esc;

Signature_v2_or_v3 = (function(superClass) {
  extend(Signature_v2_or_v3, superClass);

  function Signature_v2_or_v3(arg) {
    this.key = arg.key, this.hasher = arg.hasher, this.key_id = arg.key_id, this.sig_data = arg.sig_data, this.public_key_class = arg.public_key_class, this.signed_hash_value_hash = arg.signed_hash_value_hash, this.time = arg.time, this.sig = arg.sig, this.type = arg.type, this.version = arg.version;
    if (this.hasher == null) {
      this.hasher = SHA512;
    }
    this._framed_output = null;
  }

  Signature_v2_or_v3.prototype.is_signature = function() {
    return true;
  };

  Signature_v2_or_v3.prototype.get_key_id = function() {
    return this.key_id;
  };

  Signature_v2_or_v3.prototype.get_key_flags = function() {
    return 0;
  };

  Signature_v2_or_v3.prototype.get_key_expires = function() {
    return 0;
  };

  Signature_v2_or_v3.prototype.get_issuer_key_id = function() {
    return this.key_id;
  };

  Signature_v2_or_v3.prototype.get_issuer_fingerprint = function() {
    return null;
  };

  Signature_v2_or_v3.prototype.when_generated = function() {
    return this.time;
  };

  Signature_v2_or_v3.prototype.time_of_primary_uid_sig = function() {
    return null;
  };

  Signature_v2_or_v3.prototype.gen_prefix = function() {
    return Buffer.concat([Buffer.from([C.versions.signature.V3, this.type], uint_to_buffer(32, this.time), this.key_id, Buffer.from([this.key.type, this.hasher.type]))]);
  };

  Signature_v2_or_v3.prototype.prepare_payload = function(data_packets) {
    var bufs, dp;
    bufs = (function() {
      var i, len1, results1;
      results1 = [];
      for (i = 0, len1 = data_packets.length; i < len1; i++) {
        dp = data_packets[i];
        results1.push(dp.to_signature_payload());
      }
      return results1;
    })();
    bufs.push(Buffer.from([this.type]), uint_to_buffer(32, this.time));
    return Buffer.concat(bufs);
  };

  Signature_v2_or_v3.prototype.verify = function(data_packets, cb) {
    var __iced_it, __iced_passed_deferral;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var SKB, T, b, d, err, hash, payload, s, v;
      return function*() {
        var __iced_deferrals, i, j, len1, len2, ref3, ref4;
        T = C.sig_types;
        SKB = packetsigs.SubkeyBinding;
        if (_this.type === T.subkey_binding) {
          data_packets = [_this.primary].concat(data_packets);
        }
        payload = _this.prepare_payload(data_packets);
        hash = _this.hasher(payload);
        s = new SlicerBuffer(hash);
        v = s.read_uint16();
        if (v !== (b = _this.signed_hash_value_hash)) {
          err = new Error("quick hash check failed: " + v + " != " + b);
        } else {
          __iced_deferrals = new iced.Deferrals(__iced_it, {
            parent: __iced_passed_deferral,
            funcname: "Signature_v2_or_v3::verify",
            filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/packet/signature.iced"
          });
          _this.key.verify_unpad_and_check_hash({
            hash: hash,
            hasher: _this.hasher,
            sig: _this.sig
          }, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                return err = arguments[0];
              };
            })(),
            lineno: 86
          }));
          if (__iced_deferrals.await_exit()) {
            yield;
          }
          if (err != null) {

          } else if ((ref3 = _this.type) === T.binary_doc || ref3 === T.canonical_text) {
            for (i = 0, len1 = data_packets.length; i < len1; i++) {
              d = data_packets[i];
              d.push_sig(new packetsigs.Data({
                sig: _this
              }));
            }
          } else if ((ref4 = _this.type) === T.subkey_binding) {
            for (j = 0, len2 = data_packets.length; j < len2; j++) {
              d = data_packets[j];
              d.push_sig(new SKB({
                primary: _this.primary,
                sig: _this,
                direction: SKB.DOWN
              }));
            }
          }
        }
        return cb(err);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  return Signature_v2_or_v3;

})(Packet);

Signature_v2 = (function(superClass) {
  extend(Signature_v2, superClass);

  function Signature_v2() {
    return Signature_v2.__super__.constructor.apply(this, arguments);
  }

  return Signature_v2;

})(Signature_v2_or_v3);

Signature_v3 = (function(superClass) {
  extend(Signature_v3, superClass);

  function Signature_v3() {
    return Signature_v3.__super__.constructor.apply(this, arguments);
  }

  return Signature_v3;

})(Signature_v2_or_v3);

Signature = (function(superClass) {
  extend(Signature, superClass);

  function Signature(arg) {
    this.key = arg.key, this.hasher = arg.hasher, this.key_id = arg.key_id, this.sig_data = arg.sig_data, this.public_key_class = arg.public_key_class, this.signed_hash_value_hash = arg.signed_hash_value_hash, this.hashed_subpackets = arg.hashed_subpackets, this.time = arg.time, this.sig = arg.sig, this.type = arg.type, this.unhashed_subpackets = arg.unhashed_subpackets, this.version = arg.version;
    if (this.hasher == null) {
      this.hasher = SHA512;
    }
    if (this.hashed_subpackets == null) {
      this.hashed_subpackets = [];
    }
    if (this.unhashed_subpackets == null) {
      this.unhashed_subpackets = [];
    }
    this.subpacket_index = this._make_subpacket_index();
    this._framed_output = null;
  }

  Signature.prototype.get_key_id = function() {
    var ref3;
    if (this.key_id) {
      return this.key_id;
    } else {
      return (ref3 = this.subpacket_index.all[S.issuer]) != null ? ref3.id : void 0;
    }
  };

  Signature.prototype._make_subpacket_index = function() {
    var i, j, len1, len2, p, ref3, ref4, ret;
    ret = {
      hashed: {},
      unhashed: {},
      all: {}
    };
    ref3 = this.hashed_subpackets;
    for (i = 0, len1 = ref3.length; i < len1; i++) {
      p = ref3[i];
      ret.hashed[p.type] = p;
      ret.all[p.type] = p;
    }
    ref4 = this.unhashed_subpackets;
    for (j = 0, len2 = ref4.length; j < len2; j++) {
      p = ref4[j];
      ret.unhashed[p.type] = p;
      ret.all[p.type] = p;
    }
    return ret;
  };

  Signature.prototype.prepare_payload = function(data) {
    var flatsp, hvalue, payload, prefix, s, trailer;
    flatsp = Buffer.concat((function() {
      var i, len1, ref3, results1;
      ref3 = this.hashed_subpackets;
      results1 = [];
      for (i = 0, len1 = ref3.length; i < len1; i++) {
        s = ref3[i];
        results1.push(s.to_buffer());
      }
      return results1;
    }).call(this));
    prefix = Buffer.concat([Buffer.from([C.versions.signature.V4, this.type, this.key.type, this.hasher.type]), uint_to_buffer(16, flatsp.length), flatsp]);
    trailer = Buffer.concat([Buffer.from([C.versions.signature.V4, 0xff]), uint_to_buffer(32, prefix.length)]);
    payload = Buffer.concat([data, prefix, trailer]);
    hvalue = this.hasher(payload);
    return {
      prefix: prefix,
      payload: payload,
      hvalue: hvalue
    };
  };

  Signature.prototype.write_unframed = function(data, cb) {
    var __iced_it, __iced_passed_deferral;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var esc, hvalue, payload, prefix, result2, results, s, sig, uhsp;
      return function*() {
        var __iced_deferrals, ref3;
        esc = make_esc(cb, "write_unframed");
        uhsp = Buffer.concat((function() {
          var i, len1, ref3, results1;
          ref3 = this.unhashed_subpackets;
          results1 = [];
          for (i = 0, len1 = ref3.length; i < len1; i++) {
            s = ref3[i];
            results1.push(s.to_buffer());
          }
          return results1;
        }).call(_this));
        ref3 = _this.prepare_payload(data), prefix = ref3.prefix, payload = ref3.payload, hvalue = ref3.hvalue;
        __iced_deferrals = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "Signature::write_unframed",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/packet/signature.iced"
        });
        _this.key.pad_and_sign(payload, {
          hasher: _this.hasher
        }, esc(__iced_deferrals.defer({
          assign_fn: (function() {
            return function() {
              return sig = arguments[0];
            };
          })(),
          lineno: 168
        })));
        if (__iced_deferrals.await_exit()) {
          yield;
        }
        result2 = Buffer.concat([uint_to_buffer(16, uhsp.length), uhsp, Buffer.from([hvalue.readUInt8(0), hvalue.readUInt8(1)]), sig]);
        results = Buffer.concat([prefix, result2]);
        return cb(null, results);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  Signature.prototype.write = function(data, cb) {
    var __iced_it, __iced_passed_deferral;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var err, ret, unframed;
      return function*() {
        var __iced_deferrals;
        __iced_deferrals = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "Signature::write",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/packet/signature.iced"
        });
        _this.write_unframed(data, __iced_deferrals.defer({
          assign_fn: (function() {
            return function() {
              err = arguments[0];
              return unframed = arguments[1];
            };
          })(),
          lineno: 181
        }));
        if (__iced_deferrals.await_exit()) {
          yield;
        }
        if (err == null) {
          _this._framed_output = ret = _this.frame_packet(C.packet_tags.signature, unframed);
        }
        return cb(err, ret);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  Signature.prototype.get_framed_output = function() {
    return this._framed_output || this.replay();
  };

  Signature.parse = function(slice) {
    return (new Parser(slice)).parse();
  };

  Signature.prototype.extract_key = function(data_packets) {
    var i, len1, p, results1;
    results1 = [];
    for (i = 0, len1 = data_packets.length; i < len1; i++) {
      p = data_packets[i];
      if (p.key != null) {
        this.key = p.key;
        break;
      } else {
        results1.push(void 0);
      }
    }
    return results1;
  };

  Signature.prototype.verify = function(data_packets, cb, opts) {
    var __iced_it, __iced_passed_deferral;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var err, p, s, subkey;
      return function*() {
        var __iced_deferrals, __iced_deferrals1, i, len1, ref3;
        if (err = opts != null ? typeof opts.assert_pgp_hash === "function" ? opts.assert_pgp_hash(_this.hasher, _this) : void 0 : void 0) {
          return cb(err);
        }
        __iced_deferrals = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "Signature::verify",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/packet/signature.iced"
        });
        _this._verify(data_packets, __iced_deferrals.defer({
          assign_fn: (function() {
            return function() {
              return err = arguments[0];
            };
          })(),
          lineno: 213
        }), opts);
        if (__iced_deferrals.await_exit()) {
          yield;
        }
        ref3 = _this.unhashed_subpackets;
        for (i = 0, len1 = ref3.length; i < len1; i++) {
          p = ref3[i];
          if ((err == null) && ((s = p.to_sig()) != null)) {
            if (s.type !== C.sig_types.primary_binding) {
              err = new Error("unknown subpacket signature type: " + s.type);
            } else if (data_packets.length !== 1) {
              err = new Error("Needed 1 data packet for a primary_binding signature");
            } else {
              subkey = data_packets[0];
              s.parent = _this;
              s.primary = _this.primary;
              s.key = subkey.key;
              __iced_deferrals1 = new iced.Deferrals(__iced_it, {
                parent: __iced_passed_deferral,
                funcname: "Signature::verify",
                filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/packet/signature.iced"
              });
              s._verify([subkey], __iced_deferrals1.defer({
                assign_fn: (function() {
                  return function() {
                    return err = arguments[0];
                  };
                })(),
                lineno: 224
              }), opts);
              if (__iced_deferrals1.await_exit()) {
                yield;
              }
            }
          }
        }
        return cb(err);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  Signature.prototype._verify = function(data_packets, cb, opts) {
    var __iced_it, __iced_passed_deferral;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var SKB, T, buffers, d, data, dp, err, fp, hvalue, key_expiration, n, packets, payload, ps, sig, sig_expiration, subkey, user_attribute, userid;
      return function*() {
        var __iced_deferrals, i, len1, ref3, ref4, ref5;
        err = null;
        T = C.sig_types;
        subkey = null;
        _this.data_packets = (function() {
          switch (this.type) {
            case T.binary_doc:
            case T.canonical_text:
              return data_packets;
            case T.issuer:
            case T.persona:
            case T.casual:
            case T.positive:
            case T.certificate_revocation:
            case T.key_revocation:
              if ((n = data_packets.length) > 1) {
                err = new Error("Only expecting one (or no) UserID-style packet(s) in a self-sig (got " + n + ")");
                return [];
              } else {
                return [this.primary].concat(data_packets);
              }
              break;
            case T.subkey_binding:
            case T.primary_binding:
            case T.subkey_revocation:
              packets = [];
              if (data_packets.length !== 1) {
                err = new Error("Wrong number of data packets; expected only 1");
              } else if (this.primary == null) {
                err = new Error("Need a primary key for subkey signature");
              } else {
                subkey = data_packets[0];
                packets = [this.primary, subkey];
              }
              return packets;
            case T.direct:
              return [this.primary].concat(data_packets);
            default:
              err = new Error("cannot verify sigtype " + this.type);
              return [];
          }
        }).call(_this);
        if (!((err != null) || (_this.is_third_party && _this.type === T.key_revocation))) {
          buffers = (function() {
            var i, len1, ref3, results1;
            ref3 = this.data_packets;
            results1 = [];
            for (i = 0, len1 = ref3.length; i < len1; i++) {
              dp = ref3[i];
              results1.push(dp.to_signature_payload());
            }
            return results1;
          }).call(_this);
          data = Buffer.concat(buffers);
          ref3 = _this.prepare_payload(data), payload = ref3.payload, hvalue = ref3.hvalue;
          __iced_deferrals = new iced.Deferrals(__iced_it, {
            parent: __iced_passed_deferral,
            funcname: "Signature::_verify",
            filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/packet/signature.iced"
          });
          _this.key.verify_unpad_and_check_hash({
            sig: _this.sig,
            hash: hvalue,
            hasher: _this.hasher
          }, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                return err = arguments[0];
              };
            })(),
            lineno: 276
          }));
          if (__iced_deferrals.await_exit()) {
            yield;
          }
        }
        if ((err == null) && (_this.key_manager != null)) {
          err = _this.key_manager.pgp_check_not_expired({
            subkey_material: _this.subkey_material,
            now: opts != null ? opts.now : void 0
          });
        }
        if (err == null) {
          opts || (opts = {});
          opts.subkey = subkey;
          ref4 = _this._check_key_sig_expiration(opts), err = ref4[0], key_expiration = ref4[1], sig_expiration = ref4[2];
          opts.subkey = null;
        }
        sig = _this;
        if (err == null) {
          SKB = packetsigs.SubkeyBinding;
          switch (_this.type) {
            case T.binary_doc:
            case T.canonical_text:
              ref5 = _this.data_packets;
              for (i = 0, len1 = ref5.length; i < len1; i++) {
                d = ref5[i];
                d.push_sig(new packetsigs.Data({
                  sig: sig
                }));
              }
              break;
            case T.issuer:
            case T.persona:
            case T.casual:
            case T.positive:
              ps = null;
              if ((userid = _this.data_packets[1].to_userid()) != null) {
                ps = new packetsigs.SelfSig({
                  type: _this.type,
                  userid: userid,
                  sig: sig
                });
                userid.push_sig(ps);
              } else if ((user_attribute = _this.data_packets[1].to_user_attribute()) != null) {
                ps = new packetsigs.SelfSig({
                  type: _this.type,
                  user_attribute: user_attribute,
                  sig: sig,
                  key_expiration: key_expiration,
                  sig_expiration: sig_expiration
                });
                user_attribute.push_sig(ps);
              }
              if (ps) {
                _this.primary.push_sig(ps);
              }
              break;
            case T.subkey_binding:
              subkey.push_sig(new SKB({
                primary: _this.primary,
                sig: sig,
                direction: SKB.DOWN,
                key_expiration: key_expiration,
                sig_expiration: sig_expiration
              }));
              break;
            case T.primary_binding:
              subkey.push_sig(new SKB({
                primary: _this.primary,
                sig: sig,
                direction: SKB.UP,
                key_expiration: key_expiration,
                sig_expiration: sig_expiration
              }));
              break;
            case T.subkey_revocation:
              subkey.mark_revoked(sig);
              break;
            case T.key_revocation:
              if (_this.issuer_matches_key(_this.primary)) {
                _this.primary.mark_revoked(sig);
              } else {
                _this.primary.add_designated_revocation(sig);
              }
              break;
            case T.direct:
              if (fp = _this.subpacket_index.hashed[S.revocation_key]) {
                _this.primary.add_designee(fp);
              }
              break;
            case T.certificate_revocation:
              if ((userid = _this.data_packets[1].to_userid()) != null) {
                userid.mark_revoked(sig);
              }
              break;
            default:
              err = new Error("Got unknown signature type=" + _this.type);
          }
        }
        return cb(err);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  Signature.prototype._third_party_verify = function(key, cb) {
    var __iced_it, __iced_passed_deferral;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var buffers, data, dp, err, hvalue, issuer, keyid, payload;
      return function*() {
        var __iced_deferrals, ref3;
        if (!bufeq_secure(issuer = _this.get_issuer_key_id(), keyid = key.get_key_id())) {
          return cb(new Error("Key id does not match: " + (issuer.toString('hex')) + " != " + (keyid.toString('hex'))));
        }
        buffers = (function() {
          var i, len1, ref3, results1;
          ref3 = this.data_packets;
          results1 = [];
          for (i = 0, len1 = ref3.length; i < len1; i++) {
            dp = ref3[i];
            results1.push(dp.to_signature_payload());
          }
          return results1;
        }).call(_this);
        data = Buffer.concat(buffers);
        ref3 = _this.prepare_payload(data), payload = ref3.payload, hvalue = ref3.hvalue;
        __iced_deferrals = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "Signature::_third_party_verify",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/packet/signature.iced"
        });
        key.key.verify_unpad_and_check_hash({
          sig: _this.sig,
          hash: hvalue,
          hasher: _this.hasher
        }, __iced_deferrals.defer({
          assign_fn: (function() {
            return function() {
              return err = arguments[0];
            };
          })(),
          lineno: 352
        }));
        if (__iced_deferrals.await_exit()) {
          yield;
        }
        return cb(err);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  Signature.prototype.is_signature = function() {
    return true;
  };

  Signature.prototype.issuer_matches_key = function(key) {
    var fp;
    if ((fp = this.get_issuer_fingerprint()) != null) {
      if (!bufeq_secure(fp, this.primary.get_fingerprint())) {
        return false;
      }
    }
    return bufeq_secure(this.get_issuer_key_id(), this.primary.get_key_id());
  };

  Signature.prototype.when_generated = function() {
    var ref3;
    return (ref3 = this.subpacket_index.hashed[S.creation_time]) != null ? ref3.time : void 0;
  };

  Signature.prototype.get_key_expires = function() {
    var ref3;
    return (ref3 = this.subpacket_index.hashed[S.key_expiration_time]) != null ? ref3.time : void 0;
  };

  Signature.prototype.get_sig_expires = function() {
    var ref3;
    return (ref3 = this.subpacket_index.hashed[S.expiration_time]) != null ? ref3.time : void 0;
  };

  Signature.prototype.key_expiration_after_other = function(other) {
    var other_expire, this_expire;
    this_expire = this.get_key_expires();
    other_expire = other.get_key_expires();
    if (!this_expire) {
      return true;
    } else if (!other_expire) {
      return false;
    } else {
      return this_expire > other_expire;
    }
  };

  Signature.prototype.time_primary_pair = function() {
    var T, ref3, ref4;
    T = C.sig_types;
    if ((ref3 = this.type) === T.issuer || ref3 === T.persona || ref3 === T.casual || ref3 === T.positive) {
      return [this.when_generated(), !!((ref4 = this.subpacket_index.hashed[S.primary_user_id]) != null ? ref4.flag : void 0)];
    } else {
      return null;
    }
  };

  Signature.prototype._check_key_sig_expiration = function(opts) {
    var T, err, key_creation, key_expiration, key_expiration_packet, n, now, ref3, sig_creation_packet, sig_expiration, sig_expiration_packet;
    err = null;
    T = C.sig_types;
    key_expiration = 0;
    sig_expiration = 0;
    if ((ref3 = this.type) === T.issuer || ref3 === T.persona || ref3 === T.casual || ref3 === T.positive || ref3 === T.subkey_binding || ref3 === T.primary_binding) {
      key_creation = (opts.subkey || this.primary).timestamp;
      key_expiration_packet = this.subpacket_index.hashed[S.key_expiration_time];
      sig_creation_packet = this.subpacket_index.hashed[S.creation_time];
      sig_expiration_packet = this.subpacket_index.hashed[S.sig_expiration_time];
      now = (n = opts != null ? opts.now : void 0) != null ? n : unix_time();
      if ((key_creation != null) && (key_expiration_packet != null ? key_expiration_packet.time : void 0)) {
        key_expiration = key_creation + key_expiration_packet.time;
      }
      if ((sig_creation_packet != null) && (sig_expiration_packet != null ? sig_expiration_packet.time : void 0)) {
        sig_expiration = sig_creation_packet.time + sig_expiration_packet.time;
      }
      if (key_expiration && !opts.time_travel && now > key_expiration) {
        err = new Error("Key expired " + (now - key_expiration) + "s ago");
      }
      if (sig_expiration && !opts.time_travel && now > sig_expiration) {
        err = new Error("Sig expired " + (now - key_expiration) + "s ago");
      }
    }
    return [err, key_expiration, sig_expiration];
  };

  Signature.prototype.get_key_flags = function() {
    var ref3, ref4, ref5;
    return ((ref3 = this.subpacket_index) != null ? (ref4 = ref3.hashed) != null ? (ref5 = ref4[C.sig_subpacket.key_flags]) != null ? ref5.all_flags() : void 0 : void 0 : void 0) || 0;
  };

  Signature.prototype.get_issuer_key_id = function() {
    var ref3, ref4;
    return (ref3 = this.subpacket_index) != null ? (ref4 = ref3.all[C.sig_subpacket.issuer]) != null ? ref4.id : void 0 : void 0;
  };

  Signature.prototype.get_issuer_fingerprint = function() {
    var ref3;
    return (ref3 = this.subpacket_index.all[S.issuer_fingerprint]) != null ? ref3.fingerprint : void 0;
  };

  return Signature;

})(Packet);

SubPacket = (function() {
  function SubPacket(type1) {
    this.type = type1;
    this.critical = false;
    this.five_byte_len = false;
  }

  SubPacket.prototype.set_opts = function(d) {
    var k, v;
    for (k in d) {
      v = d[k];
      this[k] = v;
    }
    return true;
  };

  SubPacket.prototype.to_buffer = function() {
    var inner;
    inner = this._v_to_buffer();
    return Buffer.concat([encode_length(inner.length + 1, this.five_byte_len), uint_to_buffer(8, this.type | (this.critical ? 0x80 : 0x00)), inner]);
  };

  SubPacket.prototype.to_sig = function() {
    return null;
  };

  SubPacket.prototype.export_to_option = function() {
    return null;
  };

  return SubPacket;

})();

Experimental = (function(superClass) {
  extend(Experimental, superClass);

  function Experimental(buf, type1) {
    this.buf = buf;
    this.type = type1;
  }

  Experimental.parse = function(slice, type) {
    return new Experimental(slice.consume_rest_to_buffer(), type);
  };

  Experimental.prototype._v_to_buffer = function() {
    return this.buf;
  };

  return Experimental;

})(SubPacket);

Time = (function(superClass) {
  extend(Time, superClass);

  function Time(type, time) {
    this.time = time;
    this.never_expires = this.time === 0;
    Time.__super__.constructor.call(this, type);
  }

  Time.parse = function(slice, klass) {
    return new klass(slice.read_uint32());
  };

  Time.prototype._v_to_buffer = function() {
    return uint_to_buffer(32, this.time);
  };

  return Time;

})(SubPacket);

Preference = (function(superClass) {
  extend(Preference, superClass);

  function Preference(type, v1) {
    var e, i, len1, ref3;
    this.v = v1;
    Preference.__super__.constructor.call(this, type);
    ref3 = this.v;
    for (i = 0, len1 = ref3.length; i < len1; i++) {
      e = ref3[i];
      assert(e != null);
    }
  }

  Preference.parse = function(slice, klass) {
    var c, v;
    v = (function() {
      var i, len1, ref3, results1;
      ref3 = slice.consume_rest_to_buffer();
      results1 = [];
      for (i = 0, len1 = ref3.length; i < len1; i++) {
        c = ref3[i];
        results1.push(c);
      }
      return results1;
    })();
    return new klass(v);
  };

  Preference.prototype._v_to_buffer = function() {
    var e;
    return Buffer.from((function() {
      var i, len1, ref3, results1;
      ref3 = this.v;
      results1 = [];
      for (i = 0, len1 = ref3.length; i < len1; i++) {
        e = ref3[i];
        results1.push(e);
      }
      return results1;
    }).call(this));
  };

  return Preference;

})(SubPacket);

CreationTime = (function(superClass) {
  extend(CreationTime, superClass);

  function CreationTime(t) {
    CreationTime.__super__.constructor.call(this, S.creation_time, t);
  }

  CreationTime.parse = function(slice) {
    return Time.parse(slice, CreationTime);
  };

  return CreationTime;

})(Time);

ExpirationTime = (function(superClass) {
  extend(ExpirationTime, superClass);

  function ExpirationTime(t) {
    ExpirationTime.__super__.constructor.call(this, S.expiration_time, t);
  }

  ExpirationTime.parse = function(slice) {
    return Time.parse(slice, ExpirationTime);
  };

  return ExpirationTime;

})(Time);

Exportable = (function(superClass) {
  extend(Exportable, superClass);

  function Exportable(flag1) {
    this.flag = flag1;
    Exportable.__super__.constructor.call(this, S.exportable_certificate);
  }

  Exportable.parse = function(slice) {
    return new Exportable(slice.read_uint8());
  };

  Exportable.prototype._v_to_buffer = function() {
    return uint_to_buffer(8, this.flag);
  };

  return Exportable;

})(SubPacket);

Trust = (function(superClass) {
  extend(Trust, superClass);

  function Trust(level, amount) {
    this.level = level;
    this.amount = amount;
    Trust.__super__.constructor.call(this, S.trust_signature);
  }

  Trust.parse = function(slice) {
    return new Trust(slice.read_uint8(), slice.read_uint8());
  };

  Trust.prototype._v_to_buffer = function() {
    return Buffer.concat([uint_to_buffer(8, this.level), uint_to_buffer(8, this.amount)]);
  };

  return Trust;

})(SubPacket);

RegularExpression = (function(superClass) {
  extend(RegularExpression, superClass);

  function RegularExpression(re) {
    this.re = re;
    RegularExpression.__super__.constructor.call(this, S.regular_expression);
  }

  RegularExpression.parse = function(slice) {
    var ret;
    ret = new RegularExpression(slice.consume_rest_to_buffer().toString('utf8'));
    return ret;
  };

  RegularExpression.prototype._v_to_buffer = function() {
    return Buffer.from(this.re, 'utf8');
  };

  return RegularExpression;

})(SubPacket);

Revocable = (function(superClass) {
  extend(Revocable, superClass);

  function Revocable(flag1) {
    this.flag = flag1;
    Revocable.__super__.constructor.call(this, S.revocable);
  }

  Revocable.parse = function(slice) {
    return new Revocable(slice.read_uint8());
  };

  Revocable.prototype._v_to_buffer = function() {
    return uint_to_buffer(8, this.flag);
  };

  return Revocable;

})(SubPacket);

KeyExpirationTime = (function(superClass) {
  extend(KeyExpirationTime, superClass);

  function KeyExpirationTime(t) {
    KeyExpirationTime.__super__.constructor.call(this, S.key_expiration_time, t);
  }

  KeyExpirationTime.parse = function(slice) {
    return Time.parse(slice, KeyExpirationTime);
  };

  return KeyExpirationTime;

})(Time);

PreferredSymmetricAlgorithms = (function(superClass) {
  extend(PreferredSymmetricAlgorithms, superClass);

  function PreferredSymmetricAlgorithms(v) {
    PreferredSymmetricAlgorithms.__super__.constructor.call(this, S.preferred_symmetric_algorithms, v);
  }

  PreferredSymmetricAlgorithms.parse = function(slice) {
    return Preference.parse(slice, PreferredSymmetricAlgorithms);
  };

  return PreferredSymmetricAlgorithms;

})(Preference);

RevocationKey = (function(superClass) {
  extend(RevocationKey, superClass);

  function RevocationKey(key_class, alg, fingerprint) {
    this.key_class = key_class;
    this.alg = alg;
    this.fingerprint = fingerprint;
    RevocationKey.__super__.constructor.call(this, S.revocation_key);
  }

  RevocationKey.parse = function(slice) {
    var fp, ka, kc;
    kc = slice.read_uint8();
    ka = slice.read_uint8();
    fp = slice.read_buffer(SHA1.output_length);
    return new RevocationKey(kc, ka, fp);
  };

  RevocationKey.prototype._v_to_buffer = function() {
    return Buffer.concat([uint_to_buffer(8, this.key_class), uint_to_buffer(8, this.alg), Buffer.from(this.fingerprint)]);
  };

  return RevocationKey;

})(SubPacket);

Issuer = (function(superClass) {
  extend(Issuer, superClass);

  function Issuer(id) {
    this.id = id;
    Issuer.__super__.constructor.call(this, S.issuer);
  }

  Issuer.parse = function(slice) {
    return new Issuer(slice.read_buffer(8));
  };

  Issuer.prototype._v_to_buffer = function() {
    return Buffer.from(this.id);
  };

  return Issuer;

})(SubPacket);

NotationData = (function(superClass) {
  extend(NotationData, superClass);

  function NotationData(flags1, name1, value1) {
    this.flags = flags1;
    this.name = name1;
    this.value = value1;
    NotationData.__super__.constructor.call(this, S.notation_data);
  }

  NotationData.parse = function(slice) {
    var flags, name, nl, value, vl;
    flags = slice.read_uint32();
    nl = slice.read_uint16();
    vl = slice.read_uint16();
    name = slice.read_buffer(nl);
    value = slice.read_buffer(vl);
    return new NotationData(flags, name, value);
  };

  NotationData.prototype._v_to_buffer = function() {
    return Buffer.concat([uint_to_buffer(32, this.flags), uint_to_buffer(16, this.name.length), uint_to_buffer(16, this.value.length), Buffer.from(this.name), Buffer.from(this.value)]);
  };

  return NotationData;

})(SubPacket);

PreferredHashAlgorithms = (function(superClass) {
  extend(PreferredHashAlgorithms, superClass);

  function PreferredHashAlgorithms(v) {
    PreferredHashAlgorithms.__super__.constructor.call(this, S.preferred_hash_algorithms, v);
  }

  PreferredHashAlgorithms.parse = function(slice) {
    return Preference.parse(slice, PreferredHashAlgorithms);
  };

  return PreferredHashAlgorithms;

})(Preference);

PreferredCompressionAlgorithms = (function(superClass) {
  extend(PreferredCompressionAlgorithms, superClass);

  function PreferredCompressionAlgorithms(v) {
    PreferredCompressionAlgorithms.__super__.constructor.call(this, S.preferred_compression_algorithms, v);
  }

  PreferredCompressionAlgorithms.parse = function(slice) {
    return Preference.parse(slice, PreferredCompressionAlgorithms);
  };

  return PreferredCompressionAlgorithms;

})(Preference);

KeyServerPreferences = (function(superClass) {
  extend(KeyServerPreferences, superClass);

  function KeyServerPreferences(v) {
    KeyServerPreferences.__super__.constructor.call(this, S.key_server_preferences, v);
  }

  KeyServerPreferences.parse = function(slice) {
    return Preference.parse(slice, KeyServerPreferences);
  };

  return KeyServerPreferences;

})(Preference);

Features = (function(superClass) {
  extend(Features, superClass);

  function Features(v) {
    Features.__super__.constructor.call(this, S.features, v);
  }

  Features.parse = function(slice) {
    return Preference.parse(slice, Features);
  };

  return Features;

})(Preference);

PreferredKeyServer = (function(superClass) {
  extend(PreferredKeyServer, superClass);

  function PreferredKeyServer(server) {
    this.server = server;
    PreferredKeyServer.__super__.constructor.call(this, S.preferred_key_server);
  }

  PreferredKeyServer.parse = function(slice) {
    return new PreferredKeyServer(slice.consume_rest_to_buffer());
  };

  PreferredKeyServer.prototype._v_to_buffer = function() {
    return this.server;
  };

  return PreferredKeyServer;

})(SubPacket);

PrimaryUserId = (function(superClass) {
  extend(PrimaryUserId, superClass);

  function PrimaryUserId(flag1) {
    this.flag = flag1;
    PrimaryUserId.__super__.constructor.call(this, S.primary_user_id);
  }

  PrimaryUserId.parse = function(slice) {
    return new PrimaryUserId(slice.read_uint8());
  };

  PrimaryUserId.prototype._v_to_buffer = function() {
    return uint_to_buffer(8, this.flag);
  };

  return PrimaryUserId;

})(SubPacket);

PolicyURI = (function(superClass) {
  extend(PolicyURI, superClass);

  function PolicyURI(flag1) {
    this.flag = flag1;
    PolicyURI.__super__.constructor.call(this, S.policy_uri);
  }

  PolicyURI.parse = function(slice) {
    return new PolicyURI(slice.consume_rest_to_buffer());
  };

  PolicyURI.prototype._v_to_buffer = function() {
    return this.flag;
  };

  return PolicyURI;

})(SubPacket);

KeyFlags = (function(superClass) {
  extend(KeyFlags, superClass);

  function KeyFlags(v) {
    KeyFlags.__super__.constructor.call(this, S.key_flags, v);
  }

  KeyFlags.parse = function(slice) {
    return Preference.parse(slice, KeyFlags);
  };

  KeyFlags.prototype.all_flags = function() {
    var e, i, len1, ref3, ret;
    ret = 0;
    ref3 = this.v;
    for (i = 0, len1 = ref3.length; i < len1; i++) {
      e = ref3[i];
      ret |= e;
    }
    return ret;
  };

  return KeyFlags;

})(Preference);

SignersUserID = (function(superClass) {
  extend(SignersUserID, superClass);

  function SignersUserID(uid) {
    this.uid = uid;
    SignersUserID.__super__.constructor.call(this, S.signers_user_id);
  }

  SignersUserID.parse = function(slice) {
    return new SignersUserID(slice.consume_rest_to_buffer());
  };

  SignersUserID.prototype._v_to_buffer = function() {
    return this.uid;
  };

  return SignersUserID;

})(SubPacket);

ReasonForRevocation = (function(superClass) {
  extend(ReasonForRevocation, superClass);

  function ReasonForRevocation(flag1, reason1) {
    this.flag = flag1;
    this.reason = reason1;
    ReasonForRevocation.__super__.constructor.call(this, S.reason_for_revocation);
  }

  ReasonForRevocation.parse = function(slice) {
    var flag, reason;
    flag = slice.read_uint8();
    reason = slice.consume_rest_to_buffer();
    return new ReasonForRevocation(flag, reason);
  };

  ReasonForRevocation.prototype._v_to_buffer = function() {
    return Buffer.concat([uint_to_buffer(8, this.flag), this.reason]);
  };

  return ReasonForRevocation;

})(SubPacket);

SignatureTarget = (function(superClass) {
  extend(SignatureTarget, superClass);

  function SignatureTarget(pub_key_alg, hasher1, hval1) {
    this.pub_key_alg = pub_key_alg;
    this.hasher = hasher1;
    this.hval = hval1;
    SignatureTarget.__super__.constructor.call(this, S.signature_target);
  }

  SignatureTarget.parse = function(slice) {
    var hasher, hval, pka;
    pka = slice.read_uint8();
    hasher = alloc_or_throw(slice.read_uint8());
    hval = slice.read_buffer(hasher.output_length);
    return new SignatureTarget(pka, hasher, hval);
  };

  SignatureTarget.prototype._v_to_buffer = function() {
    return Buffer.concat([uint_to_buffer(8, this.pub_key_alg), uint_to_buffer(8, this.hasher.type), this.hval]);
  };

  return SignatureTarget;

})(SubPacket);

EmbeddedSignature = (function(superClass) {
  extend(EmbeddedSignature, superClass);

  function EmbeddedSignature(arg) {
    this.sig = arg.sig, this.rawsig = arg.rawsig;
    EmbeddedSignature.__super__.constructor.call(this, S.embedded_signature);
  }

  EmbeddedSignature.prototype._v_to_buffer = function() {
    return this.rawsig;
  };

  EmbeddedSignature.prototype.to_sig = function() {
    return this.sig;
  };

  EmbeddedSignature.parse = function(slice) {
    var rawsig, sig;
    rawsig = slice.peek_rest_to_buffer();
    sig = Signature.parse(slice);
    return new EmbeddedSignature({
      sig: sig,
      rawsig: rawsig
    });
  };

  return EmbeddedSignature;

})(SubPacket);

IssuerFingerprint = (function(superClass) {
  extend(IssuerFingerprint, superClass);

  function IssuerFingerprint(n1, fingerprint) {
    this.n = n1;
    this.fingerprint = fingerprint;
    IssuerFingerprint.__super__.constructor.call(this, S.issuer_fingerprint);
  }

  IssuerFingerprint.parse = function(slice) {
    var fp, n;
    n = slice.read_uint8();
    fp = slice.consume_rest_to_buffer();
    return new IssuerFingerprint(n, fp);
  };

  IssuerFingerprint.prototype._v_to_buffer = function() {
    return Buffer.concat([uint_to_buffer(8, this.n), this.fingerprint]);
  };

  return IssuerFingerprint;

})(SubPacket);

exports.Signature = Signature;

Parser = (function() {
  function Parser(slice1) {
    this.slice = slice1;
  }

  Parser.prototype.parse_v2_or_v3 = function(v, klass) {
    var o;
    if (this.slice.read_uint8() !== 5) {
      throw new error("Bad one-octet length");
    }
    o = {};
    o.type = this.slice.read_uint8();
    o.time = this.slice.read_uint32();
    o.sig_data = this.slice.peek_rest_to_buffer();
    o.key_id = this.slice.read_buffer(8);
    o.public_key_class = asymmetric.get_class(this.slice.read_uint8());
    o.hasher = alloc_or_throw(this.slice.read_uint8());
    o.signed_hash_value_hash = this.slice.read_uint16();
    o.sig = o.public_key_class.parse_sig(this.slice);
    o.version = v;
    return new klass(o);
  };

  Parser.prototype.parse_v4 = function() {
    var end, hashed_subpacket_count, o, unhashed_subpacket_count;
    o = {};
    o.type = this.slice.read_uint8();
    o.public_key_class = asymmetric.get_class(this.slice.read_uint8());
    o.hasher = alloc_or_throw(this.slice.read_uint8());
    hashed_subpacket_count = this.slice.read_uint16();
    end = this.slice.i + hashed_subpacket_count;
    o.sig_data = this.slice.peek_to_buffer(hashed_subpacket_count);
    o.hashed_subpackets = ((function() {
      var results1;
      results1 = [];
      while (this.slice.i < end) {
        results1.push(this.parse_subpacket());
      }
      return results1;
    }).call(this));
    unhashed_subpacket_count = this.slice.read_uint16();
    end = this.slice.i + unhashed_subpacket_count;
    o.unhashed_subpackets = ((function() {
      var results1;
      results1 = [];
      while (this.slice.i < end) {
        results1.push(this.parse_subpacket());
      }
      return results1;
    }).call(this));
    o.signed_hash_value_hash = this.slice.read_uint16();
    o.sig = o.public_key_class.parse_sig(this.slice);
    o.version = 4;
    return new Signature(o);
  };

  Parser.prototype.parse_subpacket = function() {
    var critical, end, five_byte_len, klass, len, raw_type, ref3, ret, type;
    ref3 = this.slice.read_v4_length(), len = ref3[0], five_byte_len = ref3[1];
    raw_type = this.slice.read_uint8();
    type = raw_type & 0x7f;
    critical = !!(raw_type & 0x80);
    end = this.slice.clamp(len - 1);
    klass = (function() {
      switch (type) {
        case S.creation_time:
          return CreationTime;
        case S.expiration_time:
          return ExpirationTime;
        case S.exportable_certificate:
          return Exportable;
        case S.trust_signature:
          return Trust;
        case S.regular_expression:
          return RegularExpression;
        case S.revocable:
          return Revocable;
        case S.key_expiration_time:
          return KeyExpirationTime;
        case S.preferred_symmetric_algorithms:
          return PreferredSymmetricAlgorithms;
        case S.revocation_key:
          return RevocationKey;
        case S.issuer:
          return Issuer;
        case S.notation_data:
          return NotationData;
        case S.preferred_hash_algorithms:
          return PreferredHashAlgorithms;
        case S.preferred_compression_algorithms:
          return PreferredCompressionAlgorithms;
        case S.key_server_preferences:
          return KeyServerPreferences;
        case S.preferred_key_server:
          return PreferredKeyServer;
        case S.primary_user_id:
          return PrimaryUserId;
        case S.policy_uri:
          return PolicyURI;
        case S.key_flags:
          return KeyFlags;
        case S.signers_user_id:
          return SignersUserID;
        case S.reason_for_revocation:
          return ReasonForRevocation;
        case S.features:
          return Features;
        case S.signature_target:
          return SignatureTarget;
        case S.embedded_signature:
          return EmbeddedSignature;
        case S.issuer_fingerprint:
          return IssuerFingerprint;
        default:
          if (type >= S.experimental_low && type <= S.experimental_high) {
            return Experimental;
          } else {
            throw new Error("Unknown signature subpacket: " + type);
          }
      }
    })();
    ret = klass.parse(this.slice, type);
    ret.set_opts({
      critical: critical,
      five_byte_len: five_byte_len
    });
    this.slice.unclamp(end);
    return ret;
  };

  Parser.prototype.parse = function() {
    var version;
    version = this.slice.read_uint8();
    switch (version) {
      case C.versions.signature.V2:
        return this.parse_v2_or_v3(version, Signature_v2);
      case C.versions.signature.V3:
        return this.parse_v2_or_v3(version, Signature_v3);
      case C.versions.signature.V4:
        return this.parse_v4();
      default:
        throw new Error("Unknown signature version: " + version);
    }
  };

  return Parser;

})();

exports.CreationTime = CreationTime;

exports.KeyFlags = KeyFlags;

exports.KeyExpirationTime = KeyExpirationTime;

exports.PreferredSymmetricAlgorithms = PreferredSymmetricAlgorithms;

exports.PreferredHashAlgorithms = PreferredHashAlgorithms;

exports.PreferredCompressionAlgorithms = PreferredCompressionAlgorithms;

exports.Features = Features;

exports.KeyServerPreferences = KeyServerPreferences;

exports.Issuer = Issuer;

exports.EmbeddedSignature = EmbeddedSignature;

exports.PrimaryUserId = PrimaryUserId;

//# sourceMappingURL=signature.js.map
