// Generated by IcedCoffeeScript 112.8.1
var ASP, C, Decryptor, MDC, MDC_Parser, PKESK, PKESK_Parser, Packet, SEIPD, SEIPD_Parser, SHA1, asymmetric, bufeq_fast, bufeq_secure, encrypt, iced, make_esc, ref, ref1, ref2, streamers, uint_to_buffer,
  extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty;

iced = require('iced-runtime-3');

Packet = require('./base').Packet;

C = require('../../const').openpgp;

asymmetric = require('../../asymmetric');

ref = require('../../hash'), SHA1 = ref.SHA1, streamers = ref.streamers;

ref1 = require('../../util'), uint_to_buffer = ref1.uint_to_buffer, bufeq_secure = ref1.bufeq_secure, bufeq_fast = ref1.bufeq_fast;

ref2 = require('../ocfb'), encrypt = ref2.encrypt, Decryptor = ref2.Decryptor;

ASP = require('pgp-utils').util.ASP;

make_esc = require('iced-error').make_esc;

PKESK = (function(superClass) {
  extend(PKESK, superClass);

  function PKESK(arg) {
    this.crypto_type = arg.crypto_type, this.key_id = arg.key_id, this.ekey = arg.ekey;
  }

  PKESK.parse = function(slice) {
    return (new PKESK_Parser(slice)).parse();
  };

  PKESK.prototype.to_esk_packet = function() {
    return this;
  };

  PKESK.prototype.get_key_id = function() {
    return this.key_id;
  };

  PKESK.prototype.write_unframed = function(cb) {
    var bufs, err, ret;
    bufs = [uint_to_buffer(8, C.versions.PKESK), this.key_id, uint_to_buffer(8, this.crypto_type), this.ekey.output()];
    ret = Buffer.concat(bufs);
    err = null;
    return cb(err, ret);
  };

  PKESK.prototype.write = function(cb) {
    var __iced_it, __iced_passed_deferral;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var err, ret, unframed;
      return function*() {
        var __iced_deferrals;
        ret = null;
        __iced_deferrals = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "PKESK::write",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/packet/sess.iced"
        });
        _this.write_unframed(__iced_deferrals.defer({
          assign_fn: (function() {
            return function() {
              err = arguments[0];
              return unframed = arguments[1];
            };
          })(),
          lineno: 36
        }));
        if (__iced_deferrals.await_exit()) {
          yield;
        }
        if (err == null) {
          ret = _this.frame_packet(C.packet_tags.PKESK, unframed);
        }
        return cb(err, ret);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  return PKESK;

})(Packet);

SEIPD = (function(superClass) {
  extend(SEIPD, superClass);

  function SEIPD(arg) {
    this.ciphertext = arg.ciphertext;
  }

  SEIPD.parse = function(slice) {
    return (new SEIPD_Parser(slice)).parse();
  };

  SEIPD.prototype.to_enc_data_packet = function() {
    return this;
  };

  SEIPD.prototype.check = function() {};

  SEIPD.prototype.decrypt = function(arg, cb) {
    var __iced_it, __iced_passed_deferral, asp, cipher;
    cipher = arg.cipher, asp = arg.asp;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var eng, err, esc, mdc, plaintext, prefix, pt;
      return function*() {
        var __iced_deferrals, __iced_deferrals1, __iced_deferrals2, ref3;
        eng = new Decryptor({
          cipher: cipher,
          ciphertext: _this.ciphertext,
          asp: asp
        });
        esc = make_esc(cb, "SEIPD::decrypt");
        asp = ASP.make(asp);
        __iced_deferrals = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "SEIPD::decrypt",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/packet/sess.iced"
        });
        eng.check(esc(__iced_deferrals.defer({
          lineno: 63
        })));
        if (__iced_deferrals.await_exit()) {
          yield;
        }
        __iced_deferrals1 = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "SEIPD::decrypt",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/packet/sess.iced"
        });
        eng.dec(esc(__iced_deferrals1.defer({
          assign_fn: (function() {
            return function() {
              return pt = arguments[0];
            };
          })(),
          lineno: 64
        })));
        if (__iced_deferrals1.await_exit()) {
          yield;
        }
        ref3 = MDC.parse(pt), mdc = ref3[0], plaintext = ref3[1];
        prefix = eng.get_prefix();
        __iced_deferrals2 = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "SEIPD::decrypt",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/packet/sess.iced"
        });
        mdc.compute({
          prefix: prefix,
          plaintext: plaintext,
          asp: asp
        }, esc(__iced_deferrals2.defer({
          lineno: 70
        })));
        if (__iced_deferrals2.await_exit()) {
          yield;
        }
        err = mdc.check() ? null : new Error("MDC mismatch");
        return cb(err, plaintext);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  SEIPD.prototype.encrypt = function(arg, cb) {
    var __iced_it, __iced_passed_deferral, asp, cipher, plaintext, prefixrandom;
    cipher = arg.cipher, plaintext = arg.plaintext, prefixrandom = arg.prefixrandom, asp = arg.asp;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var esc, mdc, mdc_buf;
      return function*() {
        var __iced_deferrals, __iced_deferrals1;
        mdc = new MDC({});
        esc = make_esc(cb, "SEIPD::encrypt");
        asp = ASP.make(asp);
        __iced_deferrals = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "SEIPD::encrypt",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/packet/sess.iced"
        });
        mdc.compute({
          plaintext: plaintext,
          prefix: prefixrandom,
          asp: asp
        }, esc(__iced_deferrals.defer({
          assign_fn: (function() {
            return function() {
              return mdc_buf = arguments[0];
            };
          })(),
          lineno: 81
        })));
        if (__iced_deferrals.await_exit()) {
          yield;
        }
        plaintext = Buffer.concat([plaintext, MDC.header, mdc_buf]);
        __iced_deferrals1 = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "SEIPD::encrypt",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/packet/sess.iced"
        });
        encrypt({
          cipher: cipher,
          plaintext: plaintext,
          prefixrandom: prefixrandom
        }, esc(__iced_deferrals1.defer({
          assign_fn: (function(__slot_1) {
            return function() {
              return __slot_1.ciphertext = arguments[0];
            };
          })(_this),
          lineno: 83
        })));
        if (__iced_deferrals1.await_exit()) {
          yield;
        }
        return cb(null);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  SEIPD.prototype.write_unframed = function(cb) {
    var err, ret;
    err = ret = null;
    ret = Buffer.concat([uint_to_buffer(8, C.versions.SEIPD), this.ciphertext]);
    return cb(err, ret);
  };

  SEIPD.prototype.write = function(cb) {
    var __iced_it, __iced_passed_deferral;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var err, ret, unframed;
      return function*() {
        var __iced_deferrals;
        ret = err = null;
        __iced_deferrals = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "SEIPD::write",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/packet/sess.iced"
        });
        _this.write_unframed(__iced_deferrals.defer({
          assign_fn: (function() {
            return function() {
              err = arguments[0];
              return unframed = arguments[1];
            };
          })(),
          lineno: 97
        }));
        if (__iced_deferrals.await_exit()) {
          yield;
        }
        if (err == null) {
          ret = _this.frame_packet(C.packet_tags.SEIPD, unframed);
        }
        return cb(err, ret);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  return SEIPD;

})(Packet);

MDC = (function(superClass) {
  extend(MDC, superClass);

  MDC.header = Buffer.from([0xc0 | C.packet_tags.MDC, SHA1.output_length]);

  MDC.prototype.header = MDC.header;

  function MDC(arg) {
    this.digest = arg.digest;
  }

  MDC.parse = function(buf) {
    return (new MDC_Parser(buf)).parse();
  };

  MDC.prototype.compute = function(arg, cb) {
    var __iced_it, __iced_passed_deferral, asp, plaintext, prefix;
    plaintext = arg.plaintext, prefix = arg.prefix, asp = arg.asp;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var esc, hasher, i, step;
      return function*() {
        var __iced_deferrals, j, ref3, ref4;
        asp = ASP.make(asp);
        hasher = streamers.SHA1();
        hasher.update(Buffer.concat([prefix, prefix.slice(-2)]));
        esc = make_esc(cb, "MDC::compute");
        step = 0x100000;
        for (i = j = 0, ref3 = plaintext.length, ref4 = step; ref4 > 0 ? j < ref3 : j > ref3; i = j += ref4) {
          hasher.update(plaintext.slice(i, i + step));
          __iced_deferrals = new iced.Deferrals(__iced_it, {
            parent: __iced_passed_deferral,
            funcname: "MDC::compute",
            filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/packet/sess.iced"
          });
          asp.progress({
            what: "MDC",
            total: plaintext.length,
            i: i
          }, esc(__iced_deferrals.defer({
            lineno: 122
          })));
          if (__iced_deferrals.await_exit()) {
            yield;
          }
        }
        hasher.update(_this.header);
        _this.computed = hasher();
        return cb(null, _this.computed);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  MDC.prototype.check = function() {
    return bufeq_secure(this.digest, this.computed);
  };

  return MDC;

})(Packet);

MDC_Parser = (function() {
  function MDC_Parser(buf1) {
    this.buf = buf1;
  }

  MDC_Parser.prototype.parse = function() {
    var chunk, digest, hl, len, rem;
    hl = MDC.header.length;
    len = SHA1.output_length + hl;
    rem = this.buf.slice(0, -len);
    chunk = this.buf.slice(-len);
    if (!bufeq_fast(chunk.slice(0, hl), MDC.header)) {
      throw new Error('Missing MDC header');
    }
    digest = chunk.slice(hl);
    return [
      new MDC({
        digest: digest
      }), rem
    ];
  };

  return MDC_Parser;

})();

SEIPD_Parser = (function() {
  function SEIPD_Parser(slice1) {
    this.slice = slice1;
  }

  SEIPD_Parser.prototype.payload_split = function(raw) {};

  SEIPD_Parser.prototype.parse = function() {
    var ciphertext, v;
    if ((v = this.slice.read_uint8()) !== C.versions.SEIPD) {
      throw new Error("Unknown SEIPD version " + v);
    }
    ciphertext = this.slice.consume_rest_to_buffer();
    return new SEIPD({
      ciphertext: ciphertext
    });
  };

  return SEIPD_Parser;

})();

PKESK_Parser = (function() {
  function PKESK_Parser(slice1) {
    this.slice = slice1;
  }

  PKESK_Parser.prototype.parse = function() {
    var crypto_type, ekey, key_id, klass, v;
    if ((v = this.slice.read_uint8()) !== C.versions.PKESK) {
      throw new Error("Unknown PKESK version: " + v);
    }
    key_id = this.slice.read_buffer(8);
    crypto_type = this.slice.read_uint8();
    klass = asymmetric.get_class(crypto_type);
    ekey = klass.parse_output(this.slice.consume_rest_to_buffer());
    return new PKESK({
      crypto_type: crypto_type,
      key_id: key_id,
      ekey: ekey
    });
  };

  return PKESK_Parser;

})();

exports.SEIPD = SEIPD;

exports.PKESK = PKESK;

exports.MDC = MDC;

//# sourceMappingURL=sess.js.map
