// Generated by IcedCoffeeScript 112.8.1
var Base, Collection, Data, SelfSig, SubkeyBinding,
  extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty;

Base = (function() {
  function Base(arg) {
    this.sig = arg.sig, this.key_expiration = arg.key_expiration;
  }

  Base.prototype.typ = function() {
    return "none";
  };

  Base.prototype.get_key_flags = function() {
    return this.sig.get_key_flags();
  };

  Base.prototype.push = function(lookup) {
    return lookup[this.typ()].push(this);
  };

  return Base;

})();

SelfSig = (function(superClass) {
  extend(SelfSig, superClass);

  function SelfSig(arg) {
    var key_expiration, sig, sig_expiration;
    this.userid = arg.userid, this.user_attribute = arg.user_attribute, this.type = arg.type, sig = arg.sig, this.options = arg.options, key_expiration = arg.key_expiration, sig_expiration = arg.sig_expiration;
    SelfSig.__super__.constructor.call(this, {
      sig: sig,
      key_expiration: key_expiration,
      sig_expiration: sig_expiration
    });
  }

  SelfSig.prototype.typ = function() {
    return "self_sig";
  };

  SelfSig.prototype.push = function(lookup) {
    var key, v;
    lookup.self_sig.push(this);
    key = this.userid != null ? this.userid.utf8() || "" : void 0;
    if ((v = lookup.self_sigs_by_uid[key]) == null) {
      v = [];
      lookup.self_sigs_by_uid[key] = v;
    }
    return v.push(this);
  };

  return SelfSig;

})(Base);

SubkeyBinding = (function(superClass) {
  extend(SubkeyBinding, superClass);

  SubkeyBinding.UP = 1;

  SubkeyBinding.DOWN = 2;

  function SubkeyBinding(arg) {
    var key_expiration, sig, sig_expiration;
    this.primary = arg.primary, sig = arg.sig, this.direction = arg.direction, sig_expiration = arg.sig_expiration, key_expiration = arg.key_expiration;
    SubkeyBinding.__super__.constructor.call(this, {
      sig: sig,
      key_expiration: key_expiration,
      sig_expiration: sig_expiration
    });
  }

  SubkeyBinding.prototype.typ = function() {
    return "subkey_binding";
  };

  SubkeyBinding.prototype.is_down = function() {
    return this.direction === SubkeyBinding.DOWN;
  };

  return SubkeyBinding;

})(Base);

Data = (function(superClass) {
  extend(Data, superClass);

  function Data(arg) {
    var key_expiration, sig, sig_expiration;
    this.key = arg.key, sig = arg.sig, key_expiration = arg.key_expiration, sig_expiration = arg.sig_expiration;
    Data.__super__.constructor.call(this, {
      sig: sig,
      key_expiration: key_expiration,
      sig_expiration: sig_expiration
    });
  }

  Data.prototype.typ = function() {
    return "data";
  };

  Data.prototype.get_key_manager = function() {
    var ref;
    return (ref = this.sig) != null ? ref.key_manager : void 0;
  };

  return Data;

})(Base);

Collection = (function() {
  function Collection() {
    this.clear();
  }

  Collection.prototype.clear = function() {
    this.all = [];
    return this.lookup = {
      self_sig: [],
      self_sigs_by_uid: {},
      subkey_binding: [],
      data: []
    };
  };

  Collection.prototype.push = function(ps) {
    this.all.push(ps);
    return ps.push(this.lookup);
  };

  Collection.prototype.is_signed_subkey_of = function(primary, need_upwards_sig) {
    var down, i, len, ref, skb, up;
    up = down = false;
    ref = this.lookup.subkey_binding;
    for (i = 0, len = ref.length; i < len; i++) {
      skb = ref[i];
      if (skb.primary.equal(primary)) {
        if (skb.is_down()) {
          down = true;
        } else {
          up = true;
        }
        if (down && (up || !need_upwards_sig)) {
          return true;
        }
      }
    }
    return false;
  };

  Collection.prototype.get_all_key_flags = function() {
    var i, len, p, ref, ret;
    ret = 0;
    ref = this.all;
    for (i = 0, len = ref.length; i < len; i++) {
      p = ref[i];
      ret |= p.get_key_flags();
    }
    return ret;
  };

  Collection.prototype.get_signed_userids = function() {
    var i, len, p, ref, results, u;
    ref = this.lookup.self_sig;
    results = [];
    for (i = 0, len = ref.length; i < len; i++) {
      p = ref[i];
      if ((u = p.userid) != null) {
        results.push(u);
      }
    }
    return results;
  };

  Collection.prototype.get_signed_user_attributes = function() {
    var i, len, p, ref, results, u;
    ref = this.lookup.self_sig;
    results = [];
    for (i = 0, len = ref.length; i < len; i++) {
      p = ref[i];
      if ((u = p.user_attribute) != null) {
        results.push(u);
      }
    }
    return results;
  };

  Collection.prototype.get_self_sig = function() {
    if (this.lookup.self_sig.length) {
      return this.lookup.self_sig[0];
    } else {
      return null;
    }
  };

  Collection.prototype.get_self_sigs = function() {
    return this.lookup.self_sig;
  };

  Collection.prototype.is_self_signed = function() {
    return this.get_signed_userids().length > 0;
  };

  Collection.prototype.get_data_signer = function() {
    if (this.lookup.data.length > 0) {
      return this.lookup.data[0];
    } else {
      return null;
    }
  };

  Collection.prototype.get_data_signers = function() {
    return this.lookup.data;
  };

  Collection.prototype.get_subkey_binding = function() {
    if (this.lookup.subkey_binding.length) {
      return this.lookup.subkey_binding[0];
    } else {
      return null;
    }
  };

  return Collection;

})();

exports.SelfSig = SelfSig;

exports.SubkeyBinding = SubkeyBinding;

exports.Data = Data;

exports.Collection = Collection;

//# sourceMappingURL=packetsigs.js.map
