// Generated by IcedCoffeeScript 112.8.1
var C, Packet, packetsigs, util;

util = require('../util');

C = require('../../const').openpgp;

packetsigs = require('./packetsigs');

Packet = (function() {
  function Packet() {
    this._psc = new packetsigs.Collection();
  }

  Packet.prototype.frame_packet = function(tag, body) {
    var bufs;
    bufs = [Buffer.from([0xc0 | tag]), util.encode_length(body.length), body];
    return Buffer.concat(bufs);
  };

  Packet.prototype.set = function(d) {
    var k, results, v;
    results = [];
    for (k in d) {
      v = d[k];
      results.push(this[k] = v);
    }
    return results;
  };

  Packet.prototype.is_signature = function() {
    return false;
  };

  Packet.prototype.is_key_material = function() {
    return false;
  };

  Packet.prototype.is_duplicate_primary = function() {
    return false;
  };

  Packet.prototype.to_userid = function() {
    return null;
  };

  Packet.prototype.to_user_attribute = function() {
    return null;
  };

  Packet.prototype.to_literal = function() {
    return null;
  };

  Packet.prototype.to_esk_packet = function() {
    return null;
  };

  Packet.prototype.to_enc_data_packet = function() {
    return null;
  };

  Packet.prototype.replay = function() {
    return this.frame_packet(this.tag, this.raw);
  };

  Packet.prototype.inflate = function(cb) {
    return cb(null, null);
  };

  Packet.prototype.push_sig = function(packetsig) {
    return this._psc.push(packetsig);
  };

  Packet.prototype.get_psc = function() {
    return this._psc;
  };

  Packet.prototype.clear_psc = function() {
    return this._psc.clear();
  };

  Packet.prototype.get_data_signer = function() {
    return this.get_psc().get_data_signer();
  };

  Packet.prototype.get_data_signers = function() {
    return this.get_psc().get_data_signers();
  };

  Packet.prototype.get_signed_userids = function() {
    return [];
  };

  Packet.prototype.get_subkey_binding = function() {
    return null;
  };

  Packet.prototype.is_self_signed = function() {
    return false;
  };

  return Packet;

})();

exports.Packet = Packet;

//# sourceMappingURL=base.js.map
