// Generated by IcedCoffeeScript 112.8.1
var ASP, C, ECDSA, Encryptor, Engine, K, KeyBlock, KeyFetched, KeyFetcher, KeyManager, KeyManagerInterface, Lifespan, Message, P3SKB, PgpEngine, Primary, RSA, SHA256, SignatureEngine, Subkey, assert_no_nulls, athrow, bufeq_secure, bufferify, decode, decode_strict, encode, errors, format_pgp_fingerprint_2, iced, katch, konst, lifespan_from_keywrapper_and_time, make_esc, opkts, ops_to_keyflags, parse, read_base64, ref, ref1, ref2, ref3, ref4, unix_time, unseal,
  extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty,
  slice = [].slice;

iced = require('iced-runtime-3');

RSA = require('../rsa').RSA;

ECDSA = require('../ecc/ecdsa').ECDSA;

SHA256 = require('../hash').SHA256;

konst = require('../const');

K = konst.kb;

C = konst.openpgp;

make_esc = require('iced-error').make_esc;

errors = require('../errors').errors;

ref = require('../util'), format_pgp_fingerprint_2 = ref.format_pgp_fingerprint_2, athrow = ref.athrow, assert_no_nulls = ref.assert_no_nulls, ASP = ref.ASP, katch = ref.katch, bufeq_secure = ref.bufeq_secure, unix_time = ref.unix_time, bufferify = ref.bufferify;

ops_to_keyflags = require('./util').ops_to_keyflags;

ref1 = require('../keywrapper'), Lifespan = ref1.Lifespan, Subkey = ref1.Subkey, Primary = ref1.Primary;

ref2 = require('./armor'), Message = ref2.Message, encode = ref2.encode, decode = ref2.decode, decode_strict = ref2.decode_strict;

parse = require('./parser').parse;

KeyBlock = require('./processor').KeyBlock;

opkts = require('./packet/all');

ref3 = require('../keybase/encode'), read_base64 = ref3.read_base64, unseal = ref3.unseal;

P3SKB = require('../keybase/packet/p3skb').P3SKB;

ref4 = require('../keyfetch'), KeyFetcher = ref4.KeyFetcher, KeyFetched = ref4.KeyFetched;

SignatureEngine = require('./sigeng').SignatureEngine;

Encryptor = require('triplesec').Encryptor;

KeyManagerInterface = require('../kmi').KeyManagerInterface;

Engine = (function() {
  function Engine(arg) {
    var j, k, len, ref5;
    this.primary = arg.primary, this.subkeys = arg.subkeys, this.userids = arg.userids, this.key_manager = arg.key_manager;
    this.packets = [];
    this.messages = [];
    this._allocate_key_packets();
    ref5 = this.subkeys;
    for (j = 0, len = ref5.length; j < len; j++) {
      k = ref5[j];
      k.primary = this.primary;
    }
    this._index_keys();
    true;
  }

  Engine.prototype._index_keys = function() {
    var j, k, len, ref5, results;
    this._index = {};
    ref5 = this._all_keys();
    results = [];
    for (j = 0, len = ref5.length; j < len; j++) {
      k = ref5[j];
      results.push(this._index[this.ekid(k)] = k);
    }
    return results;
  };

  Engine.prototype.ekid = function(k) {
    return this.key(k).ekid();
  };

  Engine.prototype._allocate_key_packets = function() {
    var j, key, len, ref5, results;
    this._v_allocate_key_packet(this.primary, {
      subkey: false
    });
    ref5 = this.subkeys;
    results = [];
    for (j = 0, len = ref5.length; j < len; j++) {
      key = ref5[j];
      results.push(this._v_allocate_key_packet(key, {
        subkey: true
      }));
    }
    return results;
  };

  Engine.prototype._all_keys = function() {
    return [this.primary].concat(this.subkeys);
  };

  Engine.prototype.self_sign_primary = function(args, cb) {
    return this._v_self_sign_primary(args, cb);
  };

  Engine.prototype.get_all_key_materials = function() {
    var k;
    return [[this.key(this.primary), true]].concat((function() {
      var j, len, ref5, results;
      ref5 = this.subkeys;
      results = [];
      for (j = 0, len = ref5.length; j < len; j++) {
        k = ref5[j];
        results.push([this.key(k), false]);
      }
      return results;
    }).call(this));
  };

  Engine.prototype.sign_subkeys = function(arg, cb) {
    var __iced_it, __iced_passed_deferral, asp, time;
    time = arg.time, asp = arg.asp;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var err, subkey;
      return function*() {
        var __iced_deferrals, j, len, ref5;
        err = null;
        ref5 = _this.subkeys;
        for (j = 0, len = ref5.length; j < len; j++) {
          subkey = ref5[j];
          if (err == null) {
            __iced_deferrals = new iced.Deferrals(__iced_it, {
              parent: __iced_passed_deferral,
              funcname: "Engine::sign_subkeys",
              filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/keymanager.iced"
            });
            _this._v_sign_subkey({
              asp: asp,
              time: time,
              subkey: subkey
            }, __iced_deferrals.defer({
              assign_fn: (function() {
                return function() {
                  return err = arguments[0];
                };
              })(),
              lineno: 76
            }));
            if (__iced_deferrals.await_exit()) {
              yield;
            }
          }
        }
        return cb(err);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  Engine.prototype.get_subkey_materials = function() {
    var j, k, len, ref5, results;
    ref5 = this.subkeys;
    results = [];
    for (j = 0, len = ref5.length; j < len; j++) {
      k = ref5[j];
      results.push(this.key(k));
    }
    return results;
  };

  Engine.prototype.is_locked = function() {
    var i, j, k, len, ref5;
    ref5 = this._all_keys();
    for (i = j = 0, len = ref5.length; j < len; i = ++j) {
      k = ref5[i];
      if (this.key(k).is_locked()) {
        return true;
      }
    }
    return false;
  };

  Engine.prototype.has_private = function() {
    var j, k, len, ref5;
    ref5 = this._all_keys();
    for (j = 0, len = ref5.length; j < len; j++) {
      k = ref5[j];
      if (this.key(k).has_private()) {
        return true;
      }
    }
    return false;
  };

  Engine.prototype.sign = function(arg, cb) {
    var __iced_it, __iced_passed_deferral, asp, time;
    asp = arg.asp, time = arg.time;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var err;
      return function*() {
        var __iced_deferrals, __iced_deferrals1;
        __iced_deferrals = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "Engine::sign",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/keymanager.iced"
        });
        _this.self_sign_primary({
          asp: asp,
          time: time
        }, __iced_deferrals.defer({
          assign_fn: (function() {
            return function() {
              return err = arguments[0];
            };
          })(),
          lineno: 100
        }));
        if (__iced_deferrals.await_exit()) {
          yield;
        }
        __iced_deferrals1 = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "Engine::sign",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/keymanager.iced"
        });
        if (err == null) {
          _this.sign_subkeys({
            asp: asp,
            time: time
          }, __iced_deferrals1.defer({
            assign_fn: (function() {
              return function() {
                return err = arguments[0];
              };
            })(),
            lineno: 101
          }));
        }
        if (__iced_deferrals1.await_exit()) {
          yield;
        }
        return cb(err);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  Engine.prototype.check_eq = function(eng2) {
    var err, i, j, key, len, ref5;
    err = null;
    if (!this.primary.key.eq(eng2.primary.key)) {
      err = new Error("Primary keys don't match");
    } else if (this.subkeys.length !== eng2.subkeys.length) {
      err = new Error("different # of subkeys");
    } else {
      ref5 = this.subkeys;
      for (i = j = 0, len = ref5.length; j < len; i = ++j) {
        key = ref5[i];
        if (this.err == null) {
          if (!key.key.eq(eng2.subkeys[i].key)) {
            err = new Error("subkey " + i + " doesn't match");
          }
        }
      }
    }
    return err;
  };

  Engine.prototype.merge_private = function(eng2) {
    var err, i, j, k, len, ref5;
    err = this._merge_private_primary(eng2);
    if (err == null) {
      ref5 = eng2.subkeys;
      for (i = j = 0, len = ref5.length; j < len; i = ++j) {
        k = ref5[i];
        if ((err = this._merge_private_subkey(k, i)) != null) {
          break;
        }
      }
    }
    return err;
  };

  Engine.prototype._merge_private_primary = function(eng2) {
    var err;
    err = !this.key(eng2.primary).has_secret_key_material() ? null : this._merge_1_private(this.primary, eng2.primary) ? null : new Error("primary public key doesn't match private key");
    return err;
  };

  Engine.prototype._merge_private_subkey = function(k2, i) {
    var ekid, err, k;
    err = !this.key(k2).has_secret_key_material() ? null : (ekid = this.ekid(k2)) == null ? new Error("Subkey " + i + " is malformed") : (k = this._index[ekid]) == null ? new Error("Subkey " + i + " wasn't found in public key") : this._merge_1_private(k, k2) ? null : new Error("subkey " + i + " can't be merged");
    return err;
  };

  Engine.prototype.unlock_keys = function(arg, cb) {
    var __iced_it, __iced_passed_deferral, asp, passphrase, tsenc;
    asp = arg.asp, passphrase = arg.passphrase, tsenc = arg.tsenc;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var esc, i, subkey;
      return function*() {
        var __iced_deferrals, __iced_deferrals1, j, len, ref5;
        esc = make_esc(cb, "Engine::unlock_keys");
        __iced_deferrals = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "Engine::unlock_keys",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/keymanager.iced"
        });
        _this.key(_this.primary).unlock({
          asp: asp,
          tsenc: tsenc,
          passphrase: passphrase
        }, esc(__iced_deferrals.defer({
          lineno: 149
        })));
        if (__iced_deferrals.await_exit()) {
          yield;
        }
        ref5 = _this.subkeys;
        for (i = j = 0, len = ref5.length; j < len; i = ++j) {
          subkey = ref5[i];
          if (_this.key(subkey).has_private()) {
            __iced_deferrals1 = new iced.Deferrals(__iced_it, {
              parent: __iced_passed_deferral,
              funcname: "Engine::unlock_keys",
              filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/keymanager.iced"
            });
            _this.key(subkey).unlock({
              asp: asp,
              tsenc: tsenc,
              passphrase: passphrase
            }, esc(__iced_deferrals1.defer({
              lineno: 151
            })));
            if (__iced_deferrals1.await_exit()) {
              yield;
            }
          }
        }
        return cb(null);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  Engine.prototype.export_keys_to_keyring = function(km) {
    var k, x;
    x = (function(_this) {
      return function(key_wrapper, is_primary) {
        return {
          km: km,
          is_primary: is_primary,
          key_wrapper: key_wrapper,
          key_material: _this.key(key_wrapper),
          key: _this.key(key_wrapper).key
        };
      };
    })(this);
    return [x(this.primary, true)].concat((function() {
      var j, len, ref5, results;
      ref5 = this.subkeys;
      results = [];
      for (j = 0, len = ref5.length; j < len; j++) {
        k = ref5[j];
        results.push(x(k, false));
      }
      return results;
    }).call(this));
  };

  Engine.prototype._merge_1_private = function(k1, k2) {
    if (bufeq_secure(this.ekid(k1), this.ekid(k2))) {
      this.key(k1).merge_private(this.key(k2));
      return true;
    } else {
      return false;
    }
  };

  Engine.prototype.merge_subkey_omitting_revokes = function(k) {
    var ekid, kw;
    ekid = k.ekid();
    if ((kw = this._index[ekid]) != null) {
      return kw.overwrite_with_omitting_revokes(k);
    } else {
      this._index[ekid] = k;
      return this.subkeys.push(k);
    }
  };

  Engine.prototype.merge_public_omitting_revokes = function(pgpeng2) {
    this.primary.overwrite_with_omitting_revokes(pgpeng2.primary);
    return this.merge_all_subkeys_omitting_revokes(pgpeng2);
  };

  Engine.prototype.merge_all_subkeys_omitting_revokes = function(pgpeng2) {
    var j, len, ref5, results, subkey;
    ref5 = pgpeng2.subkeys;
    results = [];
    for (j = 0, len = ref5.length; j < len; j++) {
      subkey = ref5[j];
      results.push(this.merge_subkey_omitting_revokes(subkey));
    }
    return results;
  };

  Engine.prototype.check_not_expired = function(arg) {
    var err, now, subkey_material;
    subkey_material = arg.subkey_material, now = arg.now;
    now || (now = unix_time());
    err = this.key(this.primary).check_not_expired({
      now: now
    });
    if (err == null) {
      err = subkey_material.check_not_expired({
        now: now
      });
    }
    return err;
  };

  return Engine;

})();

lifespan_from_keywrapper_and_time = function(arg) {
  var key_wrapper, ret, time;
  key_wrapper = arg.key_wrapper, time = arg.time;
  ret = key_wrapper.lifespan;
  if (time != null) {
    ret = ret.copy();
    ret.generated = time;
  }
  return ret;
};

PgpEngine = (function(superClass) {
  extend(PgpEngine, superClass);

  function PgpEngine(arg) {
    var key_manager, primary, subkeys, userids;
    primary = arg.primary, subkeys = arg.subkeys, userids = arg.userids, this.user_attributes = arg.user_attributes, key_manager = arg.key_manager;
    PgpEngine.__super__.constructor.call(this, {
      primary: primary,
      subkeys: subkeys,
      userids: userids,
      key_manager: key_manager
    });
  }

  PgpEngine.prototype.key = function(k) {
    return k._pgp;
  };

  PgpEngine.prototype._v_allocate_key_packet = function(key, opts) {
    if (key._pgp == null) {
      return key._pgp = new opkts.KeyMaterial({
        key: key.key,
        timestamp: key.lifespan.generated,
        flags: key.flags,
        opts: opts
      });
    }
  };

  PgpEngine.prototype._v_self_sign_primary = function(arg, cb) {
    var __iced_it, __iced_passed_deferral, asp, raw_payload, time;
    time = arg.time, asp = arg.asp, raw_payload = arg.raw_payload;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var err, lifespan, sigs;
      return function*() {
        var __iced_deferrals;
        lifespan = lifespan_from_keywrapper_and_time({
          key_wrapper: _this.primary,
          time: time
        });
        __iced_deferrals = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "PgpEngine::_v_self_sign_primary",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/keymanager.iced"
        });
        _this.key(_this.primary).self_sign_key({
          lifespan: lifespan,
          userids: _this.userids,
          raw_payload: raw_payload
        }, __iced_deferrals.defer({
          assign_fn: (function() {
            return function() {
              err = arguments[0];
              return sigs = arguments[1];
            };
          })(),
          lineno: 241
        }));
        if (__iced_deferrals.await_exit()) {
          yield;
        }
        return cb(err, sigs);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  PgpEngine.prototype._v_sign_subkey = function(arg, cb) {
    var __iced_it, __iced_passed_deferral, asp, subkey, time;
    asp = arg.asp, subkey = arg.subkey, time = arg.time;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var err, lifespan;
      return function*() {
        var __iced_deferrals;
        lifespan = lifespan_from_keywrapper_and_time({
          key_wrapper: subkey,
          time: time
        });
        __iced_deferrals = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "PgpEngine::_v_sign_subkey",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/keymanager.iced"
        });
        _this.key(_this.primary).sign_subkey({
          subkey: _this.key(subkey),
          lifespan: lifespan
        }, __iced_deferrals.defer({
          assign_fn: (function() {
            return function() {
              return err = arguments[0];
            };
          })(),
          lineno: 248
        }));
        if (__iced_deferrals.await_exit()) {
          yield;
        }
        return cb(err);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  PgpEngine.prototype.clear_psc = function() {
    var j, l, len, len1, ref5, ref6, results, s, u;
    this.key(this.primary).clear_psc();
    ref5 = this.userids;
    for (j = 0, len = ref5.length; j < len; j++) {
      u = ref5[j];
      u.clear_psc();
    }
    ref6 = this.subkeys;
    results = [];
    for (l = 0, len1 = ref6.length; l < len1; l++) {
      s = ref6[l];
      results.push(this.key(s).clear_psc());
    }
    return results;
  };

  PgpEngine.prototype.set_passphrase = function(pp) {
    var j, k, len, ref5, results;
    this.primary.passphrase = pp;
    ref5 = this.subkeys;
    results = [];
    for (j = 0, len = ref5.length; j < len; j++) {
      k = ref5[j];
      results.push(k.passphrase = pp);
    }
    return results;
  };

  PgpEngine.prototype._export_keys_to_binary = function(opts) {
    var j, l, len, len1, packets, ref5, ref6, subkey, userid;
    packets = [this.key(this.primary).export_framed(opts)];
    ref5 = this.userids;
    for (j = 0, len = ref5.length; j < len; j++) {
      userid = ref5[j];
      packets.push(userid.write(), userid.get_framed_signature_output());
    }
    opts.subkey = true;
    ref6 = this.subkeys;
    for (l = 0, len1 = ref6.length; l < len1; l++) {
      subkey = ref6[l];
      packets.push(this.key(subkey).export_framed(opts), this.key(subkey).get_subkey_binding_signature_output());
    }
    assert_no_nulls(packets);
    return Buffer.concat(packets);
  };

  PgpEngine.prototype.export_keys = function(opts) {
    var msg, mt, type;
    mt = C.message_types;
    type = opts["private"] ? mt.private_key : mt.public_key;
    msg = this._export_keys_to_binary(opts);
    return encode(type, msg);
  };

  PgpEngine.prototype.export_to_p3skb = function() {
    var priv_clear, pub;
    pub = this._export_keys_to_binary({
      "private": false
    });
    priv_clear = this._export_keys_to_binary({
      "private": true
    });
    return new P3SKB({
      pub: pub,
      priv_clear: priv_clear
    });
  };

  PgpEngine.prototype.find_key = function(key_id) {
    var j, k, len, ref5;
    ref5 = this._all_keys();
    for (j = 0, len = ref5.length; j < len; j++) {
      k = ref5[j];
      if (bufeq_secure(this.key(k).get_key_id(), key_id)) {
        return k;
      }
    }
    return null;
  };

  PgpEngine.prototype.find_key_material = function(key_id) {
    var key;
    key = this.find_key(key_id);
    if (key != null) {
      return this.key(key);
    } else {
      return null;
    }
  };

  PgpEngine.prototype.get_key_id = function() {
    return this.key(this.primary).get_key_id();
  };

  PgpEngine.prototype.get_short_key_id = function() {
    return this.key(this.primary).get_short_key_id();
  };

  PgpEngine.prototype.get_fingerprint = function() {
    return this.key(this.primary).get_fingerprint();
  };

  PgpEngine.prototype.get_ekid = function() {
    return this.key(this.primary).ekid();
  };

  PgpEngine.prototype.get_all_key_ids = function() {
    var j, k, len, ref5, results;
    ref5 = this._all_keys();
    results = [];
    for (j = 0, len = ref5.length; j < len; j++) {
      k = ref5[j];
      results.push(this.key(k).get_key_id());
    }
    return results;
  };

  PgpEngine.prototype.get_designated_revocations = function() {
    return this.key(this.primary).get_designated_revocations();
  };

  PgpEngine.prototype.validity_check = function(cb) {
    var __iced_it, __iced_passed_deferral;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var err, k;
      return function*() {
        var __iced_deferrals, j, len, ref5;
        err = null;
        ref5 = _this._all_keys();
        for (j = 0, len = ref5.length; j < len; j++) {
          k = ref5[j];
          __iced_deferrals = new iced.Deferrals(__iced_it, {
            parent: __iced_passed_deferral,
            funcname: "PgpEngine::validity_check",
            filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/keymanager.iced"
          });
          _this.key(k).validity_check(__iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                return err = arguments[0];
              };
            })(),
            lineno: 328
          }));
          if (__iced_deferrals.await_exit()) {
            yield;
          }
          if (err != null) {
            break;
          }
        }
        return cb(err);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  PgpEngine.prototype.find_best_key = function(flags, need_priv) {
    var best, check, j, k, len, ref5;
    if (need_priv == null) {
      need_priv = false;
    }
    best = null;
    check = (function(_this) {
      return function(k) {
        var km, ok1, ok2, ok3;
        km = _this.key(k);
        ok1 = km.fulfills_flags(flags) || ((k.flags & flags) === flags);
        ok2 = !need_priv || km.has_private();
        ok3 = !km.is_revoked();
        return ok1 && ok2 && ok3;
      };
    })(this);
    ref5 = this.subkeys;
    for (j = 0, len = ref5.length; j < len; j++) {
      k = ref5[j];
      if (check(k)) {
        if (best == null) {
          best = k;
        } else if (this.key(k).is_preferable_to(this.key(best))) {
          best = k;
        }
      }
    }
    if ((best == null) && check(this.primary)) {
      best = this.primary;
    }
    return (best != null ? this.key(best) : null);
  };

  PgpEngine.prototype.fetch = function(key_ids, op_mask, cb) {
    var err, flags, i, j, key, kid, len, ref5, ref6, ret, ret_i;
    flags = ops_to_keyflags(op_mask);
    err = key = ret = null;
    key = null;
    ret_i = null;
    for (i = j = 0, len = key_ids.length; j < len; i = ++j) {
      kid = key_ids[i];
      if (!(key == null)) {
        continue;
      }
      key = this.find_key(kid);
      if (key != null) {
        ret_i = i;
      }
    }
    if (key == null) {
      err = new Error("No keys match the given key IDs");
    } else if (this.key(key).is_revoked() || this.is_revoked()) {
      err = new errors.RevokedKeyError;
      err.km = this;
    } else if (!this.key(key).fulfills_flags(flags)) {
      err = new Error("We don't have a key for the requested PGP ops (flags = " + flags + ")");
    } else if (!((ref5 = this.key(key)) != null ? (ref6 = ref5.key) != null ? ref6.can_perform(op_mask) : void 0 : void 0)) {
      err = new Error("can't peform the operation -- maybe no secret key material (op_mask=" + op_mask + ")");
    } else {
      ret = this.key(key);
    }
    return cb(err, this.key_manager, ret_i);
  };

  PgpEngine.prototype.is_revoked = function() {
    return this.key(this.primary).is_revoked();
  };

  return PgpEngine;

})(Engine);

KeyManager = (function(superClass) {
  extend(KeyManager, superClass);

  function KeyManager(arg) {
    var signed;
    this.primary = arg.primary, this.subkeys = arg.subkeys, this.userids = arg.userids, this.armored_pgp_public = arg.armored_pgp_public, this.armored_pgp_private = arg.armored_pgp_private, this.user_attributes = arg.user_attributes, signed = arg.signed;
    this.pgp = new PgpEngine({
      primary: this.primary,
      subkeys: this.subkeys,
      userids: this.userids,
      user_attributes: this.user_attributes,
      key_manager: this
    });
    this.engines = [this.pgp];
    this._signed = signed != null ? signed : false;
    this.p3skb = null;
  }

  KeyManager.generate = function(arg, cb) {
    var F, KEY_FLAGS_PRIMARY, KEY_FLAGS_STD, __iced_it, __iced_passed_deferral, asp, bundle, curve_name, ecc, err, esc, expire_in, flags, gen, generated, i, nbits, nsubs, primary, primary_flags, s, sub_flags, subkey, subkeys, subkeys_out, u, userid, userids;
    asp = arg.asp, userid = arg.userid, userids = arg.userids, primary = arg.primary, subkeys = arg.subkeys, ecc = arg.ecc, sub_flags = arg.sub_flags, nsubs = arg.nsubs, primary_flags = arg.primary_flags, nbits = arg.nbits, expire_in = arg.expire_in, generated = arg.generated, curve_name = arg.curve_name;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function*() {
      var __iced_deferrals, __iced_deferrals1, __iced_deferrals2, j, l, len, len1;
      asp = ASP.make(asp);
      F = C.key_flags;
      KEY_FLAGS_STD = F.sign_data | F.encrypt_comm | F.encrypt_storage | F.auth;
      KEY_FLAGS_PRIMARY = KEY_FLAGS_STD | F.certify_keys;
      primary || (primary = {});
      primary.flags || (primary.flags = primary_flags || KEY_FLAGS_PRIMARY);
      primary.expire_in || (primary.expire_in = (expire_in != null ? expire_in.primary : void 0) || K.key_defaults.primary.expire_in);
      primary.algo || (primary.algo = (ecc ? ECDSA : RSA));
      primary.nbits || (primary.nbits = nbits || K.key_defaults.primary.nbits[primary.algo.klass_name]);
      if (curve_name) {
        primary.curve_name = curve_name;
      }
      if ((nsubs != null) && (sub_flags == null)) {
        sub_flags = (function() {
          var j, ref5, results;
          results = [];
          for (i = j = 0, ref5 = nsubs; 0 <= ref5 ? j < ref5 : j > ref5; i = 0 <= ref5 ? ++j : --j) {
            results.push(KEY_FLAGS_STD);
          }
          return results;
        })();
      }
      subkeys || (subkeys = (function() {
        var j, len, results;
        results = [];
        for (j = 0, len = sub_flags.length; j < len; j++) {
          flags = sub_flags[j];
          results.push({
            flags: flags
          });
        }
        return results;
      })());
      for (j = 0, len = subkeys.length; j < len; j++) {
        subkey = subkeys[j];
        subkey.expire_in || (subkey.expire_in = (expire_in != null ? expire_in.subkey : void 0) || K.key_defaults.sub.expire_in);
        subkey.flags || (subkey.flags = KEY_FLAGS_STD);
        subkey.algo || (subkey.algo = primary.algo.subkey_algo(subkey.flags));
        subkey.nbits || (subkey.nbits = nbits || K.key_defaults.sub.nbits[subkey.algo.klass_name]);
      }
      generated || (generated = unix_time());
      esc = make_esc(cb, "KeyManager::generate");
      if (userid != null) {
        userids = [userid];
      }
      if ((userids != null) && Array.isArray(userids)) {
        userids = (function() {
          var l, len1, results;
          results = [];
          for (l = 0, len1 = userids.length; l < len1; l++) {
            u = userids[l];
            results.push(new opkts.UserID(u));
          }
          return results;
        })();
      } else {
        err = new Error("Need either 'userid' or 'userids' specified as an array");
        __iced_deferrals = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "KeyManager::@generate",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/keymanager.iced"
        });
        athrow(err, esc(__iced_deferrals.defer({
          lineno: 474
        })));
        if (__iced_deferrals.await_exit()) {
          yield;
        }
      }
      gen = function(arg1, cb) {
        var __iced_it, __iced_passed_deferral, key, klass, lifespan, my_generated, params, primary, section, wrapper;
        klass = arg1.klass, section = arg1.section, params = arg1.params, primary = arg1.primary;
        __iced_passed_deferral = iced.findDeferral(arguments);
        __iced_it = (function*() {
          var __iced_deferrals1;
          asp.section(section);
          __iced_deferrals1 = new iced.Deferrals(__iced_it, {
            parent: __iced_passed_deferral,
            funcname: "gen",
            filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/keymanager.iced"
          });
          params.algo.generate({
            asp: asp,
            nbits: params.nbits,
            curve_name: params.curve_name
          }, __iced_deferrals1.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                return key = arguments[1];
              };
            })(),
            lineno: 478
          }));
          if (__iced_deferrals1.await_exit()) {
            yield;
          }
          if (err == null) {
            my_generated = params.generated || generated;
            lifespan = new Lifespan({
              generated: my_generated,
              expire_in: params.expire_in
            });
            wrapper = new klass({
              key: key,
              lifespan: lifespan,
              flags: params.flags,
              primary: primary
            });
          }
          return cb(err, wrapper);
        })();
        __iced_it.next();
        return null;
      };
      __iced_deferrals1 = new iced.Deferrals(__iced_it, {
        parent: __iced_passed_deferral,
        funcname: "KeyManager::@generate",
        filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/keymanager.iced"
      });
      gen({
        klass: Primary,
        section: "primary",
        params: primary
      }, esc(__iced_deferrals1.defer({
        assign_fn: (function() {
          return function() {
            return primary = arguments[0];
          };
        })(),
        lineno: 485
      })));
      if (__iced_deferrals1.await_exit()) {
        yield;
      }
      subkeys_out = [];
      for (i = l = 0, len1 = subkeys.length; l < len1; i = ++l) {
        subkey = subkeys[i];
        __iced_deferrals2 = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "KeyManager::@generate",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/keymanager.iced"
        });
        gen({
          klass: Subkey,
          section: "subkey " + (i + 1),
          params: subkey,
          primary: primary
        }, esc(__iced_deferrals2.defer({
          assign_fn: (function() {
            return function() {
              return s = arguments[0];
            };
          })(),
          lineno: 488
        })));
        if (__iced_deferrals2.await_exit()) {
          yield;
        }
        subkeys_out.push(s);
      }
      bundle = new KeyManager({
        primary: primary,
        subkeys: subkeys_out,
        userids: userids
      });
      return cb(null, bundle);
    })();
    __iced_it.next();
    return null;
  };

  KeyManager.generate_rsa = function(arg, cb) {
    var F, asp, primary, subkeys, userid, userids;
    asp = arg.asp, userid = arg.userid, userids = arg.userids;
    F = C.key_flags;
    primary = {
      flags: F.certify_keys,
      nbits: 4096
    };
    subkeys = [
      {
        flags: F.encrypt_storage | F.encrypt_comm,
        nbits: 2048
      }, {
        flags: F.sign_data | F.auth,
        nbits: 2048
      }
    ];
    return KeyManager.generate({
      asp: asp,
      userid: userid,
      userids: userids,
      primary: primary,
      subkeys: subkeys
    }, cb);
  };

  KeyManager.generate_ecc = function(arg, cb) {
    var F, asp, generated, primary, subkeys, userid, userids;
    asp = arg.asp, userid = arg.userid, userids = arg.userids, generated = arg.generated;
    F = C.key_flags;
    primary = {
      flags: F.certify_keys,
      nbits: 384,
      algo: ECDSA
    };
    subkeys = [
      {
        flags: F.encrypt_storage | F.encrypt_comm,
        nbits: 256
      }, {
        flags: F.sign_data | F.auth,
        nbits: 256
      }
    ];
    return KeyManager.generate({
      asp: asp,
      userid: userid,
      userids: userids,
      primary: primary,
      subkeys: subkeys,
      generated: generated
    }, cb);
  };

  KeyManager.prototype.set_enc = function(e) {
    return this.tsenc = e;
  };

  KeyManager.import_from_armored_pgp = function(arg, cb) {
    var __iced_it, __iced_passed_deferral, armored, asp, binary, decode_func, err, msg, opts, packets, raw, ret, warnings;
    armored = arg.armored, raw = arg.raw, binary = arg.binary, asp = arg.asp, opts = arg.opts;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function*() {
      var __iced_deferrals, __iced_deferrals1, ref5, ref6;
      msg = binary;
      err = null;
      if (msg == null) {
        raw || (raw = armored);
        asp = ASP.make(asp);
        warnings = null;
        ret = null;
        decode_func = (opts != null ? opts.decode_strict : void 0) ? decode_strict : decode;
        ref5 = decode_func(raw), err = ref5[0], msg = ref5[1];
        if (err == null) {
          if (!((ref6 = msg.type) === C.message_types.public_key || ref6 === C.message_types.private_key)) {
            err = new Error("Wanted a public or private key; got: " + msg.type);
          }
        }
      }
      if (err == null) {
        __iced_deferrals = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "KeyManager::@import_from_armored_pgp",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/keymanager.iced"
        });
        KeyManager.import_from_pgp_message({
          msg: msg,
          asp: asp,
          opts: opts
        }, __iced_deferrals.defer({
          assign_fn: (function() {
            return function() {
              err = arguments[0];
              ret = arguments[1];
              warnings = arguments[2];
              return packets = arguments[3];
            };
          })(),
          lineno: 567
        }));
        if (__iced_deferrals.await_exit()) {
          yield;
        }
      }
      if (!(err != null)) {
        __iced_deferrals1 = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "KeyManager::@import_from_armored_pgp",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/keymanager.iced"
        });
        ret.simple_unlock({}, __iced_deferrals1.defer({
          assign_fn: (function() {
            return function() {
              return err = arguments[0];
            };
          })(),
          lineno: 573
        }));
        if (__iced_deferrals1.await_exit()) {
          yield;
        }
      }
      return cb(err, ret, warnings, packets);
    })();
    __iced_it.next();
    return null;
  };

  KeyManager.prototype.simple_unlock = function(opts, cb) {
    var __iced_it, __iced_passed_deferral;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var err;
      return function*() {
        var __iced_deferrals;
        err = null;
        if (_this.has_pgp_private() && !_this.is_pgp_locked()) {
          __iced_deferrals = new iced.Deferrals(__iced_it, {
            parent: __iced_passed_deferral,
            funcname: "KeyManager::simple_unlock",
            filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/keymanager.iced"
          });
          _this.unlock_pgp({}, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                return err = arguments[0];
              };
            })(),
            lineno: 585
          }));
          if (__iced_deferrals.await_exit()) {
            yield;
          }
        }
        return cb(err);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  KeyManager.import_from_p3skb = function(arg, cb) {
    var __iced_it, __iced_passed_deferral, armored, asp, err, km, msg, no_check_keys, now, opts, p3skb, raw, time_travel, warnings;
    raw = arg.raw, armored = arg.armored, asp = arg.asp, no_check_keys = arg.no_check_keys, time_travel = arg.time_travel, now = arg.now;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function*() {
      var __iced_deferrals, ref5;
      armored || (armored = raw);
      asp = ASP.make(asp);
      km = null;
      warnings = null;
      ref5 = katch(function() {
        return P3SKB.alloc(unseal(read_base64(armored)));
      }), err = ref5[0], p3skb = ref5[1];
      if (err == null) {
        msg = new Message({
          body: p3skb.pub,
          type: C.message_types.public_key
        });
        opts = {
          no_check_keys: no_check_keys,
          time_travel: time_travel,
          now: now
        };
        __iced_deferrals = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "KeyManager::@import_from_p3skb",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/keymanager.iced"
        });
        KeyManager.import_from_pgp_message({
          msg: msg,
          asp: asp,
          opts: opts
        }, __iced_deferrals.defer({
          assign_fn: (function() {
            return function() {
              err = arguments[0];
              km = arguments[1];
              return warnings = arguments[2];
            };
          })(),
          lineno: 601
        }));
        if (__iced_deferrals.await_exit()) {
          yield;
        }
        if (km != null) {
          km.p3skb = p3skb;
        }
      }
      return cb(err, km, warnings);
    })();
    __iced_it.next();
    return null;
  };

  KeyManager.prototype.unlock_p3skb = function(arg, cb) {
    var __iced_it, __iced_passed_deferral, asp, no_check_keys, now, passphrase, passphrase_generation, time_travel, tsenc;
    asp = arg.asp, tsenc = arg.tsenc, passphrase = arg.passphrase, passphrase_generation = arg.passphrase_generation, no_check_keys = arg.no_check_keys, time_travel = arg.time_travel, now = arg.now;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var err, km, msg, opts;
      return function*() {
        var __iced_deferrals, __iced_deferrals1, __iced_deferrals2;
        asp = ASP.make(asp);
        if ((tsenc == null) && (passphrase != null)) {
          tsenc = new Encryptor({
            key: bufferify(passphrase)
          });
        }
        __iced_deferrals = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "KeyManager::unlock_p3skb",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/keymanager.iced"
        });
        _this.p3skb.unlock({
          tsenc: tsenc,
          asp: asp,
          passphrase_generation: passphrase_generation
        }, __iced_deferrals.defer({
          assign_fn: (function() {
            return function() {
              return err = arguments[0];
            };
          })(),
          lineno: 611
        }));
        if (__iced_deferrals.await_exit()) {
          yield;
        }
        if (err == null) {
          msg = new Message({
            body: _this.p3skb.priv.data,
            type: C.message_types.private_key
          });
          opts = {
            no_check_keys: no_check_keys,
            time_travel: time_travel,
            now: now
          };
          __iced_deferrals1 = new iced.Deferrals(__iced_it, {
            parent: __iced_passed_deferral,
            funcname: "KeyManager::unlock_p3skb",
            filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/keymanager.iced"
          });
          KeyManager.import_from_pgp_message({
            msg: msg,
            asp: asp,
            opts: opts
          }, __iced_deferrals1.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                return km = arguments[1];
              };
            })(),
            lineno: 615
          }));
          if (__iced_deferrals1.await_exit()) {
            yield;
          }
        }
        if (err == null) {
          err = _this.pgp.merge_private(km.pgp);
        }
        if (err == null) {
          passphrase = Buffer.from([]);
          __iced_deferrals2 = new iced.Deferrals(__iced_it, {
            parent: __iced_passed_deferral,
            funcname: "KeyManager::unlock_p3skb",
            filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/keymanager.iced"
          });
          _this.unlock_pgp({
            passphrase: passphrase
          }, __iced_deferrals2.defer({
            assign_fn: (function() {
              return function() {
                return err = arguments[0];
              };
            })(),
            lineno: 624
          }));
          if (__iced_deferrals2.await_exit()) {
            yield;
          }
        }
        return cb(err);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  KeyManager.import_from_pgp_message = function(arg, cb) {
    var __iced_it, __iced_passed_deferral, asp, bundle, err, k, kb, msg, opts, packets, warnings;
    msg = arg.msg, asp = arg.asp, opts = arg.opts;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function*() {
      var __iced_deferrals, __iced_deferrals1, ref5;
      asp = ASP.make(asp);
      bundle = null;
      warnings = null;
      if (typeof err === "undefined" || err === null) {
        ref5 = parse(msg.body), err = ref5[0], packets = ref5[1];
      }
      if (err == null) {
        kb = new KeyBlock(packets, opts);
        __iced_deferrals = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "KeyManager::@import_from_pgp_message",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/keymanager.iced"
        });
        kb.process(__iced_deferrals.defer({
          assign_fn: (function() {
            return function() {
              return err = arguments[0];
            };
          })(),
          lineno: 639
        }));
        if (__iced_deferrals.await_exit()) {
          yield;
        }
        warnings = kb.warnings;
      }
      if (err == null) {
        bundle = new KeyManager({
          primary: KeyManager._wrap_pgp(Primary, kb.primary),
          subkeys: (function() {
            var j, len, ref6, results;
            ref6 = kb.subkeys;
            results = [];
            for (j = 0, len = ref6.length; j < len; j++) {
              k = ref6[j];
              results.push(KeyManager._wrap_pgp(Subkey, k));
            }
            return results;
          })(),
          user_attributes: kb.user_attributes,
          userids: kb.userids,
          signed: true
        });
        if (bundle.has_pgp_private()) {
          bundle.armored_pgp_private = msg.raw();
        } else {
          bundle.armored_pgp_public = msg.raw();
        }
      }
      if (err == null) {
        __iced_deferrals1 = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "KeyManager::@import_from_pgp_message",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/keymanager.iced"
        });
        bundle.check_pgp_validity(__iced_deferrals1.defer({
          assign_fn: (function() {
            return function() {
              return err = arguments[0];
            };
          })(),
          lineno: 657
        }));
        if (__iced_deferrals1.await_exit()) {
          yield;
        }
      }
      return cb(err, bundle, warnings, packets);
    })();
    __iced_it.next();
    return null;
  };

  KeyManager.prototype.merge_pgp_private = function(arg, cb) {
    var __iced_it, __iced_passed_deferral, armored, asp, import_opts, raw;
    armored = arg.armored, raw = arg.raw, asp = arg.asp, import_opts = arg.import_opts;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var b2, err, esc;
      return function*() {
        var __iced_deferrals, __iced_deferrals1;
        asp = ASP.make(asp);
        esc = make_esc(cb, "merge_pgp_private");
        __iced_deferrals = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "KeyManager::merge_pgp_private",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/keymanager.iced"
        });
        KeyManager.import_from_armored_pgp({
          armored: armored,
          raw: raw,
          asp: asp,
          opts: import_opts
        }, esc(__iced_deferrals.defer({
          assign_fn: (function() {
            return function() {
              return b2 = arguments[0];
            };
          })(),
          lineno: 668
        })));
        if (__iced_deferrals.await_exit()) {
          yield;
        }
        err = _this.pgp.merge_private(b2.pgp);
        if (err != null) {

        } else if (!_this.has_pgp_private()) {
          err = new Error("no private key material found after merge");
        } else {
          __iced_deferrals1 = new iced.Deferrals(__iced_it, {
            parent: __iced_passed_deferral,
            funcname: "KeyManager::merge_pgp_private",
            filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/keymanager.iced"
          });
          _this.simple_unlock({}, esc(__iced_deferrals1.defer({
            lineno: 675
          })));
          if (__iced_deferrals1.await_exit()) {
            yield;
          }
        }
        return cb(err);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  KeyManager.prototype.check_pgp_public_eq = function(km2) {
    return this.pgp.check_eq(km2.pgp);
  };

  KeyManager.prototype.unlock_pgp = function(arg, cb) {
    var __iced_it, __iced_passed_deferral, passphrase;
    passphrase = arg.passphrase;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var err;
      return function*() {
        var __iced_deferrals;
        __iced_deferrals = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "KeyManager::unlock_pgp",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/keymanager.iced"
        });
        _this.pgp.unlock_keys({
          passphrase: passphrase
        }, __iced_deferrals.defer({
          assign_fn: (function() {
            return function() {
              return err = arguments[0];
            };
          })(),
          lineno: 688
        }));
        if (__iced_deferrals.await_exit()) {
          yield;
        }
        return cb(err);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  KeyManager.prototype.is_pgp_locked = function() {
    return this.pgp.is_locked();
  };

  KeyManager.prototype.is_keybase_locked = function() {
    return this.keybase.is_locked();
  };

  KeyManager.prototype.has_pgp_private = function() {
    return this.pgp.has_private();
  };

  KeyManager.prototype.has_p3skb_private = function() {
    var ref5;
    return (ref5 = this.p3skb) != null ? ref5.has_private() : void 0;
  };

  KeyManager.prototype.has_keybase_private = function() {
    return this.keybase.has_private();
  };

  KeyManager.prototype.is_p3skb_locked = function() {
    var ref5;
    return (ref5 = this.p3skb) != null ? ref5.is_locked() : void 0;
  };

  KeyManager.prototype.unlock_keybase = function(arg, cb) {
    var __iced_it, __iced_passed_deferral, asp, tsenc;
    tsenc = arg.tsenc, asp = arg.asp;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var err;
      return function*() {
        var __iced_deferrals;
        asp = ASP.make(asp);
        __iced_deferrals = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "KeyManager::unlock_keybase",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/keymanager.iced"
        });
        _this.keybase.unlock_keys({
          tsenc: tsenc,
          asp: asp
        }, __iced_deferrals.defer({
          assign_fn: (function() {
            return function() {
              return err = arguments[0];
            };
          })(),
          lineno: 706
        }));
        if (__iced_deferrals.await_exit()) {
          yield;
        }
        return cb(err);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  KeyManager.prototype.export_private_to_server = function(arg, cb) {
    var __iced_it, __iced_passed_deferral, asp, passphrase_generation, tsenc;
    tsenc = arg.tsenc, asp = arg.asp, passphrase_generation = arg.passphrase_generation;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var err, p3skb, ret;
      return function*() {
        var __iced_deferrals;
        asp = ASP.make(asp);
        err = ret = null;
        if ((err = _this._assert_signed()) == null) {
          p3skb = _this.pgp.export_to_p3skb();
          __iced_deferrals = new iced.Deferrals(__iced_it, {
            parent: __iced_passed_deferral,
            funcname: "KeyManager::export_private_to_server",
            filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/keymanager.iced"
          });
          p3skb.lock({
            tsenc: tsenc,
            asp: asp,
            passphrase_generation: passphrase_generation
          }, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                return err = arguments[0];
              };
            })(),
            lineno: 719
          }));
          if (__iced_deferrals.await_exit()) {
            yield;
          }
        }
        if (err == null) {
          ret = p3skb.frame_packet_armored({
            dohash: true
          });
        }
        return cb(err, ret);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  KeyManager.prototype.export_pgp_private_to_client = function(arg, cb) {
    var err, msg, passphrase, regen;
    passphrase = arg.passphrase, regen = arg.regen;
    err = null;
    if (passphrase != null) {
      passphrase = bufferify(passphrase);
    }
    if (regen || ((msg = this.armored_pgp_private) == null)) {
      if ((err = this._assert_signed()) == null) {
        this.armored_pgp_private = msg = this.pgp.export_keys({
          "private": true,
          passphrase: passphrase
        });
      }
    }
    return cb(err, msg);
  };

  KeyManager.prototype.export_pgp_private = function() {
    var args;
    args = 1 <= arguments.length ? slice.call(arguments, 0) : [];
    return this.export_pgp_private_to_client.apply(this, args);
  };

  KeyManager.prototype.export_pgp_public = function(arg, cb) {
    var err, msg, regen;
    regen = arg.regen;
    err = null;
    if (regen || ((msg = this.armored_pgp_public) == null)) {
      if ((err = this._assert_signed()) == null) {
        this.armored_pgp_public = msg = this.pgp.export_keys({
          "private": false
        });
      }
    }
    return cb(err, msg);
  };

  KeyManager.prototype.export_public = function(arg, cb) {
    var __iced_it, __iced_passed_deferral, asp, ref5, regen;
    ref5 = arg != null ? arg : {}, asp = ref5.asp, regen = ref5.regen;
    if (cb == null) {
      cb = null;
    }
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var err, msg;
      return function*() {
        var __iced_deferrals;
        __iced_deferrals = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "KeyManager::export_public",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/keymanager.iced"
        });
        _this.export_pgp_public({
          asp: asp,
          regen: regen
        }, __iced_deferrals.defer({
          assign_fn: (function() {
            return function() {
              err = arguments[0];
              return msg = arguments[1];
            };
          })(),
          lineno: 753
        }));
        if (__iced_deferrals.await_exit()) {
          yield;
        }
        return cb(err, msg);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  KeyManager.prototype.export_private = function(arg, cb) {
    var __iced_it, __iced_passed_deferral, asp, p3skb, passphrase, passphrase_generation, regen;
    passphrase = arg.passphrase, p3skb = arg.p3skb, asp = arg.asp, regen = arg.regen, passphrase_generation = arg.passphrase_generation;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var err, res, tsenc;
      return function*() {
        var __iced_deferrals, __iced_deferrals1;
        if (p3skb) {
          tsenc = new Encryptor({
            key: bufferify(passphrase)
          });
          __iced_deferrals = new iced.Deferrals(__iced_it, {
            parent: __iced_passed_deferral,
            funcname: "KeyManager::export_private",
            filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/keymanager.iced"
          });
          _this.export_private_to_server({
            tsenc: tsenc,
            asp: asp,
            passphrase_generation: passphrase_generation
          }, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                return res = arguments[1];
              };
            })(),
            lineno: 761
          }));
          if (__iced_deferrals.await_exit()) {
            yield;
          }
        } else {
          __iced_deferrals1 = new iced.Deferrals(__iced_it, {
            parent: __iced_passed_deferral,
            funcname: "KeyManager::export_private",
            filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/keymanager.iced"
          });
          _this.export_pgp_private_to_client({
            passphrase: passphrase,
            asp: asp,
            regen: regen
          }, __iced_deferrals1.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                return res = arguments[1];
              };
            })(),
            lineno: 763
          }));
          if (__iced_deferrals1.await_exit()) {
            yield;
          }
        }
        return cb(err, res);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  KeyManager.prototype.pgp_full_hash = function(opts, cb) {
    var __iced_it, __iced_passed_deferral;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var armored, esc;
      return function*() {
        var __iced_deferrals;
        esc = make_esc(cb, "get_pgp_full_hash");
        __iced_deferrals = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "KeyManager::pgp_full_hash",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/keymanager.iced"
        });
        _this.export_pgp_public(opts, esc(__iced_deferrals.defer({
          assign_fn: (function() {
            return function() {
              return armored = arguments[0];
            };
          })(),
          lineno: 770
        })));
        if (__iced_deferrals.await_exit()) {
          yield;
        }
        return cb(null, (new SHA256(Buffer.from(armored.trim()))).toString("hex"));
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  KeyManager.prototype.sign_pgp = function(arg, cb) {
    var asp, time;
    asp = arg.asp, time = arg.time;
    return this.pgp.sign({
      asp: asp,
      time: time
    }, cb);
  };

  KeyManager.prototype.sign = function(arg, cb) {
    var __iced_it, __iced_passed_deferral, asp, time;
    asp = arg.asp, time = arg.time;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var err;
      return function*() {
        var __iced_deferrals;
        asp = ASP.make(asp);
        asp.section("sign");
        asp.progress({
          what: "sign PGP",
          total: 1,
          i: 0
        });
        __iced_deferrals = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "KeyManager::sign",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/keymanager.iced"
        });
        _this.sign_pgp({
          asp: asp,
          time: time
        }, __iced_deferrals.defer({
          assign_fn: (function() {
            return function() {
              return err = arguments[0];
            };
          })(),
          lineno: 783
        }));
        if (__iced_deferrals.await_exit()) {
          yield;
        }
        asp.progress({
          what: "sign PGP",
          total: 1,
          i: 1
        });
        if (err == null) {
          _this._signed = true;
        }
        return cb(err);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  KeyManager.prototype.get_userids = function() {
    return this.userids;
  };

  KeyManager.prototype.get_userids_mark_primary = function() {
    var do_insert, i, j, k, len, max, max_s, mymax, obj, pair, prev, primary_time, ref5, ret, s, tab, userid;
    max = null;
    max_s = null;
    tab = {};
    mymax = function(a, b) {
      if ((a == null) && (b == null)) {
        return null;
      } else if (a == null) {
        return b;
      } else if (b == null) {
        return a;
      } else if (a > b) {
        return a;
      } else {
        return b;
      }
    };
    ref5 = this.userids;
    for (i = j = 0, len = ref5.length; j < len; i = ++j) {
      userid = ref5[i];
      if (!(userid != null)) {
        continue;
      }
      s = userid.utf8();
      pair = userid.time_primary_pair();
      obj = {
        userid: userid,
        pair: pair,
        i: i
      };
      do_insert = false;
      if ((prev = tab[s]) != null) {
        primary_time = mymax(prev.pair[1], pair[1]);
        if (!(prev.pair[0] != null) || (pair[0] && prev.pair[0] < pair[0])) {
          do_insert = true;
        }
      } else {
        primary_time = pair[1];
        do_insert = true;
      }
      if (do_insert) {
        tab[s] = obj;
      }
      if ((primary_time != null) && ((max == null) || max < primary_time)) {
        max_s = s;
        max = primary_time;
      }
    }
    if (max_s != null) {
      tab[max_s].userid.primary = true;
    }
    ret = [];
    for (k in tab) {
      obj = tab[k];
      obj.userid.most_recent_sig = obj.pair[0];
      ret.push(obj.userid);
    }
    return ret;
  };

  KeyManager.prototype.fetch = function(key_ids, flags, cb) {
    return this.pgp.fetch(key_ids, flags, cb);
  };

  KeyManager.prototype.find_pgp_key = function(key_id) {
    return this.pgp.find_key(key_id);
  };

  KeyManager.prototype.find_pgp_key_material = function(key_id) {
    return this.pgp.find_key_material(key_id);
  };

  KeyManager.prototype.find_best_pgp_key = function(flags, need_priv) {
    return this.pgp.find_best_key(flags, need_priv);
  };

  KeyManager.prototype.find_signing_pgp_key = function() {
    return this.find_best_pgp_key(C.key_flags.sign_data, true);
  };

  KeyManager.prototype.find_verifying_pgp_key = function() {
    return this.find_best_pgp_key(C.key_flags.sign_data, false);
  };

  KeyManager.prototype.find_crypt_pgp_key = function(need_priv) {
    if (need_priv == null) {
      need_priv = false;
    }
    return this.find_best_pgp_key(C.key_flags.encrypt_comm, need_priv);
  };

  KeyManager.prototype.can_verify = function() {
    return this.find_verifying_pgp_key() != null;
  };

  KeyManager.prototype.can_sign = function() {
    return this.find_signing_pgp_key() != null;
  };

  KeyManager.prototype.can_encrypt = function() {
    return this.find_crypt_pgp_key(false) != null;
  };

  KeyManager.prototype.can_decrypt = function() {
    return this.find_crypt_pgp_key(true) != null;
  };

  KeyManager.prototype.is_pgp_revoked = function() {
    return this.pgp.is_revoked();
  };

  KeyManager.prototype.get_pgp_designated_revocations = function() {
    return this.pgp.get_designated_revocations();
  };

  KeyManager.prototype.get_primary_keypair = function() {
    return this.primary.key;
  };

  KeyManager.prototype.get_all_pgp_key_materials = function() {
    return this.pgp.get_all_key_materials();
  };

  KeyManager.prototype.export_pgp_keys_to_keyring = function() {
    return this.pgp.export_keys_to_keyring(this);
  };

  KeyManager.prototype.get_pgp_key_id = function() {
    return this.pgp.get_key_id();
  };

  KeyManager.prototype.get_pgp_short_key_id = function() {
    return this.pgp.get_short_key_id();
  };

  KeyManager.prototype.get_pgp_fingerprint = function() {
    return this.pgp.get_fingerprint();
  };

  KeyManager.prototype.get_pgp_fingerprint_str = function() {
    var ref5;
    return (ref5 = this.get_pgp_fingerprint()) != null ? ref5.toString('hex') : void 0;
  };

  KeyManager.prototype.get_ekid = function() {
    return this.pgp.get_ekid();
  };

  KeyManager.prototype.clear_pgp_internal_sigs = function() {
    return this.pgp.clear_psc();
  };

  KeyManager.prototype.get_all_pgp_key_ids = function() {
    return this.pgp.get_all_key_ids();
  };

  KeyManager.prototype.get_ekid_b64_str = function() {
    var k;
    if ((k = this.get_ekid()) != null) {
      return base64u.encode(k);
    } else {
      return null;
    }
  };

  KeyManager.prototype.get_fp2 = function() {
    return this.get_pgp_fingerprint();
  };

  KeyManager.prototype.get_fp2_formatted = function(opts) {
    var p;
    if ((p = this.get_fp2()) != null) {
      return format_pgp_fingerprint_2(p, opts);
    } else {
      return null;
    }
  };

  KeyManager.prototype.get_type = function() {
    return "pgp";
  };

  KeyManager.prototype.check_pgp_validity = function(cb) {
    return this.pgp.validity_check(cb);
  };

  KeyManager.prototype.make_sig_eng = function() {
    return new SignatureEngine({
      km: this
    });
  };

  KeyManager.prototype._apply_to_engines = function(arg, cb) {
    var __iced_it, __iced_passed_deferral, args, meth;
    args = arg.args, meth = arg.meth;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var e, err;
      return function*() {
        var __iced_deferrals, j, len, ref5;
        err = null;
        ref5 = _this.engines;
        for (j = 0, len = ref5.length; j < len; j++) {
          e = ref5[j];
          if (!err) {
            __iced_deferrals = new iced.Deferrals(__iced_it, {
              parent: __iced_passed_deferral,
              funcname: "KeyManager::_apply_to_engines",
              filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/keymanager.iced"
            });
            meth.call(e, args, __iced_deferrals.defer({
              assign_fn: (function() {
                return function() {
                  return err = arguments[0];
                };
              })(),
              lineno: 923
            }));
            if (__iced_deferrals.await_exit()) {
              yield;
            }
          }
        }
        return cb(err);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  KeyManager.prototype._assert_signed = function() {
    if (this._signed) {
      return null;
    } else {
      return new Error("need to sign before export");
    }
  };

  KeyManager._wrap_pgp = function(klass, kmp) {
    var ref5;
    return new klass({
      key: kmp.key,
      lifespan: new Lifespan({
        generated: kmp.timestamp,
        expire_in: (ref5 = kmp.get_expire_time()) != null ? ref5.expire_in : void 0
      }),
      _pgp: kmp
    });
  };

  KeyManager.prototype.merge_all_subkeys_omitting_revokes = function(km2) {
    if ((this.pgp != null) && (km2.pgp != null)) {
      return this.pgp.merge_all_subkeys_omitting_revokes(km2.pgp);
    }
  };

  KeyManager.prototype.pgp_check_not_expired = function(arg) {
    var now, subkey_material;
    subkey_material = arg.subkey_material, now = arg.now;
    return this.pgp.check_not_expired({
      subkey_material: subkey_material,
      now: now
    });
  };

  KeyManager.prototype.merge_public_omitting_revokes = function(km2) {
    if ((this.pgp != null) && (km2.pgp != null)) {
      return this.pgp.merge_public_omitting_revokes(km2.pgp);
    }
  };

  KeyManager.prototype.merge_userids = function(km2) {
    var candidate_userid, existing_userid, existing_utf8_strings, j, l, len, len1, ref5, ref6, results;
    if ((this.pgp == null) || (km2.pgp == null)) {
      return;
    }
    existing_utf8_strings = {};
    ref5 = this.userids;
    for (j = 0, len = ref5.length; j < len; j++) {
      existing_userid = ref5[j];
      existing_utf8_strings[existing_userid.utf8()] = true;
    }
    ref6 = km2.get_userids_mark_primary();
    results = [];
    for (l = 0, len1 = ref6.length; l < len1; l++) {
      candidate_userid = ref6[l];
      if (!(candidate_userid.utf8() in existing_utf8_strings)) {
        results.push(this.userids.push(candidate_userid));
      } else {
        results.push(void 0);
      }
    }
    return results;
  };

  KeyManager.prototype.merge_everything = function(km2) {
    this.merge_public_omitting_revokes(km2);
    return this.merge_userids(km2);
  };

  KeyManager.prototype.find_verified_designated_revoke = function(fetcher, cb) {
    var __iced_it, __iced_passed_deferral;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var err, i, key_id, keymat, km, sig, sigs;
      return function*() {
        var __iced_deferrals, __iced_deferrals1, j, len;
        if (_this.pgp == null) {
          return cb();
        }
        sigs = _this.get_pgp_designated_revocations();
        if ((sigs == null) || sigs.length === 0) {
          return cb();
        }
        for (j = 0, len = sigs.length; j < len; j++) {
          sig = sigs[j];
          key_id = sig.get_issuer_key_id();
          __iced_deferrals = new iced.Deferrals(__iced_it, {
            parent: __iced_passed_deferral,
            funcname: "KeyManager::find_verified_designated_revoke",
            filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/keymanager.iced"
          });
          fetcher.fetch([key_id], konst.ops.verify, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                km = arguments[1];
                return i = arguments[2];
              };
            })(),
            lineno: 995
          }));
          if (__iced_deferrals.await_exit()) {
            yield;
          }
          if (err || (km == null) || (km.pgp == null)) {
            continue;
          }
          keymat = km.find_pgp_key_material(key_id);
          if (keymat == null) {
            continue;
          }
          __iced_deferrals1 = new iced.Deferrals(__iced_it, {
            parent: __iced_passed_deferral,
            funcname: "KeyManager::find_verified_designated_revoke",
            filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/keymanager.iced"
          });
          sig._third_party_verify(keymat, __iced_deferrals1.defer({
            assign_fn: (function() {
              return function() {
                return err = arguments[0];
              };
            })(),
            lineno: 1003
          }));
          if (__iced_deferrals1.await_exit()) {
            yield;
          }
          if (!err) {
            return cb(sig);
          }
        }
        return cb();
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  return KeyManager;

})(KeyManagerInterface);

exports.KeyManager = KeyManager;

exports.opkts = opkts;

//# sourceMappingURL=keymanager.js.map
