// Generated by IcedCoffeeScript 112.8.1
var C, Ch, CreationTime, Issuer, Literal, Signature, Signer, Verifier, VerifierBase, WordArray, encode, hash_obj_to_fn, iced, konst, make_esc, packetsigs, ref, streamers, unix_time,
  extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty;

iced = require('iced-runtime-3');

make_esc = require('iced-error').make_esc;

ref = require('./packet/signature'), Signature = ref.Signature, CreationTime = ref.CreationTime, Issuer = ref.Issuer;

unix_time = require('../util').unix_time;

WordArray = require('triplesec').WordArray;

konst = require('../const');

C = konst.openpgp;

Ch = require('../header');

streamers = require('../hash').streamers;

encode = require('./armor').encode;

Literal = require("./packet/literal").Literal;

VerifierBase = require('./verifier').Base;

packetsigs = require('./packet/packetsigs');

hash_obj_to_fn = function(obj) {
  var fn;
  fn = function(buf) {
    return obj.finalize(WordArray.from_buffer(buf)).to_buffer();
  };
  return fn.algname = buf.algname;
};

Signer = (function() {
  function Signer(arg) {
    this.data = arg.data, this.hash_streamer = arg.hash_streamer, this.signing_key = arg.signing_key;
  }

  Signer.prototype.run = function(cb) {
    var __iced_it, __iced_passed_deferral;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var encoded, esc, signature;
      return function*() {
        var __iced_deferrals, __iced_deferrals1, __iced_deferrals2;
        esc = make_esc(cb, "Signer::run");
        __iced_deferrals = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "Signer::run",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/detachsign.iced"
        });
        _this._run_hash(esc(__iced_deferrals.defer({
          lineno: 39
        })));
        if (__iced_deferrals.await_exit()) {
          yield;
        }
        __iced_deferrals1 = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "Signer::run",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/detachsign.iced"
        });
        _this._sign(esc(__iced_deferrals1.defer({
          assign_fn: (function() {
            return function() {
              return signature = arguments[0];
            };
          })(),
          lineno: 40
        })));
        if (__iced_deferrals1.await_exit()) {
          yield;
        }
        __iced_deferrals2 = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "Signer::run",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/detachsign.iced"
        });
        _this._encode(esc(__iced_deferrals2.defer({
          assign_fn: (function() {
            return function() {
              return encoded = arguments[0];
            };
          })(),
          lineno: 41
        })));
        if (__iced_deferrals2.await_exit()) {
          yield;
        }
        return cb(null, encoded, signature);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  Signer.prototype.scrub = function() {};

  Signer.prototype._sign = function(cb) {
    var __iced_it, __iced_passed_deferral;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var emptybuf, err;
      return function*() {
        var __iced_deferrals;
        _this.sig = new Signature({
          sig_type: C.sig_types.canonical_text,
          key: _this.signing_key.key,
          hashed_subpackets: [new CreationTime(unix_time())],
          unhashed_subpackets: [new Issuer(_this.signing_key.get_key_id())],
          hasher: _this.hash_streamer
        });
        emptybuf = Buffer.from([]);
        __iced_deferrals = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "Signer::_sign",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/detachsign.iced"
        });
        _this.sig.write(emptybuf, __iced_deferrals.defer({
          assign_fn: (function(__slot_1) {
            return function() {
              err = arguments[0];
              return __slot_1._sig_output = arguments[1];
            };
          })(_this),
          lineno: 59
        }));
        if (__iced_deferrals.await_exit()) {
          yield;
        }
        return cb(err, _this._sig_output);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  Signer.prototype._encode = function(cb) {
    var err, ret;
    err = null;
    ret = encode(C.message_types.signature, this._sig_output);
    return cb(err, ret);
  };

  Signer.prototype._run_hash = function(cb) {
    var err;
    err = null;
    if (this.hash_streamer != null) {

    } else if (this.data != null) {
      this.hash_streamer = streamers.SHA512();
      this.hash_streamer.update(this.data);
    } else {
      err = new Error("Need either a hasher or data");
    }
    return cb(err);
  };

  return Signer;

})();

Verifier = (function(superClass) {
  extend(Verifier, superClass);

  function Verifier(arg) {
    var keyfetch, packets;
    packets = arg.packets, this.data = arg.data, this.data_fn = arg.data_fn, keyfetch = arg.keyfetch, this.now = arg.now, this.assert_pgp_hash = arg.assert_pgp_hash;
    Verifier.__super__.constructor.call(this, {
      packets: packets,
      keyfetch: keyfetch
    });
  }

  Verifier.prototype._consume_data = function(cb) {
    var __iced_it, __iced_passed_deferral;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var buf_hasher, done, err, go, klass, streamer;
      return function*() {
        var __iced_deferrals;
        err = null;
        if (_this.data_fn != null) {
          err = null;
          klass = _this._sig.hasher.klass;
          streamer = streamers[_this._sig.hasher.algname]();
          buf_hasher = function(buf) {
            return streamer.update(buf);
          };
          go = true;
          while (go) {
            __iced_deferrals = new iced.Deferrals(__iced_it, {
              parent: __iced_passed_deferral,
              funcname: "Verifier::_consume_data",
              filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/detachsign.iced"
            });
            _this.data_fn(buf_hasher, __iced_deferrals.defer({
              assign_fn: (function() {
                return function() {
                  err = arguments[0];
                  return done = arguments[1];
                };
              })(),
              lineno: 101
            }));
            if (__iced_deferrals.await_exit()) {
              yield;
            }
            if ((err != null) || done) {
              go = false;
            }
          }
          _this._sig.hasher = streamer;
        }
        return cb(err);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  Verifier.prototype._verify = function(cb) {
    var __iced_it, __iced_passed_deferral;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var data, err, opts;
      return function*() {
        var __iced_deferrals;
        data = _this.data ? [
          new Literal({
            data: _this.data
          })
        ] : [];
        _this.literals = data;
        opts = {
          now: _this.now,
          assert_pgp_hash: _this.assert_pgp_hash
        };
        __iced_deferrals = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "Verifier::_verify",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/detachsign.iced"
        });
        _this._sig.verify(data, __iced_deferrals.defer({
          assign_fn: (function() {
            return function() {
              return err = arguments[0];
            };
          })(),
          lineno: 113
        }), opts);
        if (__iced_deferrals.await_exit()) {
          yield;
        }
        return cb(err);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  Verifier.prototype._make_literals = function(cb) {
    if (!this.literals.length) {
      this.literals.push(new Literal({
        data: Buffer.from([])
      }));
    }
    this.literals[0].push_sig(new packetsigs.Data({
      sig: this._sig
    }));
    return cb(null);
  };

  Verifier.prototype.run = function(cb) {
    var __iced_it, __iced_passed_deferral;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var esc;
      return function*() {
        var __iced_deferrals, __iced_deferrals1, __iced_deferrals2, __iced_deferrals3, __iced_deferrals4;
        esc = make_esc(cb, "Verifier::run");
        __iced_deferrals = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "Verifier::run",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/detachsign.iced"
        });
        _this._find_signature(esc(__iced_deferrals.defer({
          lineno: 128
        })));
        if (__iced_deferrals.await_exit()) {
          yield;
        }
        __iced_deferrals1 = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "Verifier::run",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/detachsign.iced"
        });
        _this._fetch_key(esc(__iced_deferrals1.defer({
          lineno: 129
        })));
        if (__iced_deferrals1.await_exit()) {
          yield;
        }
        __iced_deferrals2 = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "Verifier::run",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/detachsign.iced"
        });
        _this._consume_data(esc(__iced_deferrals2.defer({
          lineno: 130
        })));
        if (__iced_deferrals2.await_exit()) {
          yield;
        }
        __iced_deferrals3 = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "Verifier::run",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/detachsign.iced"
        });
        _this._verify(esc(__iced_deferrals3.defer({
          lineno: 131
        })));
        if (__iced_deferrals3.await_exit()) {
          yield;
        }
        __iced_deferrals4 = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "Verifier::run",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/detachsign.iced"
        });
        _this._make_literals(esc(__iced_deferrals4.defer({
          lineno: 132
        })));
        if (__iced_deferrals4.await_exit()) {
          yield;
        }
        return cb(null, _this.literals);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  return Verifier;

})(VerifierBase);

exports.sign = function(arg, cb) {
  var __iced_it, __iced_passed_deferral, data, encoded, err, hash_streamer, now, s, signature, signing_key;
  data = arg.data, hash_streamer = arg.hash_streamer, signing_key = arg.signing_key, now = arg.now;
  __iced_passed_deferral = iced.findDeferral(arguments);
  __iced_it = (function*() {
    var __iced_deferrals;
    s = new Signer({
      data: data,
      hash_streamer: hash_streamer,
      signing_key: signing_key,
      now: now
    });
    __iced_deferrals = new iced.Deferrals(__iced_it, {
      parent: __iced_passed_deferral,
      funcname: "exports.sign",
      filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/detachsign.iced"
    });
    s.run(__iced_deferrals.defer({
      assign_fn: (function() {
        return function() {
          err = arguments[0];
          encoded = arguments[1];
          return signature = arguments[2];
        };
      })(),
      lineno: 139
    }));
    if (__iced_deferrals.await_exit()) {
      yield;
    }
    s.scrub();
    return cb(err, encoded, signature);
  })();
  __iced_it.next();
  return null;
};

exports.verify = function(arg, cb) {
  var __iced_it, __iced_passed_deferral, assert_pgp_hash, data, data_fn, err, keyfetch, literals, now, packets, v;
  data = arg.data, data_fn = arg.data_fn, packets = arg.packets, keyfetch = arg.keyfetch, now = arg.now, assert_pgp_hash = arg.assert_pgp_hash;
  __iced_passed_deferral = iced.findDeferral(arguments);
  __iced_it = (function*() {
    var __iced_deferrals;
    v = new Verifier({
      data: data,
      data_fn: data_fn,
      packets: packets,
      keyfetch: keyfetch,
      now: now,
      assert_pgp_hash: assert_pgp_hash
    });
    __iced_deferrals = new iced.Deferrals(__iced_it, {
      parent: __iced_passed_deferral,
      funcname: "exports.verify",
      filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/detachsign.iced"
    });
    v.run(__iced_deferrals.defer({
      assign_fn: (function() {
        return function() {
          err = arguments[0];
          return literals = arguments[1];
        };
      })(),
      lineno: 147
    }));
    if (__iced_deferrals.await_exit()) {
      yield;
    }
    return cb(err, literals);
  })();
  __iced_it.next();
  return null;
};

//# sourceMappingURL=detachsign.js.map
