// Generated by IcedCoffeeScript 112.8.1
var C, Ch, ClearSigner, CreationTime, Issuer, Literal, SHA512, SRF, Signature, Verifier, VerifierBase, WordArray, bufferify, clearsign_header, clearsign_to_sign, dash_escape, dash_unescape_line, dash_unescape_lines, encode, export_key_pgp, get_cipher, hashmod, iced, input_to_cleartext, input_to_cleartext_display, input_to_cleartext_sign, konst, make_esc, ref, ref1, ref2, scrub_buffer, triplesec, unix_time, whitespace_strip,
  extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty;

iced = require('iced-runtime-3');

make_esc = require('iced-error').make_esc;

ref = require('./packet/signature'), Signature = ref.Signature, CreationTime = ref.CreationTime, Issuer = ref.Issuer;

ref1 = require('../util'), bufferify = ref1.bufferify, unix_time = ref1.unix_time;

SRF = require('../rand').SRF;

triplesec = require('triplesec');

ref2 = require('../symmetric'), export_key_pgp = ref2.export_key_pgp, get_cipher = ref2.get_cipher;

scrub_buffer = triplesec.util.scrub_buffer;

WordArray = triplesec.WordArray;

konst = require('../const');

C = konst.openpgp;

Ch = require('../header');

hashmod = require('../hash');

SHA512 = hashmod.SHA512;

encode = require('./armor').encode;

clearsign_header = require('pgp-utils').armor.clearsign_header;

Literal = require("./packet/literal").Literal;

VerifierBase = require('./verifier').Base;

exports.input_to_cleartext = input_to_cleartext = function(raw) {
  var lines, ret;
  lines = raw.split(/\n/);
  ret = {
    show: bufferify(input_to_cleartext_display(lines)),
    sign: bufferify(input_to_cleartext_sign(lines))
  };
  return ret;
};

exports.dash_escape = dash_escape = function(line) {
  if (line.length >= 1 && line[0] === '-') {
    return "- " + line;
  } else {
    return line;
  }
};

exports.dash_unescape_line = dash_unescape_line = function(line) {
  var m, out, ref3, warn;
  warn = false;
  out = (m = line.match(/^-( )?(.*?)$/)) != null ? (((ref3 = m[1]) != null ? ref3.length : void 0) !== 1 ? warn = true : void 0, m[2]) : line;
  return [out, warn];
};

exports.dash_unescape_lines = dash_unescape_lines = function(lines, warnings) {
  var i, l, line, ret, warn;
  if (warnings == null) {
    warnings = null;
  }
  ret = (function() {
    var j, len, ref3, results;
    results = [];
    for (i = j = 0, len = lines.length; j < len; i = ++j) {
      line = lines[i];
      ref3 = dash_unescape_line(line), l = ref3[0], warn = ref3[1];
      if (warn) {
        if (warnings != null) {
          warnings.push("Bad dash-encoding on line " + (i + 1));
        }
      }
      results.push(l);
    }
    return results;
  })();
  return ret;
};

exports.input_to_cleartext_display = input_to_cleartext_display = function(lines) {
  var line, out;
  out = (function() {
    var j, len, results;
    results = [];
    for (j = 0, len = lines.length; j < len; j++) {
      line = lines[j];
      results.push(dash_escape(line));
    }
    return results;
  })();
  if (lines.length === 0 || lines.slice(-1)[0] !== '') {
    out.push('');
  }
  return out.join("\n");
};

exports.clearsign_to_sign = clearsign_to_sign = function(lines, warnings) {
  lines = dash_unescape_lines(lines, warnings);
  return input_to_cleartext_sign(lines);
};

exports.input_to_cleartext_sign = input_to_cleartext_sign = function(lines) {
  var j, line, num_trailing_newlines, t, tmp;
  tmp = (function() {
    var j, len, results;
    results = [];
    for (j = 0, len = lines.length; j < len; j++) {
      line = lines[j];
      results.push(whitespace_strip(line));
    }
    return results;
  })();
  num_trailing_newlines = 0;
  for (j = tmp.length - 1; j >= 0; j += -1) {
    t = tmp[j];
    if (t === '') {
      num_trailing_newlines++;
    } else {
      break;
    }
  }
  if (num_trailing_newlines > 0) {
    tmp.pop();
  }
  return tmp.join("\r\n");
};

exports.whitespace_strip = whitespace_strip = function(line) {
  var m;
  line = line.replace(/\r/g, '');
  if ((m = line.match(/^(.*?)([ \t]*)$/))) {
    return m[1];
  } else {
    return line;
  }
};

ClearSigner = (function() {
  function ClearSigner(arg) {
    this.msg = arg.msg, this.signing_key = arg.signing_key, this.now = arg.now, this.hasher = arg.hasher;
  }

  ClearSigner.prototype._fix_msg = function(cb) {
    this._cleartext = input_to_cleartext(this.msg.toString('utf8'));
    return cb(null);
  };

  ClearSigner.prototype._sign_msg = function(cb) {
    var __iced_it, __iced_passed_deferral;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var err;
      return function*() {
        var __iced_deferrals;
        _this.sig = new Signature({
          hasher: _this.hasher,
          sig_type: C.sig_types.canonical_text,
          key: _this.signing_key.key,
          hashed_subpackets: [new CreationTime(_this.now || unix_time())],
          unhashed_subpackets: [new Issuer(_this.signing_key.get_key_id())]
        });
        __iced_deferrals = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "ClearSigner::_sign_msg",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/clearsign.iced"
        });
        _this.sig.write(_this._cleartext.sign, __iced_deferrals.defer({
          assign_fn: (function(__slot_1) {
            return function() {
              err = arguments[0];
              return __slot_1._sig_output = arguments[1];
            };
          })(_this),
          lineno: 118
        }));
        if (__iced_deferrals.await_exit()) {
          yield;
        }
        return cb(err, _this._sig_output);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  ClearSigner.prototype.scrub = function() {};

  ClearSigner.prototype.hasher_name = function() {
    return this.sig.hasher.algname;
  };

  ClearSigner.prototype._encode = function(cb) {
    var body, hdr;
    hdr = clearsign_header(Ch, this._cleartext.show, this.hasher_name());
    body = encode(C.message_types.signature, this._sig_output);
    return cb(null, hdr + body);
  };

  ClearSigner.prototype.run = function(cb) {
    var __iced_it, __iced_passed_deferral;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var encoded, esc, signature;
      return function*() {
        var __iced_deferrals, __iced_deferrals1, __iced_deferrals2;
        esc = make_esc(cb, "ClearSigner::run");
        __iced_deferrals = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "ClearSigner::run",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/clearsign.iced"
        });
        _this._fix_msg(esc(__iced_deferrals.defer({
          lineno: 140
        })));
        if (__iced_deferrals.await_exit()) {
          yield;
        }
        __iced_deferrals1 = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "ClearSigner::run",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/clearsign.iced"
        });
        _this._sign_msg(esc(__iced_deferrals1.defer({
          assign_fn: (function() {
            return function() {
              return signature = arguments[0];
            };
          })(),
          lineno: 141
        })));
        if (__iced_deferrals1.await_exit()) {
          yield;
        }
        __iced_deferrals2 = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "ClearSigner::run",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/clearsign.iced"
        });
        _this._encode(esc(__iced_deferrals2.defer({
          assign_fn: (function() {
            return function() {
              return encoded = arguments[0];
            };
          })(),
          lineno: 142
        })));
        if (__iced_deferrals2.await_exit()) {
          yield;
        }
        return cb(null, encoded, signature);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  return ClearSigner;

})();

Verifier = (function(superClass) {
  extend(Verifier, superClass);

  function Verifier(arg) {
    var keyfetch, packets;
    packets = arg.packets, this.clearsign = arg.clearsign, keyfetch = arg.keyfetch, this.now = arg.now, this.assert_pgp_hash = arg.assert_pgp_hash;
    Verifier.__super__.constructor.call(this, {
      packets: packets,
      keyfetch: keyfetch
    });
  }

  Verifier.prototype._reformat_text = function(cb) {
    var data;
    data = bufferify(clearsign_to_sign(this.clearsign.lines));
    this._literal = new Literal({
      data: data,
      format: C.literal_formats.utf8,
      date: this.now || unix_time()
    });
    return cb(null);
  };

  Verifier.prototype._make_hasher = function(cb) {
    var err, h;
    err = null;
    h = (this.clearsign.headers.hash || 'MD5').trim();
    if ((this._sig.hasher = hashmod[h]) == null) {
      err = new Error("Unknown hash algorithm: " + h);
    }
    return cb(err);
  };

  Verifier.prototype._verify = function(cb) {
    var __iced_it, __iced_passed_deferral;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var err, opts;
      return function*() {
        var __iced_deferrals;
        opts = {
          now: _this.now,
          assert_pgp_hash: _this.assert_pgp_hash
        };
        __iced_deferrals = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "Verifier::_verify",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/clearsign.iced"
        });
        _this._sig.verify([_this._literal], __iced_deferrals.defer({
          assign_fn: (function() {
            return function() {
              return err = arguments[0];
            };
          })(),
          lineno: 184
        }), opts);
        if (__iced_deferrals.await_exit()) {
          yield;
        }
        return cb(err);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  Verifier.prototype._check_headers = function(cb) {
    var err, k, ref3, v;
    err = null;
    ref3 = this.clearsign.headers;
    for (k in ref3) {
      v = ref3[k];
      if (k !== 'hash') {
        err = new Error("Unallowed header: " + k);
        break;
      }
    }
    return cb(err);
  };

  Verifier.prototype.run = function(cb) {
    var __iced_it, __iced_passed_deferral;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var esc;
      return function*() {
        var __iced_deferrals, __iced_deferrals1, __iced_deferrals2, __iced_deferrals3, __iced_deferrals4, __iced_deferrals5;
        esc = make_esc(cb, "Verifier::run");
        __iced_deferrals = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "Verifier::run",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/clearsign.iced"
        });
        _this._check_headers(esc(__iced_deferrals.defer({
          lineno: 201
        })));
        if (__iced_deferrals.await_exit()) {
          yield;
        }
        __iced_deferrals1 = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "Verifier::run",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/clearsign.iced"
        });
        _this._find_signature(esc(__iced_deferrals1.defer({
          lineno: 202
        })));
        if (__iced_deferrals1.await_exit()) {
          yield;
        }
        __iced_deferrals2 = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "Verifier::run",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/clearsign.iced"
        });
        _this._reformat_text(esc(__iced_deferrals2.defer({
          lineno: 203
        })));
        if (__iced_deferrals2.await_exit()) {
          yield;
        }
        __iced_deferrals3 = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "Verifier::run",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/clearsign.iced"
        });
        _this._fetch_key(esc(__iced_deferrals3.defer({
          lineno: 204
        })));
        if (__iced_deferrals3.await_exit()) {
          yield;
        }
        __iced_deferrals4 = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "Verifier::run",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/clearsign.iced"
        });
        _this._make_hasher(esc(__iced_deferrals4.defer({
          lineno: 205
        })));
        if (__iced_deferrals4.await_exit()) {
          yield;
        }
        __iced_deferrals5 = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "Verifier::run",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/clearsign.iced"
        });
        _this._verify(esc(__iced_deferrals5.defer({
          lineno: 206
        })));
        if (__iced_deferrals5.await_exit()) {
          yield;
        }
        return cb(null, _this._literal);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  return Verifier;

})(VerifierBase);

exports.sign = function(arg, cb) {
  var __iced_it, __iced_passed_deferral, b, encoded, err, hasher, msg, now, signature, signing_key;
  msg = arg.msg, signing_key = arg.signing_key, now = arg.now, hasher = arg.hasher;
  __iced_passed_deferral = iced.findDeferral(arguments);
  __iced_it = (function*() {
    var __iced_deferrals;
    b = new ClearSigner({
      msg: msg,
      signing_key: signing_key,
      now: now,
      hasher: hasher
    });
    __iced_deferrals = new iced.Deferrals(__iced_it, {
      parent: __iced_passed_deferral,
      funcname: "exports.sign",
      filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/clearsign.iced"
    });
    b.run(__iced_deferrals.defer({
      assign_fn: (function() {
        return function() {
          err = arguments[0];
          encoded = arguments[1];
          return signature = arguments[2];
        };
      })(),
      lineno: 217
    }));
    if (__iced_deferrals.await_exit()) {
      yield;
    }
    b.scrub();
    return cb(err, encoded, signature);
  })();
  __iced_it.next();
  return null;
};

exports.verify = function(arg, cb) {
  var __iced_it, __iced_passed_deferral, assert_pgp_hash, clearsign, err, keyfetch, literal, now, packets, v;
  packets = arg.packets, clearsign = arg.clearsign, keyfetch = arg.keyfetch, now = arg.now, assert_pgp_hash = arg.assert_pgp_hash;
  __iced_passed_deferral = iced.findDeferral(arguments);
  __iced_it = (function*() {
    var __iced_deferrals;
    v = new Verifier({
      packets: packets,
      clearsign: clearsign,
      keyfetch: keyfetch,
      now: now,
      assert_pgp_hash: assert_pgp_hash
    });
    __iced_deferrals = new iced.Deferrals(__iced_it, {
      parent: __iced_passed_deferral,
      funcname: "exports.verify",
      filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/clearsign.iced"
    });
    v.run(__iced_deferrals.defer({
      assign_fn: (function() {
        return function() {
          err = arguments[0];
          return literal = arguments[1];
        };
      })(),
      lineno: 225
    }));
    if (__iced_deferrals.await_exit()) {
      yield;
    }
    return cb(err, literal);
  })();
  __iced_it.next();
  return null;
};

//# sourceMappingURL=clearsign.js.map
