// Generated by IcedCoffeeScript 112.8.1
var ASP, BaseBurner, iced, make_esc,
  slice = [].slice;

iced = require('iced-runtime-3');

make_esc = require('iced-error').make_esc;

ASP = require('pgp-utils').util.ASP;

exports.BaseBurner = BaseBurner = (function() {
  function BaseBurner(arg) {
    this.sign_with = arg.sign_with, this.encrypt_for = arg.encrypt_for, this.signing_key = arg.signing_key, this.encryption_key = arg.encryption_key, this.asp = arg.asp;
    this.asp = ASP.make(this.asp);
  }

  BaseBurner.prototype._find_keys = function(cb) {
    var __iced_it, __iced_passed_deferral;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var esc;
      return function*() {
        var __iced_deferrals, __iced_deferrals1, __iced_deferrals2;
        esc = make_esc(cb, "find_keys");
        __iced_deferrals = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "BaseBurner::_find_keys",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/baseburner.iced"
        });
        _this._find_signing_key(esc(__iced_deferrals.defer({
          lineno: 17
        })));
        if (__iced_deferrals.await_exit()) {
          yield;
        }
        __iced_deferrals1 = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "BaseBurner::_find_keys",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/baseburner.iced"
        });
        _this._find_encryption_key(esc(__iced_deferrals1.defer({
          lineno: 18
        })));
        if (__iced_deferrals1.await_exit()) {
          yield;
        }
        __iced_deferrals2 = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "BaseBurner::_find_keys",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/baseburner.iced"
        });
        _this._assert_one(esc(__iced_deferrals2.defer({
          lineno: 19
        })));
        if (__iced_deferrals2.await_exit()) {
          yield;
        }
        return cb(null);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  BaseBurner.prototype._assert_one = function(cb) {
    var err;
    err = null;
    if (!(this.signing_key != null) && !(this.encryption_keys != null)) {
      err = new Error("need either an encryption or signing key, or both");
    }
    return cb(err);
  };

  BaseBurner.prototype._find_signing_key = function(cb) {
    var err;
    err = null;
    if ((this.sign_with != null) && (this.signing_key != null)) {
      err = new Error("specify either `sign_with` or `signing_key` but not both");
    } else if ((this.sign_with != null) && ((this.signing_key = this.sign_with.find_signing_pgp_key()) == null)) {
      err = new Error("cannot sign with the given KeyManager");
    }
    return cb(err);
  };

  BaseBurner.prototype._find_encryption_key = function(cb) {
    var arrayize, count_true, err, f, i, j, k, len, ref;
    err = null;
    count_true = function() {
      var e, i, j, len, v;
      v = 1 <= arguments.length ? slice.call(arguments, 0) : [];
      i = 0;
      for (j = 0, len = v.length; j < len; j++) {
        e = v[j];
        if (e) {
          i++;
        }
      }
      return i;
    };
    arrayize = function(e) {
      if (e == null) {
        return [];
      } else if (typeof e === 'object' && Array.isArray(e)) {
        return e;
      } else {
        return [e];
      }
    };
    if (count_true(this.encrypt_for != null, this.encryption_key != null, this.encryption_keys != null) > 1) {
      err = new Error("specify only one of `encrypt_for`, `encryption_keys` and `encryption_key`");
    } else if (this.encrypt_for != null) {
      this.encryption_keys = [];
      ref = (this.encrypt_for = arrayize(this.encrypt_for));
      for (i = j = 0, len = ref.length; j < len; i = ++j) {
        f = ref[i];
        if ((k = f.find_crypt_pgp_key()) != null) {
          this.encryption_keys.push(k);
        } else {
          err = new Error("cannot encrypt with the given KeyManager (i=" + i + ")");
          break;
        }
      }
    } else if (this.encryption_key != null) {
      this.encryption_keys = [this.encryption_key];
    } else if (this.encryption_keys != null) {
      this.encryption_keys = arrayize(this.encryption_keys);
    }
    return cb(err);
  };

  return BaseBurner;

})();

//# sourceMappingURL=baseburner.js.map
