// Generated by IcedCoffeeScript 112.8.1
var BaseKey, BaseKeyPair, K, NaclDh, Pair, Priv, Pub, SRF, TYPE, b2u, bufeq_fast, bufeq_secure, genseed, iced, kbnacl, konst, prefix_signature_payload, ref, u2b,
  extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty;

iced = require('iced-runtime-3');

kbnacl = require('keybase-nacl');

SRF = require('../rand').SRF;

konst = require('../const');

K = konst.kb;

ref = require('../util'), prefix_signature_payload = ref.prefix_signature_payload, genseed = ref.genseed, bufeq_secure = ref.bufeq_secure, bufeq_fast = ref.bufeq_fast;

BaseKey = require('../basekeypair').BaseKey;

BaseKeyPair = require('./base').BaseKeyPair;

NaclDh = require('./dh');

TYPE = K.public_key_algorithms.NACL_EDDSA;

exports.b2u = b2u = function(b) {
  return new Uint8Array(b);
};

exports.u2b = u2b = function(u) {
  return Buffer.from(u);
};

Pub = (function() {
  Pub.HEADER = Buffer.from([K.kid.version, TYPE]);

  Pub.TRAILER = Buffer.from([K.kid.trailer]);

  Pub.LEN = Pub.HEADER.length + Pub.TRAILER.length + kbnacl.sign.publicKeyLength;

  function Pub(key1) {
    this.key = key1;
  }

  Pub.alloc_kb = function(kid) {
    var err, key;
    err = key = null;
    err = kid.length !== Pub.LEN ? new Error("bad key length") : !bufeq_fast(kid.slice(-1), Pub.TRAILER) ? new Error("bad trailing byte") : !bufeq_fast(kid.slice(0, 2), Pub.HEADER) ? new Error("bad header") : (key = new Pub(kid.slice(2, -1)), null);
    return [err, key];
  };

  Pub.prototype.serialize = function() {
    return this.key;
  };

  Pub.prototype.nbits = function() {
    return 255;
  };

  Pub.prototype.read_params = function(sb) {};

  Pub.prototype.verify = function(arg1, cb) {
    var detached, err, naclw, payload, prefix, ref1, sig;
    payload = arg1.payload, sig = arg1.sig, detached = arg1.detached, prefix = arg1.prefix;
    naclw = kbnacl.alloc({
      publicKey: this.key
    });
    payload = prefix_signature_payload(prefix, payload);
    ref1 = naclw.verify({
      payload: payload,
      sig: sig,
      detached: detached
    }), err = ref1[0], payload = ref1[1];
    return cb(err, payload);
  };

  return Pub;

})();

Priv = (function() {
  function Priv(key1) {
    this.key = key1;
  }

  Priv.prototype.alloc = function(raw) {
    var err, key;
    err = key = null;
    if (raw.length !== sign.secretKeyLength) {
      err = new Error("Bad secret key length");
    } else {
      key = new Priv(raw);
    }
    return [err, key];
  };

  Priv.prototype.sign = function(arg1, cb) {
    var detached, naclw, payload, sig;
    payload = arg1.payload, detached = arg1.detached;
    naclw = kbnacl.alloc({
      secretKey: this.key
    });
    sig = naclw.sign({
      payload: payload,
      detached: detached
    });
    return cb(sig);
  };

  return Priv;

})();

Pair = (function(superClass) {
  extend(Pair, superClass);

  Pair.Pub = Pub;

  Pair.prototype.Pub = Pub;

  Pair.Priv = Priv;

  Pair.prototype.Priv = Priv;

  Pair.type = K.public_key_algorithms.NACL_EDDSA;

  Pair.prototype.type = Pair.type;

  Pair.prototype.get_type = function() {
    return this.type;
  };

  Pair.klass_name = "EDDSA";

  function Pair(arg1) {
    var priv, pub;
    pub = arg1.pub, priv = arg1.priv;
    Pair.__super__.constructor.call(this, {
      pub: pub,
      priv: priv
    });
  }

  Pair.prototype.can_encrypt = function() {
    return false;
  };

  Pair.prototype.hash = function() {
    return this.serialize();
  };

  Pair.prototype.sign_kb = function(arg1, cb) {
    var __iced_it, __iced_passed_deferral, detached, payload, prefix;
    payload = arg1.payload, detached = arg1.detached, prefix = arg1.prefix;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var err, sig;
      return function*() {
        var __iced_deferrals;
        err = sig = null;
        if (_this.priv != null) {
          payload = prefix_signature_payload(prefix, payload);
          __iced_deferrals = new iced.Deferrals(__iced_it, {
            parent: __iced_passed_deferral,
            funcname: "Pair::sign_kb",
            filename: "/home/runner/work/kbpgp/kbpgp/src/nacl/eddsa.iced"
          });
          _this.priv.sign({
            payload: payload,
            detached: detached
          }, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                return sig = arguments[0];
              };
            })(),
            lineno: 110
          }));
          if (__iced_deferrals.await_exit()) {
            yield;
          }
        } else {
          err = new Error("no secret key available");
        }
        return cb(err, sig);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  Pair.prototype.verify_kb = function(arg1, cb) {
    var detached, payload, prefix, sig;
    payload = arg1.payload, sig = arg1.sig, detached = arg1.detached, prefix = arg1.prefix;
    return this.pub.verify({
      payload: payload,
      sig: sig,
      detached: detached,
      prefix: prefix
    }, cb);
  };

  Pair.subkey_algo = function(flags) {
    if (flags & (C.key_flags.certify_keys | C.key_flags.sign_data)) {
      return Pair;
    } else {
      return NaclDh.Pair;
    }
  };

  Pair.prototype.fulfills_flags = function(flags) {
    var good_for;
    good_for = C.key_flags.certify_keys | C.key_flags.sign_data;
    return (flags & good_for) === flags;
  };

  Pair.prototype.verify_unpad_and_check_hash = function(arg1, cb) {
    var data, hash, hasher, sig;
    sig = arg1.sig, data = arg1.data, hasher = arg1.hasher, hash = arg1.hash;
    return cb(new Error("verify_unpad_and_check_hash unsupported"));
  };

  Pair.prototype.pad_and_sign = function(data, arg1, cb) {
    var hasher;
    hasher = arg1.hasher;
    return cb(new Error("pad_and_sign unsupported"));
  };

  Pair.parse_kb = function(pub_raw) {
    return BaseKeyPair.parse_kb(Pair, pub_raw);
  };

  Pair.parse_sig = function(slice) {
    var err;
    err = new Error("@parse_sig unsupported");
    throw err;
  };

  Pair.read_sig_from_buf = function(buf) {
    var err;
    err = new Error("@read_sig_from_buf unsupported");
    return [err];
  };

  Pair.import_private = function(arg1, cb) {
    var a, b, err, priv, pub, raw, ret;
    raw = arg1.raw;
    if ((a = raw.length) !== (b = kbnacl.sign.secretKeyLength)) {
      err = new Error("Bad length: expected " + b + "} bytes, but got " + a);
    } else {
      pub = new Pub(raw.slice(-kbnacl.sign.publicKeyLength));
      priv = new Priv(raw);
      ret = new Pair({
        priv: priv,
        pub: pub
      });
    }
    return cb(err, ret);
  };

  Pair.generate = function(arg1, cb) {
    var __iced_it, __iced_passed_deferral, arg, err, naclw, priv, pub, publicKey, ret, secretKey, seed, server_half, split;
    seed = arg1.seed, split = arg1.split, server_half = arg1.server_half;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function*() {
      var __iced_deferrals, ref1;
      arg = {
        seed: seed,
        split: split,
        len: kbnacl.sign.seedLength,
        server_half: server_half
      };
      __iced_deferrals = new iced.Deferrals(__iced_it, {
        parent: __iced_passed_deferral,
        funcname: "Pair::@generate",
        filename: "/home/runner/work/kbpgp/kbpgp/src/nacl/eddsa.iced"
      });
      genseed(arg, __iced_deferrals.defer({
        assign_fn: (function() {
          return function() {
            err = arguments[0];
            server_half = arguments[1].server_half;
            return seed = arguments[1].seed;
          };
        })(),
        lineno: 187
      }));
      if (__iced_deferrals.await_exit()) {
        yield;
      }
      ret = null;
      if (err == null) {
        naclw = kbnacl.alloc({});
        ref1 = naclw.genFromSeed({
          seed: seed
        }), secretKey = ref1.secretKey, publicKey = ref1.publicKey;
        pub = new Pub(publicKey);
        priv = new Priv(secretKey);
        ret = new Pair({
          pub: pub,
          priv: priv
        });
      }
      return cb(err, ret, server_half);
    })();
    __iced_it.next();
    return null;
  };

  return Pair;

})(BaseKeyPair);

exports.EdDSA = exports.Pair = Pair;

//# sourceMappingURL=eddsa.js.map
