// Generated by IcedCoffeeScript 112.8.1
var BaseKey, BaseKeyPair, K, NaclEddsa, Pair, Priv, Pub, SRF, TYPE, b2u, box, bufeq_fast, genseed, iced, konst, ref, u2b,
  extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty;

iced = require('iced-runtime-3');

box = require('tweetnacl').box;

SRF = require('../rand').SRF;

konst = require('../const');

K = konst.kb;

ref = require('../util'), genseed = ref.genseed, bufeq_fast = ref.bufeq_fast;

BaseKey = require('../basekeypair').BaseKey;

BaseKeyPair = require('./base').BaseKeyPair;

NaclEddsa = require('./eddsa');

TYPE = K.public_key_algorithms.NACL_DH;

b2u = function(b) {
  return new Uint8Array(b);
};

u2b = function(u) {
  return Buffer.from(u);
};

Pub = (function() {
  Pub.HEADER = Buffer.from([K.kid.version, TYPE]);

  Pub.TRAILER = Buffer.from([K.kid.trailer]);

  Pub.LEN = Pub.HEADER.length + Pub.TRAILER.length + box.publicKeyLength;

  function Pub(key1) {
    this.key = key1;
  }

  Pub.alloc_kb = function(kid) {
    var err, key;
    err = key = null;
    err = kid.length !== Pub.LEN ? new Error("bad key length") : !bufeq_fast(kid.slice(-1), Pub.TRAILER) ? new Error("bad trailing byte") : !bufeq_fast(kid.slice(0, 2), Pub.HEADER) ? new Error("bad header") : (key = new Pub(kid.slice(2, -1)), null);
    return [err, key];
  };

  Pub.prototype.serialize = function() {
    return this.key;
  };

  Pub.prototype.nbits = function() {
    return 255;
  };

  Pub.prototype.read_params = function(sb) {};

  Pub.prototype.encrypt = function(arg1, cb) {
    var __iced_it, __iced_passed_deferral, nonce, plaintext, sender;
    plaintext = arg1.plaintext, sender = arg1.sender, nonce = arg1.nonce;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var ciphertext, err, res, ret;
      return function*() {
        var __iced_deferrals;
        err = ret = null;
        if (nonce == null) {
          __iced_deferrals = new iced.Deferrals(__iced_it, {
            parent: __iced_passed_deferral,
            funcname: "Pub::encrypt",
            filename: "/home/runner/work/kbpgp/kbpgp/src/nacl/dh.iced"
          });
          SRF().random_bytes(box.nonceLength, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                return nonce = arguments[0];
              };
            })(),
            lineno: 51
          }));
          if (__iced_deferrals.await_exit()) {
            yield;
          }
        } else if (nonce.length !== box.nonceLength) {
          err = new Error("bad nonce; wrong length (wanted " + box.nonceLength + ")");
        }
        if (err == null) {
          res = box(b2u(plaintext), b2u(nonce), b2u(_this.key), b2u(sender.priv.key));
          ciphertext = u2b(res);
          ret = {
            ciphertext: ciphertext,
            nonce: nonce
          };
        }
        return cb(err, ret);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  return Pub;

})();

Priv = (function() {
  function Priv(key1) {
    this.key = key1;
  }

  Priv.prototype.alloc = function(raw) {
    var err, key;
    err = key = null;
    if (raw.length !== box.secretKeyLength) {
      err = new Error("Bad secret key length");
    } else {
      key = new Priv(raw);
    }
    return [err, key];
  };

  Priv.prototype.decrypt = function(arg1, cb) {
    var ciphertext, err, nonce, res, sender;
    ciphertext = arg1.ciphertext, nonce = arg1.nonce, sender = arg1.sender;
    err = res = null;
    res = box.open(b2u(ciphertext), b2u(nonce), b2u(sender.pub.key), b2u(this.key));
    if (res === null) {
      err = new Error("decryption failed");
      res = null;
    } else {
      res = u2b(res);
    }
    return cb(err, res);
  };

  return Priv;

})();

Pair = (function(superClass) {
  extend(Pair, superClass);

  Pair.Pub = Pub;

  Pair.prototype.Pub = Pub;

  Pair.Priv = Priv;

  Pair.prototype.Priv = Priv;

  function Pair(arg1) {
    var priv, pub;
    pub = arg1.pub, priv = arg1.priv;
    Pair.__super__.constructor.call(this, {
      pub: pub,
      priv: priv
    });
  }

  Pair.type = K.public_key_algorithms.NACL_DH;

  Pair.prototype.type = Pair.type;

  Pair.prototype.get_type = function() {
    return this.type;
  };

  Pair.klass_name = "DH";

  Pair.prototype.can_encrypt = function() {
    return true;
  };

  Pair.prototype.can_sign = function() {
    return false;
  };

  Pair.prototype.hash = function() {
    return this.serialize();
  };

  Pair.prototype.encrypt_kb = function(arg1, cb) {
    var nonce, plaintext, sender;
    plaintext = arg1.plaintext, sender = arg1.sender, nonce = arg1.nonce;
    return this.pub.encrypt({
      plaintext: plaintext,
      sender: sender,
      nonce: nonce
    }, cb);
  };

  Pair.prototype.decrypt_kb = function(arg1, cb) {
    var __iced_it, __iced_passed_deferral, ciphertext, nonce, sender;
    ciphertext = arg1.ciphertext, nonce = arg1.nonce, sender = arg1.sender;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var err, plaintex, plaintext;
      return function*() {
        var __iced_deferrals;
        err = plaintex = null;
        if (_this.priv != null) {
          __iced_deferrals = new iced.Deferrals(__iced_it, {
            parent: __iced_passed_deferral,
            funcname: "Pair::decrypt_kb",
            filename: "/home/runner/work/kbpgp/kbpgp/src/nacl/dh.iced"
          });
          _this.priv.decrypt({
            ciphertext: ciphertext,
            nonce: nonce,
            sender: sender
          }, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                return plaintext = arguments[1];
              };
            })(),
            lineno: 124
          }));
          if (__iced_deferrals.await_exit()) {
            yield;
          }
        } else {
          err = new Error("no secret key available");
        }
        return cb(err, plaintext);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  Pair.subkey_algo = function(flags) {
    if (flags & (C.key_flags.encrypt_comm | C.key_flags.encrypt_storage)) {
      return Pair;
    } else {
      return NaclEddsa.Pair;
    }
  };

  Pair.prototype.fulfills_flags = function(flags) {
    var good_for;
    good_for = C.key_flags.encrypt_comm | C.key_flags.encrypt_storage;
    return (flags & good_for) === flags;
  };

  Pair.prototype.verify_unpad_and_check_hash = function(arg1, cb) {
    var data, hash, hasher, sig;
    sig = arg1.sig, data = arg1.data, hasher = arg1.hasher, hash = arg1.hash;
    return cb(new Error("verify_unpad_and_check_hash unsupported"));
  };

  Pair.prototype.pad_and_sign = function(data, arg1, cb) {
    var hasher;
    hasher = arg1.hasher;
    return cb(new Error("pad_and_sign unsupported"));
  };

  Pair.parse_kb = function(pub_raw) {
    return BaseKeyPair.parse_kb(Pair, pub_raw);
  };

  Pair.parse_sig = function(slice) {
    var err;
    err = new Error("@parse_sig unsupported");
    throw err;
  };

  Pair.read_sig_from_buf = function(buf) {
    var err;
    err = new Error("@read_sig_from_buf unsupported");
    return [err];
  };

  Pair.generate = function(arg1, cb) {
    var __iced_it, __iced_passed_deferral, arg, err, priv, pub, publicKey, ret, secretKey, seed, server_half, split;
    server_half = arg1.server_half, seed = arg1.seed, split = arg1.split;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function*() {
      var __iced_deferrals, ref1;
      arg = {
        seed: seed,
        split: split,
        len: box.secretKeyLength,
        server_half: server_half
      };
      __iced_deferrals = new iced.Deferrals(__iced_it, {
        parent: __iced_passed_deferral,
        funcname: "Pair::@generate",
        filename: "/home/runner/work/kbpgp/kbpgp/src/nacl/dh.iced"
      });
      genseed(arg, __iced_deferrals.defer({
        assign_fn: (function() {
          return function() {
            err = arguments[0];
            server_half = arguments[1].server_half;
            return seed = arguments[1].seed;
          };
        })(),
        lineno: 185
      }));
      if (__iced_deferrals.await_exit()) {
        yield;
      }
      ret = null;
      if (err == null) {
        ref1 = box.keyPair.fromSecretKey(b2u(seed)), secretKey = ref1.secretKey, publicKey = ref1.publicKey;
        pub = new Pub(u2b(publicKey));
        priv = new Priv(u2b(secretKey));
        ret = new Pair({
          pub: pub,
          priv: priv
        });
      }
      return cb(err, ret, server_half);
    })();
    __iced_it.next();
    return null;
  };

  return Pair;

})(BaseKeyPair);

exports.DH = exports.Pair = Pair;

//# sourceMappingURL=dh.js.map
