// Generated by IcedCoffeeScript 112.8.1
var KeyFetcher, PgpKeyRing, hexkid,
  extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty;

KeyFetcher = require('./keyfetch').KeyFetcher;

hexkid = function(k) {
  return k.toString('hex');
};

PgpKeyRing = (function(superClass) {
  extend(PgpKeyRing, superClass);

  function PgpKeyRing() {
    this._keys = {};
    this._kms = {};
  }

  PgpKeyRing.prototype.add_key_manager = function(km) {
    var j, k, keys, kid, len, results;
    keys = km.export_pgp_keys_to_keyring();
    results = [];
    for (j = 0, len = keys.length; j < len; j++) {
      k = keys[j];
      kid = hexkid(k.key_material.get_key_id());
      this._keys[kid] = k;
      results.push(this._kms[kid] = km);
    }
    return results;
  };

  PgpKeyRing.prototype.fetch = function(key_ids, ops, cb) {
    var err, hex_key_ids, i, id, j, k, key_material, km, len, obj, ref, ret_i;
    key_material = err = obj = null;
    hex_key_ids = (function() {
      var j, len, results;
      results = [];
      for (j = 0, len = key_ids.length; j < len; j++) {
        k = key_ids[j];
        results.push(hexkid(k));
      }
      return results;
    })();
    km = null;
    for (i = j = 0, len = hex_key_ids.length; j < len; i = ++j) {
      id = hex_key_ids[i];
      k = this._keys[id];
      if (k != null ? (ref = k.key) != null ? ref.can_perform(ops) : void 0 : void 0) {
        ret_i = i;
        km = this._kms[id];
        break;
      }
    }
    if (km == null) {
      err = new Error("key not found: " + (JSON.stringify(hex_key_ids)));
    }
    if (km) {
      return km.fetch(key_ids, ops, cb);
    } else {
      return cb(err, km, ret_i);
    }
  };

  PgpKeyRing.prototype.find_best_key = function(arg, cb) {
    var err, flags, key, key_id, kid, km;
    key_id = arg.key_id, flags = arg.flags;
    if ((km = this._kms[(kid = hexkid(key_id))]) == null) {
      err = new Error("Could not find key for fingerprint " + kid);
    } else if ((key = km.find_best_pgp_key(flags)) == null) {
      err = new Error("no matching key for flags: " + flags);
    }
    return cb(err, key);
  };

  PgpKeyRing.prototype.lookup = function(key_id) {
    return this._keys[hexkid(key_id)];
  };

  return PgpKeyRing;

})(KeyFetcher);

exports.PgpKeyRing = PgpKeyRing;

exports.KeyRing = PgpKeyRing;

//# sourceMappingURL=keyring.js.map
