// Generated by IcedCoffeeScript 112.8.1
var C, K, Packet, Signature, eddsa, iced, konst, make_esc,
  extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty;

iced = require('iced-runtime-3');

konst = require('../../const');

K = konst.kb;

C = konst.openpgp;

Packet = require('./base').Packet;

make_esc = require('iced-error').make_esc;

eddsa = require('../../nacl/main').eddsa;

Signature = (function(superClass) {
  extend(Signature, superClass);

  Signature.SIG_TYPE = K.public_key_algorithms.NACL_EDDSA;

  Signature.HASH_TYPE = C.hash_algorithms.SHA512;

  Signature.tag = function() {
    return K.packet_tags.signature;
  };

  Signature.prototype.tag = function() {
    return Signature.tag();
  };

  function Signature(arg) {
    var prefix;
    this.key = arg.key, this.payload = arg.payload, this.sig = arg.sig, this.detached = arg.detached, prefix = arg.prefix;
    if (prefix != null) {
      this.prefix = prefix;
    }
    Signature.__super__.constructor.call(this);
  }

  Signature.prototype.get_packet_body = function() {
    var hash_type, ret, sig_type;
    sig_type = Signature.SIG_TYPE;
    hash_type = Signature.HASH_TYPE;
    ret = {
      key: this.key,
      payload: this.payload,
      sig: this.sig,
      detached: this.detached,
      sig_type: sig_type,
      hash_type: hash_type
    };
    if (this.prefix != null) {
      ret.prefix = this.prefix;
    }
    return ret;
  };

  Signature.alloc = function(arg) {
    var a, b, body, err, ret, tag;
    tag = arg.tag, body = arg.body;
    ret = null;
    err = tag !== Signature.tag() ? new Error("wrong tag found: " + tag) : (a = body.hash_type) !== (b = Signature.HASH_TYPE) ? new Error("Expected SHA512 (type " + b + "); got " + a) : (a = body.sig_type) !== (b = Signature.SIG_TYPE) ? err = new Error("Expected EDDSA (type " + b + "); got " + a) : (ret = new Signature(body), null);
    if (err != null) {
      throw err;
    }
    return ret;
  };

  Signature.prototype.is_signature = function() {
    return true;
  };

  Signature.prototype.verify = function(cb) {
    var __iced_it, __iced_passed_deferral;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var err, esc, km, pair;
      return function*() {
        var __iced_deferrals, ref;
        esc = make_esc(cb, "verify");
        err = km = null;
        ref = eddsa.Pair.parse_kb(_this.key), err = ref[0], pair = ref[1];
        if (err == null) {
          __iced_deferrals = new iced.Deferrals(__iced_it, {
            parent: __iced_passed_deferral,
            funcname: "Signature::verify",
            filename: "/home/runner/work/kbpgp/kbpgp/src/keybase/packet/signature.iced"
          });
          pair.verify_kb(_this, esc(__iced_deferrals.defer({
            lineno: 61
          })));
          if (__iced_deferrals.await_exit()) {
            yield;
          }
        }
        return cb(err, {
          keypair: pair,
          payload: _this.payload
        });
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  Signature.prototype.unbox = function(params, cb) {
    var __iced_it, __iced_passed_deferral;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var err, res;
      return function*() {
        var __iced_deferrals;
        __iced_deferrals = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "Signature::unbox",
          filename: "/home/runner/work/kbpgp/kbpgp/src/keybase/packet/signature.iced"
        });
        _this.verify(__iced_deferrals.defer({
          assign_fn: (function() {
            return function() {
              err = arguments[0];
              return res = arguments[1];
            };
          })(),
          lineno: 67
        }));
        if (__iced_deferrals.await_exit()) {
          yield;
        }
        return cb(err, res);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  Signature.box = function(arg, cb) {
    var __iced_it, __iced_passed_deferral, detached, esc, km, packet, pair, payload, prefix, sig;
    km = arg.km, prefix = arg.prefix, payload = arg.payload;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function*() {
      var __iced_deferrals;
      esc = make_esc(cb, "@sign");
      pair = km.get_keypair();
      detached = true;
      __iced_deferrals = new iced.Deferrals(__iced_it, {
        parent: __iced_passed_deferral,
        funcname: "Signature::@box",
        filename: "/home/runner/work/kbpgp/kbpgp/src/keybase/packet/signature.iced"
      });
      pair.sign_kb({
        payload: payload,
        prefix: prefix,
        detached: detached
      }, esc(__iced_deferrals.defer({
        assign_fn: (function() {
          return function() {
            return sig = arguments[0];
          };
        })(),
        lineno: 76
      })));
      if (__iced_deferrals.await_exit()) {
        yield;
      }
      packet = new Signature({
        key: pair.ekid(),
        payload: payload,
        sig: sig,
        detached: detached,
        prefix: prefix
      });
      return cb(null, packet);
    })();
    __iced_it.next();
    return null;
  };

  return Signature;

})(Packet);

exports.Signature = Signature;

exports.sign = Signature.sign;

//# sourceMappingURL=signature.js.map
