// Generated by IcedCoffeeScript 112.8.1
var Decryptor, K, P3SKB, Packet, SHA512, box, bufeq_secure, bufferify, iced, make_esc, native_rng, pack, ref, ref1, rsa, triplesec,
  extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty;

iced = require('iced-runtime-3');

K = require('../../const').kb;

triplesec = require('triplesec');

SHA512 = require('../../hash').SHA512;

Decryptor = triplesec.Decryptor;

native_rng = triplesec.prng.native_rng;

Packet = require('./base').Packet;

ref = require('../encode'), pack = ref.pack, box = ref.box;

make_esc = require('iced-error').make_esc;

rsa = require('../../rsa');

ref1 = require('../../util'), bufeq_secure = ref1.bufeq_secure, bufferify = ref1.bufferify;

P3SKB = (function(superClass) {
  extend(P3SKB, superClass);

  P3SKB.tag = function() {
    return K.packet_tags.p3skb;
  };

  P3SKB.prototype.tag = function() {
    return P3SKB.tag();
  };

  function P3SKB(arg) {
    var priv, priv_clear;
    this.pub = arg.pub, priv_clear = arg.priv_clear, priv = arg.priv, this.type = arg.type;
    P3SKB.__super__.constructor.call(this);
    this.priv = priv != null ? priv : priv_clear != null ? {
      data: priv_clear,
      encryption: K.key_encryption.none
    } : void 0;
  }

  P3SKB.prototype.get_packet_body = function() {
    var ret;
    ret = {
      pub: this.pub,
      priv: this.priv
    };
    if (this.type != null) {
      ret.type = this.type;
    }
    return ret;
  };

  P3SKB.prototype.lock = function(arg, cb) {
    var __iced_it, __iced_passed_deferral, asp, passphrase_generation, tsenc;
    asp = arg.asp, tsenc = arg.tsenc, passphrase_generation = arg.passphrase_generation;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var ct, err;
      return function*() {
        var __iced_deferrals;
        __iced_deferrals = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "P3SKB::lock",
          filename: "/home/runner/work/kbpgp/kbpgp/src/keybase/packet/p3skb.iced"
        });
        tsenc.run({
          data: _this.priv.data,
          progress_hook: asp != null ? asp.progress_hook() : void 0
        }, __iced_deferrals.defer({
          assign_fn: (function() {
            return function() {
              err = arguments[0];
              return ct = arguments[1];
            };
          })(),
          lineno: 30
        }));
        if (__iced_deferrals.await_exit()) {
          yield;
        }
        if (err == null) {
          _this.priv.data = ct;
          _this.priv.encryption = K.key_encryption.triplesec_v3;
          if (passphrase_generation != null) {
            _this.priv.passphrase_generation = passphrase_generation;
          }
        }
        return cb(err);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  P3SKB.prototype.unlock = function(arg, cb) {
    var __iced_it, __iced_passed_deferral, asp, passphrase_generation, tsenc;
    asp = arg.asp, tsenc = arg.tsenc, passphrase_generation = arg.passphrase_generation;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var a, b, dec, err, progress_hook, raw;
      return function*() {
        var __iced_deferrals;
        switch (_this.priv.encryption) {
          case K.key_encryption.triplesec_v3:
          case K.key_encryption.triplesec_v2:
          case K.key_encryption.triplesec_v1:
            dec = new Decryptor({
              enc: tsenc
            });
            progress_hook = asp != null ? asp.progress_hook() : void 0;
            __iced_deferrals = new iced.Deferrals(__iced_it, {
              parent: __iced_passed_deferral,
              funcname: "P3SKB::unlock",
              filename: "/home/runner/work/kbpgp/kbpgp/src/keybase/packet/p3skb.iced"
            });
            dec.run({
              data: _this.priv.data,
              progress_hook: progress_hook
            }, __iced_deferrals.defer({
              assign_fn: (function() {
                return function() {
                  err = arguments[0];
                  return raw = arguments[1];
                };
              })(),
              lineno: 42
            }));
            if (__iced_deferrals.await_exit()) {
              yield;
            }
            dec.scrub();
            if (err == null) {
              _this.priv.data = raw;
              _this.priv.encryption = K.key_encryption.none;
            } else if (((a = passphrase_generation) != null) && ((b = _this.priv.passphrase_generation) != null) && (a !== b)) {
              err = new Error("Decryption failed, likely due to old passphrase (wanted v" + a + " but got v" + b + ") [" + (err.toString()) + "]");
            }
            break;
          case K.key_encryption.none:
            break;
          default:
            err = new Error("Unknown key encryption type: " + k.encryption);
        }
        return cb(err);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  P3SKB.alloc = function(arg) {
    var body, tag;
    tag = arg.tag, body = arg.body;
    if (tag === P3SKB.tag()) {
      return new P3SKB(body);
    } else {
      throw new Error("wrong tag found: " + tag);
    }
  };

  P3SKB.prototype.has_private = function() {
    return this.priv != null;
  };

  P3SKB.prototype.is_locked = function() {
    return this.priv.encryption !== K.key_encryption.none;
  };

  P3SKB.prototype.get_private_data = function() {
    var ref2;
    return (ref2 = this.priv) != null ? ref2.data : void 0;
  };

  P3SKB.prototype.get_public_data = function() {
    return this.pub;
  };

  P3SKB.prototype.get_key_type = function() {
    return this.type;
  };

  P3SKB.prototype.is_p3skb = function() {
    return true;
  };

  return P3SKB;

})(Packet);

exports.P3SKB = P3SKB;

//# sourceMappingURL=p3skb.js.map
