// Generated by IcedCoffeeScript 112.8.1
var C, Encryption, K, Packet, dh, iced, konst, make_esc,
  extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty;

iced = require('iced-runtime-3');

konst = require('../../const');

K = konst.kb;

C = konst.openpgp;

Packet = require('./base').Packet;

make_esc = require('iced-error').make_esc;

dh = require('../../nacl/main').dh;

Encryption = (function(superClass) {
  extend(Encryption, superClass);

  Encryption.ENC_TYPE = K.public_key_algorithms.NACL_DH;

  Encryption.tag = function() {
    return K.packet_tags.encryption;
  };

  Encryption.prototype.tag = function() {
    return Encryption.tag();
  };

  function Encryption(arg) {
    this.encrypt_for = arg.encrypt_for, this.sign_with = arg.sign_with, this.plaintext = arg.plaintext, this.ciphertext = arg.ciphertext, this.sender_key = arg.sender_key, this.nonce = arg.nonce, this.anonymous = arg.anonymous;
    Encryption.__super__.constructor.call(this);
    this.ephemeral = false;
  }

  Encryption.prototype.get_packet_body = function() {
    var enc_type;
    enc_type = Encryption.ENC_TYPE;
    return {
      sender_key: this.sender_key,
      ciphertext: this.ciphertext,
      nonce: this.nonce,
      enc_type: enc_type,
      receiver_key: this.receiver_key
    };
  };

  Encryption.alloc = function(arg) {
    var a, b, body, err, ret, tag;
    tag = arg.tag, body = arg.body;
    ret = null;
    err = tag !== Encryption.tag() ? new Error("wrong tag found: " + tag) : (a = body.enc_type) !== (b = Encryption.ENC_TYPE) ? err = new Error("Expected Curve25519 DH (type " + b + "); got " + a) : (ret = new Encryption(body), null);
    if (err != null) {
      throw err;
    }
    return ret;
  };

  Encryption.prototype.is_signature = function() {
    return false;
  };

  Encryption.prototype.get_sender_keypair = function(arg, cb) {
    var __iced_it, __iced_passed_deferral, encrypt, sign_with;
    sign_with = arg.sign_with, encrypt = arg.encrypt;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var err, ret;
      return function*() {
        var __iced_deferrals, ref;
        err = ret = null;
        if (sign_with != null) {
          ret = sign_with.get_keypair();
        } else if (_this.sign_with != null) {
          ret = _this.sign_with.get_keypair();
        } else if (_this.sender_keypair != null) {
          ret = _this.sender_keypair;
        } else if (encrypt) {
          __iced_deferrals = new iced.Deferrals(__iced_it, {
            parent: __iced_passed_deferral,
            funcname: "Encryption::get_sender_keypair",
            filename: "/home/runner/work/kbpgp/kbpgp/src/keybase/packet/encryption.iced"
          });
          dh.Pair.generate({}, __iced_deferrals.defer({
            assign_fn: (function(__slot_1) {
              return function() {
                err = arguments[0];
                return __slot_1.sender_keypair = arguments[1];
              };
            })(_this),
            lineno: 56
          }));
          if (__iced_deferrals.await_exit()) {
            yield;
          }
          ret = _this.sender_keypair;
          _this.ephemeral = true;
        } else if (_this.sender_key != null) {
          ref = dh.Pair.parse_kb(_this.sender_key), err = ref[0], _this.sender_keypair = ref[1];
          if (err == null) {
            ret = _this.sender_keypair;
          }
        } else {
          err = new Error("Cannot encrypt without a sender keypair");
        }
        return cb(err, ret);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  Encryption.prototype.encrypt = function(params, cb) {
    var __iced_it, __iced_passed_deferral;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var esc, recvr, sender;
      return function*() {
        var __iced_deferrals, __iced_deferrals1;
        esc = make_esc(cb, "encrypt");
        __iced_deferrals = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "Encryption::encrypt",
          filename: "/home/runner/work/kbpgp/kbpgp/src/keybase/packet/encryption.iced"
        });
        _this.get_sender_keypair({
          encrypt: true
        }, esc(__iced_deferrals.defer({
          assign_fn: (function() {
            return function() {
              return sender = arguments[0];
            };
          })(),
          lineno: 71
        })));
        if (__iced_deferrals.await_exit()) {
          yield;
        }
        recvr = _this.encrypt_for.get_keypair();
        __iced_deferrals1 = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "Encryption::encrypt",
          filename: "/home/runner/work/kbpgp/kbpgp/src/keybase/packet/encryption.iced"
        });
        recvr.encrypt_kb({
          plaintext: _this.plaintext,
          sender: sender,
          nonce: _this.nonce
        }, esc(__iced_deferrals1.defer({
          assign_fn: (function(__slot_1, __slot_2) {
            return function() {
              __slot_1.ciphertext = arguments[0].ciphertext;
              return __slot_2.nonce = arguments[0].nonce;
            };
          })(_this, _this),
          lineno: 73
        })));
        if (__iced_deferrals1.await_exit()) {
          yield;
        }
        if (!(_this.anonymous && !_this.ephemeral)) {
          _this.sender_key = sender.ekid();
        }
        if (!_this.anonymous) {
          _this.receiver_key = recvr.ekid();
        }
        return cb(null);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  Encryption.prototype.decrypt = function(arg, cb) {
    var __iced_it, __iced_passed_deferral, encrypt_for, sign_with;
    sign_with = arg.sign_with, encrypt_for = arg.encrypt_for;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var args, esc, recvr, sender;
      return function*() {
        var __iced_deferrals, __iced_deferrals1;
        esc = make_esc(cb, "decrypt");
        __iced_deferrals = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "Encryption::decrypt",
          filename: "/home/runner/work/kbpgp/kbpgp/src/keybase/packet/encryption.iced"
        });
        _this.get_sender_keypair({
          sign_with: sign_with
        }, esc(__iced_deferrals.defer({
          assign_fn: (function() {
            return function() {
              return sender = arguments[0];
            };
          })(),
          lineno: 82
        })));
        if (__iced_deferrals.await_exit()) {
          yield;
        }
        args = {
          ciphertext: _this.ciphertext,
          nonce: _this.nonce,
          sender: sender
        };
        recvr = encrypt_for.get_keypair();
        __iced_deferrals1 = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "Encryption::decrypt",
          filename: "/home/runner/work/kbpgp/kbpgp/src/keybase/packet/encryption.iced"
        });
        recvr.decrypt_kb(args, esc(__iced_deferrals1.defer({
          assign_fn: (function(__slot_1) {
            return function() {
              return __slot_1.plaintext = arguments[0];
            };
          })(_this),
          lineno: 85
        })));
        if (__iced_deferrals1.await_exit()) {
          yield;
        }
        return cb(null, {
          sender_keypair: sender,
          plaintext: _this.plaintext,
          receiver_keypair: recvr
        });
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  Encryption.prototype.unbox = function(arg, cb) {
    var __iced_it, __iced_passed_deferral, encrypt_for;
    encrypt_for = arg.encrypt_for;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var err, res;
      return function*() {
        var __iced_deferrals;
        __iced_deferrals = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "Encryption::unbox",
          filename: "/home/runner/work/kbpgp/kbpgp/src/keybase/packet/encryption.iced"
        });
        _this.decrypt({
          encrypt_for: encrypt_for
        }, __iced_deferrals.defer({
          assign_fn: (function() {
            return function() {
              err = arguments[0];
              return res = arguments[1];
            };
          })(),
          lineno: 91
        }));
        if (__iced_deferrals.await_exit()) {
          yield;
        }
        return cb(err, res);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  Encryption.box = function(arg, cb) {
    var __iced_it, __iced_passed_deferral, anonymous, encrypt_for, err, nonce, packet, plaintext, sign_with;
    sign_with = arg.sign_with, encrypt_for = arg.encrypt_for, plaintext = arg.plaintext, anonymous = arg.anonymous, nonce = arg.nonce;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function*() {
      var __iced_deferrals;
      packet = new Encryption({
        sign_with: sign_with,
        encrypt_for: encrypt_for,
        plaintext: plaintext,
        anonymous: anonymous,
        nonce: nonce
      });
      __iced_deferrals = new iced.Deferrals(__iced_it, {
        parent: __iced_passed_deferral,
        funcname: "Encryption::@box",
        filename: "/home/runner/work/kbpgp/kbpgp/src/keybase/packet/encryption.iced"
      });
      packet.encrypt({}, __iced_deferrals.defer({
        assign_fn: (function() {
          return function() {
            return err = arguments[0];
          };
        })(),
        lineno: 98
      }));
      if (__iced_deferrals.await_exit()) {
        yield;
      }
      if (err != null) {
        packet = null;
      }
      return cb(err, packet);
    })();
    __iced_it.next();
    return null;
  };

  return Encryption;

})(Packet);

exports.Encryption = Encryption;

//# sourceMappingURL=encryption.js.map
