// Generated by IcedCoffeeScript 112.8.1
var C, DH, EdDSA, EncKeyManager, Encryption, K, KeyManager, KeyManagerInterface, Signature, SignatureEngine, SignatureEngineInterface, akatch, alloc, asyncify, athrow, base64u, box, buffer_xor, bufferify, decode_sig, encode, errors, get_sig_body, iced, konst, make_esc, ref, ref1, unbox, unbox_decode, verify,
  extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty,
  indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; };

iced = require('iced-runtime-3');

ref = require('../kmi'), SignatureEngineInterface = ref.SignatureEngineInterface, KeyManagerInterface = ref.KeyManagerInterface;

make_esc = require('iced-error').make_esc;

encode = require('./encode');

ref1 = require('../util'), athrow = ref1.athrow, bufferify = ref1.bufferify, base64u = ref1.base64u, buffer_xor = ref1.buffer_xor, asyncify = ref1.asyncify, akatch = ref1.akatch;

konst = require('../const');

alloc = require('./packet/alloc').alloc;

Signature = require('./packet/signature').Signature;

Encryption = require('./packet/encryption').Encryption;

EdDSA = require('../nacl/eddsa').EdDSA;

errors = require('../errors').errors;

DH = require('../nacl/dh').DH;

K = konst.kb;

C = konst.openpgp;

KeyManager = (function(superClass) {
  extend(KeyManager, superClass);

  function KeyManager(arg1) {
    this.key = arg1.key, this.server_half = arg1.server_half;
  }

  KeyManager.generate = function(arg1, cb) {
    var __iced_it, __iced_passed_deferral, algo, err, key, klass, seed, server_half, split;
    algo = arg1.algo, seed = arg1.seed, split = arg1.split, server_half = arg1.server_half, klass = arg1.klass;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function*() {
      var __iced_deferrals;
      algo || (algo = EdDSA);
      klass || (klass = KeyManager);
      __iced_deferrals = new iced.Deferrals(__iced_it, {
        parent: __iced_passed_deferral,
        funcname: "KeyManager::@generate",
        filename: "/home/runner/work/kbpgp/kbpgp/src/keybase/hilev.iced"
      });
      algo.generate({
        split: split,
        seed: seed,
        server_half: server_half
      }, __iced_deferrals.defer({
        assign_fn: (function() {
          return function() {
            err = arguments[0];
            key = arguments[1];
            return server_half = arguments[2];
          };
        })(),
        lineno: 30
      }));
      if (__iced_deferrals.await_exit()) {
        yield;
      }
      return cb(err, new klass({
        key: key,
        server_half: server_half
      }));
    })();
    __iced_it.next();
    return null;
  };

  KeyManager.prototype.get_mask = function() {
    return C.key_flags.sign_data | C.key_flags.certify_keys | C.key_flags.auth;
  };

  KeyManager.prototype.fetch = function(key_ids, flags, cb) {
    var err, key, mask, s;
    s = this.key.ekid().toString('hex');
    key = null;
    mask = this.get_mask();
    if ((indexOf.call(key_ids, s) >= 0) && (flags & mask) === flags) {
      key = this.key;
    } else {
      err = new Error("Key not found");
    }
    return cb(err, key);
  };

  KeyManager.prototype.get_keypair = function() {
    return this.key;
  };

  KeyManager.prototype.get_primary_keypair = function() {
    return this.key;
  };

  KeyManager.prototype.can_verify = function() {
    return true;
  };

  KeyManager.prototype.can_sign = function() {
    var ref2;
    return (ref2 = this.key) != null ? ref2.can_sign() : void 0;
  };

  KeyManager.prototype.eq = function(km2) {
    return this.key.eq(km2.key);
  };

  KeyManager.import_private = function(arg1, cb) {
    var __iced_it, __iced_passed_deferral, e, err, hex, key, raw, ret;
    hex = arg1.hex, raw = arg1.raw;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function*() {
      var __iced_deferrals;
      err = ret = null;
      if (hex != null) {
        try {
          raw = Buffer.from(hex, 'hex');
        } catch (error) {
          e = error;
          return cb(e);
        }
      }
      __iced_deferrals = new iced.Deferrals(__iced_it, {
        parent: __iced_passed_deferral,
        funcname: "KeyManager::@import_private",
        filename: "/home/runner/work/kbpgp/kbpgp/src/keybase/hilev.iced"
      });
      EdDSA.import_private({
        raw: raw
      }, __iced_deferrals.defer({
        assign_fn: (function() {
          return function() {
            err = arguments[0];
            return key = arguments[1];
          };
        })(),
        lineno: 69
      }));
      if (__iced_deferrals.await_exit()) {
        yield;
      }
      if (err == null) {
        ret = new KeyManager({
          key: key
        });
      }
      return cb(err, ret);
    })();
    __iced_it.next();
    return null;
  };

  KeyManager.import_public = function(arg1, cb) {
    var __iced_it, __iced_passed_deferral, e, err, hex, key, raw, ret;
    hex = arg1.hex, raw = arg1.raw;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function*() {
      var __iced_deferrals, ref2;
      err = ret = null;
      if (hex != null) {
        try {
          raw = Buffer.from(hex, 'hex');
        } catch (error) {
          e = error;
          return cb(e);
        }
      }
      ref2 = EdDSA.parse_kb(raw), err = ref2[0], key = ref2[1];
      if (err != null) {
        __iced_deferrals = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "KeyManager::@import_public",
          filename: "/home/runner/work/kbpgp/kbpgp/src/keybase/hilev.iced"
        });
        EncKeyManager.import_public({
          raw: raw
        }, __iced_deferrals.defer({
          assign_fn: (function() {
            return function() {
              err = arguments[0];
              return ret = arguments[1];
            };
          })(),
          lineno: 84
        }));
        if (__iced_deferrals.await_exit()) {
          yield;
        }
      } else {
        ret = new KeyManager({
          key: key
        });
      }
      return cb(err, ret);
    })();
    __iced_it.next();
    return null;
  };

  KeyManager.prototype.check_public_eq = function(km2) {
    return this.eq(km2);
  };

  KeyManager.prototype.export_public = function(arg1, cb) {
    var asp, regen, ret;
    asp = arg1.asp, regen = arg1.regen;
    ret = this.key.ekid().toString('hex');
    return cb(null, ret);
  };

  KeyManager.prototype.export_private = function(arg1, cb) {
    var __iced_it, __iced_passed_deferral, asp, p3skb, passphrase;
    asp = arg1.asp, p3skb = arg1.p3skb, passphrase = arg1.passphrase;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var err, res;
      return function*() {
        var __iced_deferrals;
        err = res = null;
        if (p3skb) {
          err = new Error("No support yet for P3SKB encrypted secret key exports");
        } else {
          __iced_deferrals = new iced.Deferrals(__iced_it, {
            parent: __iced_passed_deferral,
            funcname: "KeyManager::export_private",
            filename: "/home/runner/work/kbpgp/kbpgp/src/keybase/hilev.iced"
          });
          _this.key.export_secret_key_kb({}, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                return res = arguments[1];
              };
            })(),
            lineno: 106
          }));
          if (__iced_deferrals.await_exit()) {
            yield;
          }
        }
        return cb(err, res);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  KeyManager.prototype.export_server_half = function() {
    var ref2;
    return (ref2 = this.server_half) != null ? ref2.toString('hex') : void 0;
  };

  KeyManager.prototype.get_ekid = function() {
    return this.get_keypair().ekid();
  };

  KeyManager.prototype.get_fp2 = function() {
    return this.get_ekid();
  };

  KeyManager.prototype.get_fp2_formatted = function() {
    return base64u.encode(this.get_fp2());
  };

  KeyManager.prototype.get_type = function() {
    return "kb";
  };

  KeyManager.prototype.make_sig_eng = function() {
    return new SignatureEngine({
      km: this
    });
  };

  KeyManager.prototype.verify_raw = function(arg1, cb) {
    var payload, prefix, ref2, sig;
    sig = arg1.sig, payload = arg1.payload, prefix = arg1.prefix;
    return (new Signature({
      key: (ref2 = this.key) != null ? ref2.ekid() : void 0,
      payload: payload,
      prefix: prefix,
      sig: sig,
      detached: true
    })).verify(cb);
  };

  return KeyManager;

})(KeyManagerInterface);

EncKeyManager = (function(superClass) {
  extend(EncKeyManager, superClass);

  function EncKeyManager() {
    return EncKeyManager.__super__.constructor.apply(this, arguments);
  }

  EncKeyManager.generate = function(params, cb) {
    params.algo = DH;
    params.klass = EncKeyManager;
    return KeyManager.generate(params, cb);
  };

  EncKeyManager.prototype.make_sig_eng = function() {
    return null;
  };

  EncKeyManager.prototype.can_sign = function() {
    return false;
  };

  EncKeyManager.prototype.can_verify = function() {
    return false;
  };

  EncKeyManager.prototype.can_encrypt = function() {
    return true;
  };

  EncKeyManager.prototype.can_decrypt = function() {
    var ref2;
    return ((ref2 = this.key) != null ? ref2.priv : void 0) != null;
  };

  EncKeyManager.import_private = function(arg1, cb) {
    var __iced_it, __iced_passed_deferral, e, err, hex, km, raw, ret;
    hex = arg1.hex, raw = arg1.raw;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function*() {
      var __iced_deferrals;
      err = ret = null;
      if (hex != null) {
        try {
          raw = Buffer.from(hex, 'hex');
        } catch (error) {
          e = error;
          return cb(e);
        }
      }
      __iced_deferrals = new iced.Deferrals(__iced_it, {
        parent: __iced_passed_deferral,
        funcname: "EncKeyManager::@import_private",
        filename: "/home/runner/work/kbpgp/kbpgp/src/keybase/hilev.iced"
      });
      EncKeyManager.generate({
        seed: raw
      }, __iced_deferrals.defer({
        assign_fn: (function() {
          return function() {
            err = arguments[0];
            return km = arguments[1];
          };
        })(),
        lineno: 158
      }));
      if (__iced_deferrals.await_exit()) {
        yield;
      }
      return cb(err, km);
    })();
    __iced_it.next();
    return null;
  };

  EncKeyManager.prototype.get_mask = function() {
    return C.key_flags.encrypt_comm | C.key_flags.encrypt_storage;
  };

  EncKeyManager.import_public = function(arg1, cb) {
    var e, err, hex, key, raw, ref2, ret;
    hex = arg1.hex, raw = arg1.raw;
    err = ret = null;
    if (hex != null) {
      try {
        raw = Buffer.from(hex, 'hex');
      } catch (error) {
        e = error;
        return cb(e);
      }
    }
    ref2 = DH.parse_kb(raw), err = ref2[0], key = ref2[1];
    if (err == null) {
      ret = new EncKeyManager({
        key: key
      });
    }
    return cb(err, ret);
  };

  return EncKeyManager;

})(KeyManager);

unbox_decode = function(arg1) {
  var armored, binary, e, err, rawobj, ref2, require_packet_hash, ret;
  armored = arg1.armored, binary = arg1.binary, rawobj = arg1.rawobj, require_packet_hash = arg1.require_packet_hash;
  err = ret = null;
  if ((armored == null) && (rawobj == null) && (binary == null)) {
    err = new Error("need either 'armored' or 'binary' or 'rawobj'");
    return [err, null];
  }
  if (armored != null) {
    binary = Buffer.from(armored, 'base64');
  }
  if (binary != null) {
    try {
      rawobj = encode.unseal(binary, {
        strict: require_packet_hash
      });
    } catch (error) {
      e = error;
      return [e, null];
    }
  }
  ref2 = alloc(rawobj), err = ref2[0], ret = ref2[1];
  return [err, ret, binary];
};

unbox = function(arg1, cb) {
  var __iced_it, __iced_passed_deferral, armored, binary, encrypt_for, esc, packet, prefix, rawobj, require_packet_hash, res;
  armored = arg1.armored, binary = arg1.binary, rawobj = arg1.rawobj, encrypt_for = arg1.encrypt_for, prefix = arg1.prefix, require_packet_hash = arg1.require_packet_hash;
  __iced_passed_deferral = iced.findDeferral(arguments);
  __iced_it = (function*() {
    var __iced_deferrals, __iced_deferrals1;
    esc = make_esc(cb, "unbox");
    __iced_deferrals = new iced.Deferrals(__iced_it, {
      parent: __iced_passed_deferral,
      funcname: "unbox",
      filename: "/home/runner/work/kbpgp/kbpgp/src/keybase/hilev.iced"
    });
    asyncify(unbox_decode({
      armored: armored,
      binary: binary,
      rawobj: rawobj,
      require_packet_hash: require_packet_hash
    }), esc(__iced_deferrals.defer({
      assign_fn: (function() {
        return function() {
          packet = arguments[0];
          return binary = arguments[1];
        };
      })(),
      lineno: 201
    })));
    if (__iced_deferrals.await_exit()) {
      yield;
    }
    if (prefix != null) {
      packet.prefix = prefix;
    }
    __iced_deferrals1 = new iced.Deferrals(__iced_it, {
      parent: __iced_passed_deferral,
      funcname: "unbox",
      filename: "/home/runner/work/kbpgp/kbpgp/src/keybase/hilev.iced"
    });
    packet.unbox({
      encrypt_for: encrypt_for
    }, esc(__iced_deferrals1.defer({
      assign_fn: (function() {
        return function() {
          return res = arguments[0];
        };
      })(),
      lineno: 203
    })));
    if (__iced_deferrals1.await_exit()) {
      yield;
    }
    if (res.keypair != null) {
      res.km = new KeyManager({
        key: res.keypair
      });
    }
    if (res.sender_keypair != null) {
      res.sender_km = new KeyManager({
        key: res.sender_keypair
      });
    }
    if (res.receiver_keypair != null) {
      res.receiver_km = new KeyManager({
        key: res.receiver_keypair
      });
    }
    return cb(null, res, binary);
  })();
  __iced_it.next();
  return null;
};

box = function(arg1, cb) {
  var __iced_it, __iced_passed_deferral, anonymous, armored, dohash, encrypt_for, esc, msg, nonce, packed, packet, prefix, sealed, sign_with;
  msg = arg1.msg, sign_with = arg1.sign_with, encrypt_for = arg1.encrypt_for, anonymous = arg1.anonymous, nonce = arg1.nonce, prefix = arg1.prefix, dohash = arg1.dohash;
  __iced_passed_deferral = iced.findDeferral(arguments);
  __iced_it = (function*() {
    var __iced_deferrals, __iced_deferrals1;
    esc = make_esc(cb, "box");
    msg = bufferify(msg);
    if (encrypt_for != null) {
      __iced_deferrals = new iced.Deferrals(__iced_it, {
        parent: __iced_passed_deferral,
        funcname: "box",
        filename: "/home/runner/work/kbpgp/kbpgp/src/keybase/hilev.iced"
      });
      Encryption.box({
        sign_with: sign_with,
        encrypt_for: encrypt_for,
        plaintext: msg,
        anonymous: anonymous,
        nonce: nonce
      }, esc(__iced_deferrals.defer({
        assign_fn: (function() {
          return function() {
            return packet = arguments[0];
          };
        })(),
        lineno: 220
      })));
      if (__iced_deferrals.await_exit()) {
        yield;
      }
    } else {
      __iced_deferrals1 = new iced.Deferrals(__iced_it, {
        parent: __iced_passed_deferral,
        funcname: "box",
        filename: "/home/runner/work/kbpgp/kbpgp/src/keybase/hilev.iced"
      });
      Signature.box({
        km: sign_with,
        payload: msg,
        prefix: prefix
      }, esc(__iced_deferrals1.defer({
        assign_fn: (function() {
          return function() {
            return packet = arguments[0];
          };
        })(),
        lineno: 222
      })));
      if (__iced_deferrals1.await_exit()) {
        yield;
      }
    }
    packed = packet.frame_packet();
    dohash || (dohash = false);
    sealed = encode.seal({
      obj: packed,
      dohash: dohash
    });
    armored = sealed.toString('base64');
    return cb(null, armored, sealed, packet.sig);
  })();
  __iced_it.next();
  return null;
};

verify = function(arg1, cb) {
  var __iced_it, __iced_passed_deferral, armored, binary, err, esc, kid, km, require_packet_hash, res;
  armored = arg1.armored, binary = arg1.binary, kid = arg1.kid, require_packet_hash = arg1.require_packet_hash;
  __iced_passed_deferral = iced.findDeferral(arguments);
  __iced_it = (function*() {
    var __iced_deferrals, __iced_deferrals1;
    esc = make_esc(cb);
    err = null;
    __iced_deferrals = new iced.Deferrals(__iced_it, {
      parent: __iced_passed_deferral,
      funcname: "verify",
      filename: "/home/runner/work/kbpgp/kbpgp/src/keybase/hilev.iced"
    });
    KeyManager.import_public({
      hex: kid
    }, esc(__iced_deferrals.defer({
      assign_fn: (function() {
        return function() {
          return km = arguments[0];
        };
      })(),
      lineno: 234
    })));
    if (__iced_deferrals.await_exit()) {
      yield;
    }
    __iced_deferrals1 = new iced.Deferrals(__iced_it, {
      parent: __iced_passed_deferral,
      funcname: "verify",
      filename: "/home/runner/work/kbpgp/kbpgp/src/keybase/hilev.iced"
    });
    unbox({
      armored: armored,
      binary: binary,
      require_packet_hash: require_packet_hash
    }, esc(__iced_deferrals1.defer({
      assign_fn: (function() {
        return function() {
          return res = arguments[0];
        };
      })(),
      lineno: 235
    })));
    if (__iced_deferrals1.await_exit()) {
      yield;
    }
    if (!res.km.check_public_eq(km)) {
      err = new errors.WrongSigningKeyError("Got wrong signing key");
    }
    return cb(err, res.payload);
  })();
  __iced_it.next();
  return null;
};

get_sig_body = function(arg1) {
  var armored, decoded, err, ref2;
  armored = arg1.armored;
  ref2 = decode_sig({
    armored: armored
  }), err = ref2[0], decoded = ref2[1];
  return [err, decoded != null ? decoded.body : void 0];
};

decode_sig = function(arg1) {
  var armored, decoded;
  armored = arg1.armored;
  decoded = {
    body: Buffer.from(armored, 'base64'),
    type: C.message_types.generic,
    payload: armored
  };
  return [null, decoded];
};

SignatureEngine = (function(superClass) {
  extend(SignatureEngine, superClass);

  function SignatureEngine(arg1) {
    this.km = arg1.km;
  }

  SignatureEngine.prototype.get_km = function() {
    return this.km;
  };

  SignatureEngine.prototype.get_unverified_payload_from_raw_sig_body = function(arg1, cb) {
    var __iced_it, __iced_passed_deferral, body, esc, packet, rawobj, require_packet_hash;
    body = arg1.body, require_packet_hash = arg1.require_packet_hash;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function*() {
      var __iced_deferrals, __iced_deferrals1;
      esc = make_esc(cb, "get_payload_from_raw_sig_body");
      __iced_deferrals = new iced.Deferrals(__iced_it, {
        parent: __iced_passed_deferral,
        funcname: "SignatureEngine::get_unverified_payload_from_raw_sig_body",
        filename: "/home/runner/work/kbpgp/kbpgp/src/keybase/hilev.iced"
      });
      akatch((function() {
        return encode.unseal(body, {
          strict: require_packet_hash
        });
      }), esc(__iced_deferrals.defer({
        assign_fn: (function() {
          return function() {
            return rawobj = arguments[0];
          };
        })(),
        lineno: 269
      })));
      if (__iced_deferrals.await_exit()) {
        yield;
      }
      __iced_deferrals1 = new iced.Deferrals(__iced_it, {
        parent: __iced_passed_deferral,
        funcname: "SignatureEngine::get_unverified_payload_from_raw_sig_body",
        filename: "/home/runner/work/kbpgp/kbpgp/src/keybase/hilev.iced"
      });
      asyncify(alloc(rawobj), esc(__iced_deferrals1.defer({
        assign_fn: (function() {
          return function() {
            return packet = arguments[0];
          };
        })(),
        lineno: 270
      })));
      if (__iced_deferrals1.await_exit()) {
        yield;
      }
      return cb(null, packet.payload);
    })();
    __iced_it.next();
    return null;
  };

  SignatureEngine.prototype.get_body = function(args, cb) {
    var err, ref2, res;
    ref2 = get_sig_body(args, cb), err = ref2[0], res = ref2[1];
    return cb(err, res);
  };

  SignatureEngine.prototype.box = function(msg, cb, arg1) {
    var __iced_it, __iced_passed_deferral, dohash, prefix, ref2;
    ref2 = arg1 != null ? arg1 : {}, prefix = ref2.prefix, dohash = ref2.dohash;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var armored, esc, out, raw, sig;
      return function*() {
        var __iced_deferrals;
        esc = make_esc(cb, "SignatureEngine::box");
        __iced_deferrals = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "SignatureEngine::box",
          filename: "/home/runner/work/kbpgp/kbpgp/src/keybase/hilev.iced"
        });
        box({
          msg: msg,
          prefix: prefix,
          sign_with: _this.km,
          dohash: dohash
        }, esc(__iced_deferrals.defer({
          assign_fn: (function() {
            return function() {
              armored = arguments[0];
              raw = arguments[1];
              return sig = arguments[2];
            };
          })(),
          lineno: 283
        })));
        if (__iced_deferrals.await_exit()) {
          yield;
        }
        out = {
          type: "kb",
          armored: armored,
          kb: armored,
          raw: raw,
          sig: sig
        };
        return cb(null, out);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  SignatureEngine.prototype.unbox = function(msg, cb, opts) {
    var __iced_it, __iced_passed_deferral;
    if (opts == null) {
      opts = {};
    }
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var a, arg, b, binary, err, esc, payload, res;
      return function*() {
        var __iced_deferrals;
        esc = make_esc(cb, "SignatureEngine::unbox");
        err = payload = null;
        arg = Buffer.isBuffer(msg) ? {
          binary: msg
        } : {
          armored: msg
        };
        arg.prefix = opts.prefix;
        arg.require_packet_hash = opts.require_packet_hash;
        __iced_deferrals = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "SignatureEngine::unbox",
          filename: "/home/runner/work/kbpgp/kbpgp/src/keybase/hilev.iced"
        });
        unbox(arg, esc(__iced_deferrals.defer({
          assign_fn: (function() {
            return function() {
              res = arguments[0];
              return binary = arguments[1];
            };
          })(),
          lineno: 296
        })));
        if (__iced_deferrals.await_exit()) {
          yield;
        }
        if (!res.km.eq(_this.km)) {
          a = res.km.get_ekid().toString('hex');
          b = _this.km.get_ekid().toString('hex');
          err = new errors.WrongSigningKeyError("Got wrong signing key");
        } else {
          payload = res.payload;
        }
        return cb(err, payload, binary);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  return SignatureEngine;

})(SignatureEngineInterface);

module.exports = {
  box: box,
  unbox: unbox,
  unbox_decode: unbox_decode,
  KeyManager: KeyManager,
  EncKeyManager: EncKeyManager,
  decode_sig: decode_sig,
  get_sig_body: get_sig_body,
  encode: encode,
  verify: verify
};

//# sourceMappingURL=hilev.js.map
