// Generated by IcedCoffeeScript 112.8.1
var BaseKey, BaseKeyPair, C, ECDH, Pair, Priv, Pub, SRF, SlicerBuffer, iced, kbnacl, konst, ref, uint_to_buffer, util,
  extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty;

iced = require('iced-runtime-3');

kbnacl = require('keybase-nacl');

SlicerBuffer = require('../openpgp/buffer').SlicerBuffer;

uint_to_buffer = require('../util').uint_to_buffer;

ref = require('../basekeypair'), BaseKeyPair = ref.BaseKeyPair, BaseKey = ref.BaseKey;

SRF = require('../rand').SRF;

ECDH = require('./ecdh').ECDH;

util = require('../util');

konst = require('../const');

C = konst.openpgp;

Pub = (function(superClass) {
  extend(Pub, superClass);

  Pub.type = C.public_key_algorithms.EDDSA;

  Pub.prototype.type = Pub.type;

  Pub.OID = Buffer.from([0x2B, 0x06, 0x01, 0x04, 0x01, 0xDA, 0x47, 0x0F, 0x01]);

  Pub.prototype.OID = Pub.OID;

  Pub.MPI_LENGTH_HEADERS = Buffer.from([0x1, 0x7, 0x40]);

  Pub.prototype.MPI_LENGTH_HEADERS = Pub.MPI_LENGTH_HEADERS;

  function Pub(arg) {
    this.key = arg.key;
  }

  Pub.prototype.nbits = function() {
    return 255;
  };

  Pub.prototype.read_params = function(sb) {};

  Pub.prototype.trunc_hash = function(h) {
    return bn.bn_from_left_n_bits(h, this.nbits());
  };

  Pub.prototype.serialize = function() {
    var ret;
    ret = Buffer.concat([Buffer.from([this.OID.length]), this.OID, this.MPI_LENGTH_HEADERS, this.key]);
    return ret;
  };

  Pub._alloc = function(raw) {
    var expected, key, l, len, mpi_length_headers, oid, pre, pub, sb;
    sb = new SlicerBuffer(raw);
    pre = sb.rem();
    l = sb.read_uint8();
    oid = sb.read_buffer(l);
    expected = Pub.OID;
    if (!util.bufeq_secure(oid, expected)) {
      throw new Error("Wrong OID in EdDSA key");
    }
    mpi_length_headers = sb.read_buffer(Pub.MPI_LENGTH_HEADERS.length);
    if (!util.bufeq_secure(mpi_length_headers, Pub.MPI_LENGTH_HEADERS)) {
      throw new Error("Wrong MPI length headers");
    }
    key = sb.read_buffer(kbnacl.sign.publicKeyLength);
    pub = new Pub({
      key: key
    });
    len = pre - sb.rem();
    return [pub, len];
  };

  Pub.alloc = function(raw) {
    var e, err, len, pub, ref1;
    pub = len = err = null;
    try {
      ref1 = Pub._alloc(raw), pub = ref1[0], len = ref1[1];
    } catch (error) {
      e = error;
      err = e;
    }
    return [err, pub, len];
  };

  Pub.prototype.verify = function(arg, payload, cb) {
    var _, err, naclw, r, ref1, s, sig;
    r = arg[0], s = arg[1];
    naclw = kbnacl.alloc({
      publicKey: this.key
    });
    r = util.fit_to_size(kbnacl.sign.signatureLength / 2, r);
    s = util.fit_to_size(kbnacl.sign.signatureLength / 2, s);
    sig = Buffer.concat([r, s]);
    ref1 = naclw.verify({
      payload: payload,
      sig: sig,
      detached: true
    }), err = ref1[0], _ = ref1[1];
    return cb(err);
  };

  return Pub;

})(BaseKey);

Priv = (function(superClass) {
  extend(Priv, superClass);

  function Priv(arg) {
    this.seed = arg.seed, this.key = arg.key, this.pub = arg.pub;
  }

  Priv._alloc = function(raw, pub) {
    var key_len, len, m, n, pre, priv, publicKey, ref1, sb, secretKey, seed;
    sb = new SlicerBuffer(raw);
    pre = sb.rem();
    key_len = Math.ceil(sb.read_uint16() / 8);
    if ((n = key_len) !== (m = kbnacl.sign.seedLength)) {
      throw new Error("Expected " + m + " bytes for EDDSA priv key, got " + n + ".");
    }
    seed = sb.read_buffer(key_len);
    ref1 = kbnacl.alloc({}).genFromSeed({
      seed: seed
    }), publicKey = ref1.publicKey, secretKey = ref1.secretKey;
    if (!util.bufeq_secure(pub.key, publicKey)) {
      throw new Error('Loaded EDDSA private key but it does not match the public key.');
    }
    priv = new Priv({
      seed: seed,
      key: Buffer.from(secretKey),
      pub: pub
    });
    len = pre - sb.rem();
    return [priv, len];
  };

  Priv.alloc = function(raw, pub) {
    var e, err, len, priv, ref1;
    priv = len = err = null;
    try {
      ref1 = Priv._alloc(raw, pub), priv = ref1[0], len = ref1[1];
    } catch (error) {
      e = error;
      err = e;
    }
    return [err, priv, len];
  };

  Priv.prototype.sign = function(h, cb) {
    var len, nacl, ret;
    nacl = kbnacl.alloc({
      secretKey: this.key
    });
    ret = nacl.sign({
      payload: h
    });
    len = kbnacl.sign.signatureLength / 2;
    return cb([Buffer.from(ret.slice(0, len)), Buffer.from(ret.slice(len, len * 2))]);
  };

  Priv.prototype.serialize = function() {
    return Buffer.concat([uint_to_buffer(16, kbnacl.sign.seedLength * 8), this.seed]);
  };

  return Priv;

})(BaseKey);

Pair = (function(superClass) {
  extend(Pair, superClass);

  Pair.Pub = Pub;

  Pair.prototype.Pub = Pub;

  Pair.Priv = Priv;

  Pair.prototype.Priv = Priv;

  Pair.type = C.public_key_algorithms.EDDSA;

  Pair.prototype.type = Pair.type;

  Pair.klass_name = "EDDSA";

  Pair.prototype.get_type = function() {
    return this.type;
  };

  function Pair(arg) {
    var priv, pub;
    pub = arg.pub, priv = arg.priv;
    Pair.__super__.constructor.call(this, {
      pub: pub,
      priv: priv
    });
  }

  Pair.parse = function(pub_raw) {
    return BaseKeyPair.parse(Pair, pub_raw);
  };

  Pair.prototype.can_encrypt = function() {
    return false;
  };

  Pair.subkey_algo = function(flags) {
    if (flags & (C.key_flags.certify_keys | C.key_flags.sign_data)) {
      return Pair;
    } else {
      return ECDH;
    }
  };

  Pair.prototype.fulfills_flags = function(flags) {
    var good_for;
    good_for = C.key_flags.certify_keys | C.key_flags.sign_data;
    return (flags & good_for) === flags;
  };

  Pair.prototype.verify_unpad_and_check_hash = function(arg, cb) {
    var data, hash, hasher, sig;
    sig = arg.sig, data = arg.data, hasher = arg.hasher, hash = arg.hash;
    return this._dsa_verify_update_and_check_hash({
      sig: sig,
      data: data,
      hasher: hasher,
      hash: hash,
      klass: Pair
    }, cb);
  };

  Pair.prototype.pad_and_sign = function(data, arg, cb) {
    var __iced_it, __iced_passed_deferral, hasher;
    hasher = arg.hasher;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var h, r, s, sig;
      return function*() {
        var __iced_deferrals;
        hasher || (hasher = SHA512);
        h = hasher(data);
        __iced_deferrals = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "Pair::pad_and_sign",
          filename: "/home/runner/work/kbpgp/kbpgp/src/ecc/eddsa.iced"
        });
        _this.priv.sign(h, __iced_deferrals.defer({
          assign_fn: (function() {
            return function() {
              return sig = arguments[0];
            };
          })(),
          lineno: 211
        }));
        if (__iced_deferrals.await_exit()) {
          yield;
        }
        r = sig[0], s = sig[1];
        return cb(null, Buffer.concat([uint_to_buffer(16, r.length * 8), r, uint_to_buffer(16, s.length * 8), s]));
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  Pair.parse_sig = function(slice) {
    var buf, err, n, ref1, ret;
    buf = slice.peek_rest_to_buffer();
    ref1 = Pair.read_sig_from_buf(buf), err = ref1[0], ret = ref1[1], n = ref1[2];
    if (err != null) {
      throw err;
    }
    slice.advance(n);
    return ret;
  };

  Pair.eddsa_value_from_buffer = function(buf) {
    var bits, bytes_len, err, ret;
    err = ret = null;
    if ((bits = buf.readUInt16BE(0)) > 0x100 || bits < (0x100 - 40)) {
      err = new Error("Got an unexpected number of Bits for an EdDSA value: " + bits);
    } else {
      bytes_len = 2 + Math.ceil(bits / 8);
      ret = buf.slice(2, bytes_len);
      buf = buf.slice(bytes_len);
    }
    return [err, ret, buf];
  };

  Pair.read_sig_from_buf = function(buf) {
    var bufs, err, n, o, order, orig_len, ret, x;
    orig_len = buf.length;
    order = ['r', 's'];
    err = null;
    bufs = (function() {
      var i, len1, ref1, results;
      results = [];
      for (i = 0, len1 = order.length; i < len1; i++) {
        o = order[i];
        if (!(err == null)) {
          continue;
        }
        ref1 = Pair.eddsa_value_from_buffer(buf), err = ref1[0], x = ref1[1], buf = ref1[2];
        results.push(x);
      }
      return results;
    })();
    n = orig_len - buf.length;
    ret = err != null ? null : bufs;
    return [err, ret, n];
  };

  Pair.alloc = function(klass, raw) {
    var e, err, len, pub, ref1;
    pub = len = err = null;
    try {
      ref1 = Pub.alloc(raw), pub = ref1[0], len = ref1[1];
    } catch (error) {
      e = error;
      err = e;
    }
    return [err, pub, len];
  };

  Pair.prototype.good_for_flags = function() {
    return C.key_flags.certify_keys | C.key_flags.sign_data;
  };

  Pair.generate = function(arg, cb) {
    var __iced_it, __iced_passed_deferral, asp, nbits, priv, pub, publicKey, ret, secretKey, seed;
    nbits = arg.nbits, asp = arg.asp;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function*() {
      var __iced_deferrals, ref1;
      __iced_deferrals = new iced.Deferrals(__iced_it, {
        parent: __iced_passed_deferral,
        funcname: "Pair::@generate",
        filename: "/home/runner/work/kbpgp/kbpgp/src/ecc/eddsa.iced"
      });
      SRF().random_bytes(kbnacl.sign.seedLength, __iced_deferrals.defer({
        assign_fn: (function() {
          return function() {
            return seed = arguments[0];
          };
        })(),
        lineno: 283
      }));
      if (__iced_deferrals.await_exit()) {
        yield;
      }
      ref1 = kbnacl.alloc({}).genFromSeed({
        seed: seed
      }), publicKey = ref1.publicKey, secretKey = ref1.secretKey;
      pub = new Pub({
        key: Buffer.from(publicKey)
      });
      priv = new Priv({
        seed: seed,
        key: Buffer.from(secretKey),
        pub: pub
      });
      ret = new Pair({
        pub: pub,
        priv: priv
      });
      return cb(null, ret);
    })();
    __iced_it.next();
    return null;
  };

  return Pair;

})(BaseKeyPair);

exports.EDDSA = exports.Pair = Pair;

//# sourceMappingURL=eddsa.js.map
