// Generated by IcedCoffeeScript 112.8.1
var ASP, BaseEccKey, BaseKey, BaseKeyPair, BigInteger, C, ECDH, K, Pair, Priv, Pub, bn, bufeq_secure, generate, iced, konst, make_esc, nbits, nbv, ref, ref1, ref2, uint_to_buffer,
  extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty;

iced = require('iced-runtime-3');

bn = require('../bn');

nbits = bn.nbits, nbv = bn.nbv, BigInteger = bn.BigInteger;

ref = require('../util'), uint_to_buffer = ref.uint_to_buffer, bufeq_secure = ref.bufeq_secure, ASP = ref.ASP;

make_esc = require('iced-error').make_esc;

konst = require('../const');

C = konst.openpgp;

K = konst.kb;

ref1 = require('../basekeypair'), BaseKeyPair = ref1.BaseKeyPair, BaseKey = ref1.BaseKey;

ref2 = require('./base'), generate = ref2.generate, BaseEccKey = ref2.BaseEccKey;

ECDH = require('./ecdh').ECDH;

Pub = (function(superClass) {
  extend(Pub, superClass);

  function Pub() {
    return Pub.__super__.constructor.apply(this, arguments);
  }

  Pub.type = C.public_key_algorithms.ECDSA;

  Pub.prototype.type = Pub.type;

  Pub.prototype.nbits = function() {
    return this.curve.nbits();
  };

  Pub.prototype.read_params = function(sb) {};

  Pub.prototype.trunc_hash = function(h) {
    return bn.bn_from_left_n_bits(h, this.nbits());
  };

  Pub.alloc = function(raw) {
    return BaseEccKey.alloc(Pub, raw);
  };

  Pub.prototype.verify = function(arg, h, cb) {
    var err, hi, n, p, r, s, u1, u2, v, w;
    r = arg[0], s = arg[1];
    err = null;
    hi = this.trunc_hash(h);
    if ((r.signum() <= 0) || (r.compareTo(this.curve.p) > 0)) {
      err = new Error("bad r");
    } else if ((r.signum() <= 0) || (s.compareTo(this.curve.p) > 0)) {
      err = new Error("bad s");
    } else {
      n = this.curve.n;
      w = s.modInverse(n);
      u1 = hi.multiply(w).mod(n);
      u2 = r.multiply(w).mod(n);
      p = this.curve.G.multiplyTwo(u1, this.R, u2);
      v = p.affineX.mod(n);
      if (!v.equals(r)) {
        err = new Error("verification failed");
      }
    }
    return cb(err);
  };

  return Pub;

})(BaseEccKey);

Priv = (function(superClass) {
  extend(Priv, superClass);

  Priv.ORDER = ['x'];

  Priv.prototype.ORDER = Priv.ORDER;

  function Priv(arg) {
    this.x = arg.x, this.pub = arg.pub;
  }

  Priv.alloc = function(raw, pub) {
    return BaseKey.alloc(Priv, raw, {
      pub: pub
    });
  };

  Priv.prototype.sign = function(h, cb) {
    var __iced_it, __iced_passed_deferral;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var G, Q, err, hi, k, n, r, s;
      return function*() {
        var __iced_deferrals, ref3;
        err = null;
        ref3 = _this.pub.curve, n = ref3.n, G = ref3.G;
        hi = _this.pub.trunc_hash(h);
        __iced_deferrals = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "Priv::sign",
          filename: "/home/runner/work/kbpgp/kbpgp/src/ecc/ecdsa.iced"
        });
        _this.pub.curve.random_scalar(__iced_deferrals.defer({
          assign_fn: (function() {
            return function() {
              return k = arguments[0];
            };
          })(),
          lineno: 79
        }));
        if (__iced_deferrals.await_exit()) {
          yield;
        }
        Q = G.multiply(k);
        r = Q.affineX.mod(n);
        if (r.signum() === 0) {
          throw new Error("invalid r-value");
        }
        s = k.modInverse(n).multiply(hi.add(_this.x.multiply(r))).mod(n);
        return cb([r, s]);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  return Priv;

})(BaseKey);

Pair = (function(superClass) {
  extend(Pair, superClass);

  Pair.Pub = Pub;

  Pair.prototype.Pub = Pub;

  Pair.Priv = Priv;

  Pair.prototype.Priv = Priv;

  Pair.type = C.public_key_algorithms.ECDSA;

  Pair.prototype.type = Pair.type;

  Pair.klass_name = "ECDSA";

  Pair.prototype.get_type = function() {
    return this.type;
  };

  function Pair(arg) {
    var priv, pub;
    pub = arg.pub, priv = arg.priv;
    Pair.__super__.constructor.call(this, {
      pub: pub,
      priv: priv
    });
  }

  Pair.parse = function(pub_raw) {
    return BaseKeyPair.parse(Pair, pub_raw);
  };

  Pair.prototype.can_encrypt = function() {
    return false;
  };

  Pair.subkey_algo = function(flags) {
    if (flags & (C.key_flags.certify_keys | C.key_flags.sign_data)) {
      return Pair;
    } else {
      return ECDH;
    }
  };

  Pair.prototype.fulfills_flags = function(flags) {
    var good_for;
    good_for = C.key_flags.certify_keys | C.key_flags.sign_data;
    return (flags & good_for) === flags;
  };

  Pair.prototype.verify_unpad_and_check_hash = function(arg, cb) {
    var data, hash, hasher, sig;
    sig = arg.sig, data = arg.data, hasher = arg.hasher, hash = arg.hash;
    return this._dsa_verify_update_and_check_hash({
      sig: sig,
      data: data,
      hasher: hasher,
      hash: hash,
      klass: Pair
    }, cb);
  };

  Pair.prototype.pad_and_sign = function(data, arg, cb) {
    var __iced_it, __iced_passed_deferral, hasher;
    hasher = arg.hasher;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var h, s, sig;
      return function*() {
        var __iced_deferrals;
        hasher || (hasher = SHA512);
        h = hasher(data);
        __iced_deferrals = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "Pair::pad_and_sign",
          filename: "/home/runner/work/kbpgp/kbpgp/src/ecc/ecdsa.iced"
        });
        _this.priv.sign(h, __iced_deferrals.defer({
          assign_fn: (function() {
            return function() {
              return sig = arguments[0];
            };
          })(),
          lineno: 134
        }));
        if (__iced_deferrals.await_exit()) {
          yield;
        }
        return cb(null, Buffer.concat((function() {
          var i, len, results;
          results = [];
          for (i = 0, len = sig.length; i < len; i++) {
            s = sig[i];
            results.push(s.to_mpi_buffer());
          }
          return results;
        })()));
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  Pair.parse_sig = function(slice) {
    var buf, err, n, ref3, ret;
    buf = slice.peek_rest_to_buffer();
    ref3 = Pair.read_sig_from_buf(buf), err = ref3[0], ret = ref3[1], n = ref3[2];
    if (err != null) {
      throw err;
    }
    slice.advance(n);
    return ret;
  };

  Pair.read_sig_from_buf = function(buf) {
    var err, n, o, order, orig_len, ret, x;
    orig_len = buf.length;
    order = ['r', 's'];
    err = null;
    ret = (function() {
      var i, len, ref3, results;
      results = [];
      for (i = 0, len = order.length; i < len; i++) {
        o = order[i];
        if (!(err == null)) {
          continue;
        }
        ref3 = bn.mpi_from_buffer(buf), err = ref3[0], x = ref3[1], buf = ref3[2];
        results.push(x);
      }
      return results;
    })();
    n = orig_len - buf.length;
    return [err, ret, n];
  };

  Pair.prototype.good_for_flags = function() {
    return C.key_flags.certify_keys | C.key_flags.sign_data;
  };

  Pair.generate = function(arg, cb) {
    var asp, nbits;
    nbits = arg.nbits, asp = arg.asp;
    return generate({
      nbits: nbits,
      asp: asp,
      Pair: Pair
    }, cb);
  };

  return Pair;

})(BaseKeyPair);

exports.ECDSA = exports.Pair = Pair;

//# sourceMappingURL=ecdsa.js.map
