// Generated by IcedCoffeeScript 112.8.1
var ASP, BaseEccKey, BaseKey, BaseKeyPair, Const, Output, Pair, Priv, Pub, SlicerBuffer, bufeq_secure, ecc_pkcs5_pad_data, generate, hashmod, iced, konst, make_esc, ref, ref1, ref2, ref3, sym, uint_to_buffer, unwrap, wrap,
  extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty;

iced = require('iced-runtime-3');

ref = require('../util'), uint_to_buffer = ref.uint_to_buffer, bufeq_secure = ref.bufeq_secure, ASP = ref.ASP;

make_esc = require('iced-error').make_esc;

konst = require('../const');

Const = konst.openpgp;

ref1 = require('../basekeypair'), BaseKeyPair = ref1.BaseKeyPair, BaseKey = ref1.BaseKey;

ecc_pkcs5_pad_data = require('../pad').ecc_pkcs5_pad_data;

ref2 = require('./base'), generate = ref2.generate, BaseEccKey = ref2.BaseEccKey;

hashmod = require('../hash');

sym = require('../symmetric');

SlicerBuffer = require('../openpgp/buffer').SlicerBuffer;

ref3 = require('../rfc3394'), wrap = ref3.wrap, unwrap = ref3.unwrap;

Pub = (function(superClass) {
  extend(Pub, superClass);

  function Pub() {
    return Pub.__super__.constructor.apply(this, arguments);
  }

  Pub.type = Const.public_key_algorithms.ECDH;

  Pub.prototype.type = Pub.type;

  Pub.prototype.apply_defaults = function() {
    this.cipher || (this.cipher = sym.get_cipher());
    return this.hasher || (this.hasher = hashmod.SHA512);
  };

  Pub.prototype.read_params = function(sb) {
    var n, size, v, val;
    if ((size = sb.read_uint8()) < (n = Const.ecdh.param_bytes)) {
      throw new Error("Need at least " + n + " bytes of params; got " + size);
    }
    if ((val = sb.read_uint8()) !== (v = Const.ecdh.version)) {
      throw new Error("Cannot deal with future extensions, byte=" + val + "; wanted " + v);
    }
    this.hasher = hashmod.alloc_or_throw(sb.read_uint8());
    this.cipher = sym.get_cipher(sb.read_uint8());
    return sb.advance(size - 3);
  };

  Pub.alloc = function(raw) {
    return BaseEccKey.alloc(Pub, raw);
  };

  Pub.prototype.serialize_params = function() {
    return Buffer.concat([uint_to_buffer(8, Const.ecdh.param_bytes), uint_to_buffer(8, Const.ecdh.version), uint_to_buffer(8, this.hasher.type), uint_to_buffer(8, this.cipher.type)]);
  };

  Pub.prototype.serialize = function() {
    return Buffer.concat([Pub.__super__.serialize.call(this), this.serialize_params()]);
  };

  Pub.prototype.format_params = function(arg) {
    var fingerprint;
    fingerprint = arg.fingerprint;
    return Buffer.concat([uint_to_buffer(8, this.curve.oid.length), this.curve.oid, uint_to_buffer(8, this.type), this.serialize_params(), Buffer.from("Anonymous Sender    ", "utf8"), fingerprint]);
  };

  Pub.prototype.kdf = function(arg) {
    var X, X_compact, buf, hash, o_bytes, params;
    X = arg.X, params = arg.params;
    o_bytes = this.cipher.key_size;
    X_compact = this.curve.point_to_mpi_buffer_compact(X);
    buf = Buffer.concat([Buffer.from([0, 0, 0, 1]), X_compact, params]);
    hash = this.hasher(buf);
    return hash.slice(0, o_bytes);
  };

  Pub.prototype.encrypt = function(m, arg, cb) {
    var __iced_it, __iced_passed_deferral, fingerprint;
    fingerprint = arg.fingerprint;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var C, S, V, key, params;
      return function*() {
        var __iced_deferrals;
        __iced_deferrals = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "Pub::encrypt",
          filename: "/home/runner/work/kbpgp/kbpgp/src/ecc/ecdh.iced"
        });
        _this.curve.encrypt(_this.R, __iced_deferrals.defer({
          assign_fn: (function() {
            return function() {
              V = arguments[0].V;
              return S = arguments[0].S;
            };
          })(),
          lineno: 97
        }));
        if (__iced_deferrals.await_exit()) {
          yield;
        }
        params = _this.format_params({
          fingerprint: fingerprint
        });
        key = _this.kdf({
          X: S,
          params: params
        });
        C = wrap({
          key: key,
          plaintext: m,
          cipher: _this.cipher
        });
        return cb({
          V: V,
          C: C
        });
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  return Pub;

})(BaseEccKey);

Priv = (function(superClass) {
  extend(Priv, superClass);

  Priv.ORDER = ['x'];

  Priv.prototype.ORDER = Priv.ORDER;

  function Priv(arg) {
    this.x = arg.x, this.pub = arg.pub;
  }

  Priv.prototype.serialize = function() {
    var curve;
    curve = this.pub.curve;
    return curve.coord_to_mpi_buffer(this.x);
  };

  Priv.alloc = function(raw, pub) {
    var curve, d, err, i, len, o, orig_len, ref4, ref5;
    orig_len = raw.length;
    err = null;
    curve = pub.curve;
    d = {
      pub: pub
    };
    ref4 = Priv.ORDER;
    for (i = 0, len = ref4.length; i < len; i++) {
      o = ref4[i];
      if (err == null) {
        ref5 = curve.mpi_from_buffer(raw), err = ref5[0], d[o] = ref5[1], raw = ref5[2];
      }
    }
    if (err) {
      return [err, null];
    } else {
      return [null, new Priv(d), orig_len - raw.length];
    }
  };

  Priv.prototype.decrypt = function(c, arg, cb) {
    var __iced_it, __iced_passed_deferral, fingerprint;
    fingerprint = arg.fingerprint;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var S, V, curve, err, esc, key, params, ret;
      return function*() {
        var __iced_deferrals, ref4;
        esc = make_esc(cb, "Priv::decrypt");
        curve = _this.pub.curve;
        __iced_deferrals = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "Priv::decrypt",
          filename: "/home/runner/work/kbpgp/kbpgp/src/ecc/ecdh.iced"
        });
        c.load_V(curve, esc(__iced_deferrals.defer({
          assign_fn: (function() {
            return function() {
              return V = arguments[0];
            };
          })(),
          lineno: 144
        })));
        if (__iced_deferrals.await_exit()) {
          yield;
        }
        S = curve.decrypt(_this.x, V);
        params = _this.pub.format_params({
          fingerprint: fingerprint
        });
        key = _this.pub.kdf({
          X: S,
          params: params
        });
        ref4 = unwrap({
          key: key,
          ciphertext: c.C,
          cipher: _this.pub.cipher
        }), err = ref4[0], ret = ref4[1];
        return cb(err, ret);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  return Priv;

})(BaseKey);

Pair = (function(superClass) {
  extend(Pair, superClass);

  function Pair() {
    return Pair.__super__.constructor.apply(this, arguments);
  }

  Pair.Pub = Pub;

  Pair.prototype.Pub = Pub;

  Pair.Priv = Priv;

  Pair.prototype.Priv = Priv;

  Pair.type = Const.public_key_algorithms.ECDH;

  Pair.prototype.type = Pair.type;

  Pair.klass_name = "ECDH";

  Pair.prototype.get_type = function() {
    return this.type;
  };

  Pair.prototype.fulfills_flags = function(flags) {
    var good_for;
    good_for = Const.key_flags.encrypt_comm | Const.key_flags.encrypt_storage;
    return (flags & good_for) === flags;
  };

  Pair.prototype.can_sign = function() {
    return false;
  };

  Pair.parse = function(pub_raw) {
    var ret;
    ret = BaseKeyPair.parse(Pair, pub_raw);
    return ret;
  };

  Pair.prototype.max_value = function() {
    return this.pub.p;
  };

  Pair.prototype.pad_and_encrypt = function(data, arg, cb) {
    var __iced_it, __iced_passed_deferral, fingerprint;
    fingerprint = arg.fingerprint;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var C, V, err, m, ret;
      return function*() {
        var __iced_deferrals, ref4;
        err = ret = null;
        ref4 = ecc_pkcs5_pad_data(data), err = ref4[0], m = ref4[1];
        if (err == null) {
          __iced_deferrals = new iced.Deferrals(__iced_it, {
            parent: __iced_passed_deferral,
            funcname: "Pair::pad_and_encrypt",
            filename: "/home/runner/work/kbpgp/kbpgp/src/ecc/ecdh.iced"
          });
          _this.pub.encrypt(m, {
            fingerprint: fingerprint
          }, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                C = arguments[0].C;
                return V = arguments[0].V;
              };
            })(),
            lineno: 199
          }));
          if (__iced_deferrals.await_exit()) {
            yield;
          }
          ret = _this.export_output({
            C: C,
            V: V,
            curve: _this.pub.curve
          });
        }
        return cb(err, ret);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  Pair.prototype.decrypt_and_unpad = function(ciphertext, arg, cb) {
    var __iced_it, __iced_passed_deferral, fingerprint;
    fingerprint = arg.fingerprint;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var err, m, ret;
      return function*() {
        var __iced_deferrals;
        err = ret = null;
        __iced_deferrals = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "Pair::decrypt_and_unpad",
          filename: "/home/runner/work/kbpgp/kbpgp/src/ecc/ecdh.iced"
        });
        _this.priv.decrypt(ciphertext, {
          fingerprint: fingerprint
        }, __iced_deferrals.defer({
          assign_fn: (function() {
            return function() {
              err = arguments[0];
              return m = arguments[1];
            };
          })(),
          lineno: 207
        }));
        if (__iced_deferrals.await_exit()) {
          yield;
        }
        return cb(err, m, true);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  Pair.parse_output = function(buf) {
    return Output.parse(buf);
  };

  Pair.prototype.export_output = function(args) {
    return new Output(args);
  };

  Pair.generate = function(arg, cb) {
    var __iced_it, __iced_passed_deferral, asp, curve_name, err, nbits, pair;
    nbits = arg.nbits, curve_name = arg.curve_name, asp = arg.asp;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function*() {
      var __iced_deferrals;
      __iced_deferrals = new iced.Deferrals(__iced_it, {
        parent: __iced_passed_deferral,
        funcname: "Pair::@generate",
        filename: "/home/runner/work/kbpgp/kbpgp/src/ecc/ecdh.iced"
      });
      generate({
        nbits: nbits,
        asp: asp,
        curve_name: curve_name,
        Pair: Pair
      }, __iced_deferrals.defer({
        assign_fn: (function() {
          return function() {
            err = arguments[0];
            return pair = arguments[1];
          };
        })(),
        lineno: 218
      }));
      if (__iced_deferrals.await_exit()) {
        yield;
      }
      if (err == null) {
        pair.pub.apply_defaults();
      }
      return cb(err, pair);
    })();
    __iced_it.next();
    return null;
  };

  return Pair;

})(BaseKeyPair);

Output = (function() {
  function Output(arg) {
    this.V_buf = arg.V_buf, this.C = arg.C, this.V = arg.V, this.curve = arg.curve;
  }

  Output.prototype.load_V = function(curve, cb) {
    var err, ref4;
    this.curve = curve;
    ref4 = curve.mpi_point_from_buffer(this.V_buf), err = ref4[0], this.V = ref4[1];
    return cb(err, this.V);
  };

  Output.parse = function(buf) {
    var C, V_buf, a, n_bits, n_bytes, ret, sb;
    sb = new SlicerBuffer(buf);
    n_bits = sb.read_uint16();
    n_bytes = Math.ceil(n_bits / 8);
    V_buf = Buffer.concat([buf.slice(0, 2), sb.read_buffer(n_bytes)]);
    n_bytes = sb.read_uint8();
    C = sb.consume_rest_to_buffer();
    if ((a = C.length) !== n_bytes) {
      throw new Error("bad C input: wanted " + n_bytes + " bytes, but got " + a);
    }
    ret = new Output({
      V_buf: V_buf,
      C: C
    });
    return ret;
  };

  Output.prototype.get_V_buf = function() {
    if (this.V_buf == null) {
      this.V_buf = this.curve.point_to_mpi_buffer(this.V);
    }
    return this.V_buf;
  };

  Output.prototype.hide = function(arg, cb) {
    var key, max, slosh;
    key = arg.key, max = arg.max, slosh = arg.slosh;
    return cb(null);
  };

  Output.prototype.find = function(arg) {
    var key;
    key = arg.key;
  };

  Output.prototype.good_for_flags = function() {
    return C.key_flags.encrypt_comm | C.key_flags.encrypt_storage;
  };

  Output.prototype.output = function() {
    return Buffer.concat([this.get_V_buf(), uint_to_buffer(8, this.C.length), this.C]);
  };

  return Output;

})();

exports.ECDH = exports.Pair = Pair;

//# sourceMappingURL=ecdh.js.map
