// Generated by IcedCoffeeScript 112.8.1
var BaseKey, BaseKeyPair, C, K, SHA256, SHA512, SRF, bn, bufeq_secure, iced, konst, ref;

iced = require('iced-runtime-3');

konst = require('./const');

C = konst.openpgp;

K = konst.kb;

ref = require('./hash'), SHA256 = ref.SHA256, SHA512 = ref.SHA512;

bn = require('./bn');

bufeq_secure = require('pgp-utils').util.bufeq_secure;

SRF = require('./rand').SRF;

exports.BaseKey = BaseKey = (function() {
  function BaseKey() {}

  BaseKey.alloc = function(klass, raw, d) {
    var err, j, len1, o, orig_len, ref1, ref2;
    if (d == null) {
      d = {};
    }
    orig_len = raw.length;
    err = null;
    ref1 = klass.ORDER;
    for (j = 0, len1 = ref1.length; j < len1; j++) {
      o = ref1[j];
      if (err == null) {
        ref2 = bn.mpi_from_buffer(raw), err = ref2[0], d[o] = ref2[1], raw = ref2[2];
      }
    }
    if (err) {
      return [err, null];
    } else {
      return [null, new klass(d), orig_len - raw.length];
    }
  };

  BaseKey.prototype.serialize = function() {
    var e;
    return Buffer.concat((function() {
      var j, len1, ref1, results;
      ref1 = this.ORDER;
      results = [];
      for (j = 0, len1 = ref1.length; j < len1; j++) {
        e = ref1[j];
        results.push(this[e].to_mpi_buffer());
      }
      return results;
    }).call(this));
  };

  BaseKey.prototype.validity_check = function(cb) {
    return cb(null);
  };

  return BaseKey;

})();

exports.BaseKeyPair = BaseKeyPair = (function() {
  function BaseKeyPair(arg) {
    this.priv = arg.priv, this.pub = arg.pub;
    this.pub.parent = this;
    if (this.priv != null) {
      this.priv.parent = this;
    }
  }

  BaseKeyPair.prototype.serialize = function() {
    return this.pub.serialize();
  };

  BaseKeyPair.prototype.hash = function() {
    return SHA256(this.serialize());
  };

  BaseKeyPair.prototype.ekid = function() {
    return Buffer.concat([Buffer.from([K.kid.version, this.get_type()]), this.hash(), Buffer.from([K.kid.trailer])]);
  };

  BaseKeyPair.prototype.can_sign = function() {
    return this.priv != null;
  };

  BaseKeyPair.prototype.can_decrypt = function() {
    return this.priv != null;
  };

  BaseKeyPair.prototype.has_private = function() {
    return this.priv != null;
  };

  BaseKeyPair.prototype.fulfills_flags = function(flags) {
    return false;
  };

  BaseKeyPair.prototype.is_toxic = function() {
    return false;
  };

  BaseKeyPair.prototype.nbits = function() {
    var ref1;
    return (ref1 = this.pub) != null ? ref1.nbits() : void 0;
  };

  BaseKeyPair.prototype.good_for_flags = function() {
    return C.key_flags.encrypt_comm | C.key_flags.encrypt_storage | C.key_flags.certify_keys | C.key_flags.sign_data;
  };

  BaseKeyPair.prototype.eq = function(k2) {
    return (this.type === k2.type) && (bufeq_secure(this.serialize(), k2.serialize()));
  };

  BaseKeyPair.prototype.can_perform = function(ops_mask) {
    if ((ops_mask & konst.ops.sign) && !this.can_sign()) {
      return false;
    } else if ((ops_mask & konst.ops.decrypt) && !this.can_decrypt()) {
      return false;
    } else {
      return true;
    }
  };

  BaseKeyPair.parse = function(klass, pub_raw) {
    var err, key, len, ref1;
    ref1 = klass.Pub.alloc(pub_raw), err = ref1[0], key = ref1[1], len = ref1[2];
    if (key != null) {
      key = new klass({
        pub: key
      });
    }
    return [err, key, len];
  };

  BaseKeyPair.parse_kb = function(klass, pub_raw) {
    var err, key, len, ref1;
    ref1 = klass.Pub.alloc_kb(pub_raw), err = ref1[0], key = ref1[1], len = ref1[2];
    if (key != null) {
      key = new klass({
        pub: key
      });
    }
    return [err, key, len];
  };

  BaseKeyPair.prototype.add_priv = function(priv_raw) {
    var err, len, ref1;
    ref1 = Priv.alloc(priv_raw), err = ref1[0], this.priv = ref1[1], len = ref1[2];
    return [err, len];
  };

  BaseKeyPair.alloc = function(klass, arg) {
    var err, priv, pub, ref1, ref2;
    pub = arg.pub, priv = arg.priv;
    ref1 = klass.Pub.alloc(pub), err = ref1[0], pub = ref1[1];
    if ((err == null) && (priv != null)) {
      ref2 = klass.Priv.alloc(priv, pub), err = ref2[0], priv = ref2[1];
    }
    if (err != null) {
      return [err, null];
    } else {
      return [
        null, new klass({
          priv: priv,
          pub: pub
        })
      ];
    }
  };

  BaseKeyPair.prototype.read_priv = function(raw_priv) {
    var err, ref1;
    ref1 = this.Priv.alloc(raw_priv, this.pub), err = ref1[0], this.priv = ref1[1];
    return err;
  };

  BaseKeyPair.prototype.find = function(i) {
    return i.mod(this.max_value());
  };

  BaseKeyPair.prototype.hide = function(arg, cb) {
    var __iced_it, __iced_passed_deferral, i, max, slosh;
    i = arg.i, max = arg.max, slosh = arg.slosh;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var L, err, n, r, r_bits, ret;
      return function*() {
        var __iced_deferrals;
        ret = err = null;
        n = _this.max_value();
        if ((L = n.bitLength()) > max) {
          err = new Error("Can't hide > " + max + " bits; got " + L);
        } else {
          r_bits = (max - L) + slosh;
          __iced_deferrals = new iced.Deferrals(__iced_it, {
            parent: __iced_passed_deferral,
            funcname: "BaseKeyPair::hide",
            filename: "/home/runner/work/kbpgp/kbpgp/src/basekeypair.iced"
          });
          SRF().random_nbit(r_bits, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                return r = arguments[0];
              };
            })(),
            lineno: 127
          }));
          if (__iced_deferrals.await_exit()) {
            yield;
          }
          ret = r.multiply(n).add(i);
        }
        return cb(err, ret);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  BaseKeyPair.prototype.validity_check = function(cb) {
    return this.pub.validity_check(cb);
  };

  BaseKeyPair.prototype._dsa_verify_update_and_check_hash = function(arg, cb) {
    var __iced_it, __iced_passed_deferral, data, hash, hasher, klass, sig;
    sig = arg.sig, data = arg.data, hasher = arg.hasher, hash = arg.hash, klass = arg.klass;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var err, v;
      return function*() {
        var __iced_deferrals, ref1;
        err = null;
        if (Buffer.isBuffer(sig)) {
          ref1 = klass.read_sig_from_buf(sig), err = ref1[0], sig = ref1[1];
        }
        hash || (hash = hasher(data));
        if (sig.length !== 2) {
          err = new Error("Need an [r,s] pair for a DSA-style signature");
        } else {
          __iced_deferrals = new iced.Deferrals(__iced_it, {
            parent: __iced_passed_deferral,
            funcname: "BaseKeyPair::_dsa_verify_update_and_check_hash",
            filename: "/home/runner/work/kbpgp/kbpgp/src/basekeypair.iced"
          });
          _this.pub.verify(sig, hash, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                return v = arguments[1];
              };
            })(),
            lineno: 148
          }));
          if (__iced_deferrals.await_exit()) {
            yield;
          }
        }
        return cb(err);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  return BaseKeyPair;

})();

//# sourceMappingURL=basekeypair.js.map
