"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Toml = exports.Json = void 0;
const zod_1 = require("zod");
const toml_eslint_parser_1 = require("toml-eslint-parser");
exports.Json = zod_1.z.string().transform((str, ctx) => {
    try {
        return JSON.parse(str);
    }
    catch (e) {
        ctx.addIssue({ code: 'custom', message: 'Invalid JSON' });
        return zod_1.z.NEVER;
    }
});
exports.Toml = zod_1.z.string().transform((str, ctx) => {
    try {
        const ast = (0, toml_eslint_parser_1.parseTOML)(str);
        const res = (0, toml_eslint_parser_1.getStaticTOMLValue)(ast);
        return res;
    }
    catch (e) {
        ctx.addIssue({ code: 'custom', message: 'Invalid TOML' });
        return zod_1.z.NEVER;
    }
});
